/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.util.MutableDouble;
import jetbrains.datalore.plot.base.util.MutableInteger;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import jetbrains.datalore.plot.builder.sampling.method.VertexSampling;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u0006\u0010\b\u001a\u00020\u0005J(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0011J\u0018\u0010\u0013\u001a\u00020\u00052\u0010\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00050\u0011J\"\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/SamplingUtil;", "", "()V", "calculateRingLimits", "", "", "rings", "Ljetbrains/datalore/base/geometry/DoubleVector;", "totalPointsLimit", "distinctGroups", "", "groupMapper", "Lkotlin/Function1;", "size", "getRingArea", "", "pair", "Lkotlin/Pair;", "getRingIndex", "getRingLimit", "groupCount", "splitRings", "population", "Ljetbrains/datalore/plot/base/DataFrame;", "xVar", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "data", "variables", "", "yVar", "plot-builder-portable"})
public final class SamplingUtil {
    @NotNull
    public static final SamplingUtil INSTANCE = new SamplingUtil();

    private SamplingUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final int groupCount(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = ((Number)groupMapper2.invoke((Object)((int)it))).intValue();
            collection.add(n2);
        }
        Collection collection = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        return collection.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> distinctGroups(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = ((Number)groupMapper2.invoke((Object)((int)it))).intValue();
            collection.add(n2);
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public final DataFrame.Variable xVar(@NotNull Set<DataFrame.Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return variables.contains(Stats.INSTANCE.getX()) ? Stats.INSTANCE.getX() : (variables.contains(TransformVar.INSTANCE.getX()) ? TransformVar.INSTANCE.getX() : null);
    }

    @NotNull
    public final DataFrame.Variable xVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DataFrame.Variable variable = this.xVar(data.variables());
        if (variable == null) {
            throw new IllegalStateException("Can't apply sampling: couldn't deduce the (X) variable.");
        }
        return variable;
    }

    @NotNull
    public final DataFrame.Variable yVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(Stats.INSTANCE.getY())) {
            return Stats.INSTANCE.getY();
        }
        if (data.has(TransformVar.INSTANCE.getY())) {
            return TransformVar.INSTANCE.getY();
        }
        throw new IllegalStateException("Can't apply sampling: couldn't deduce the (Y) variable.");
    }

    @NotNull
    public final List<List<DoubleVector>> splitRings(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        ArrayList<List> rings = new ArrayList<List>();
        DoubleVector lastPoint = null;
        int start2 = -1;
        List<?> xValues = population.get(this.xVar(population));
        List<?> yValues = population.get(this.yVar(population));
        VertexSampling.DoubleVectorComponentsList points2 = new VertexSampling.DoubleVectorComponentsList(xValues, yValues);
        int n = 0;
        int n2 = points2.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                DoubleVector point2 = points2.get(i);
                if (start2 < 0) {
                    start2 = i;
                    lastPoint = point2;
                    continue;
                }
                if (!Intrinsics.areEqual(lastPoint, (Object)point2)) continue;
                rings.add(points2.subList(start2, i + 1));
                start2 = -1;
                lastPoint = null;
            } while (n <= n2);
        }
        if (start2 >= 0) {
            rings.add(points2.subList(start2, points2.size()));
        }
        return rings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> calculateRingLimits(@NotNull List<? extends List<DoubleVector>> rings, int totalPointsLimit) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(rings, (String)"rings");
        Iterable $this$map$iv = rings;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = GeometryKt.calculateArea((List<DoubleVector>)it);
            collection.add(d);
        }
        double totalArea = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
        MutableDouble areaProceed = new MutableDouble(0.0);
        MutableInteger pointsProceed = new MutableInteger(0);
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)CollectionsKt.getIndices((Collection)rings))), (Function1)((Function1)new Function1<Integer, Pair<? extends Integer, ? extends Double>>(rings){
            final /* synthetic */ List<List<DoubleVector>> $rings;
            {
                this.$rings = $rings;
                super(1);
            }

            @NotNull
            public final Pair<Integer, Double> invoke(int it) {
                return new Pair((Object)it, (Object)GeometryKt.calculateArea(this.$rings.get(it)));
            }
        }));
        boolean bl = false;
        object = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, it));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }).reversed();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compareBy<Pair<*, Double\u2026\n            }.reversed()");
        boolean bl2 = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)object), (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends Double>, Pair<? extends Integer, ? extends Integer>>(totalArea, areaProceed, totalPointsLimit, pointsProceed, rings){
            final /* synthetic */ double $totalArea;
            final /* synthetic */ MutableDouble $areaProceed;
            final /* synthetic */ int $totalPointsLimit;
            final /* synthetic */ MutableInteger $pointsProceed;
            final /* synthetic */ List<List<DoubleVector>> $rings;
            {
                this.$totalArea = $totalArea;
                this.$areaProceed = $areaProceed;
                this.$totalPointsLimit = $totalPointsLimit;
                this.$pointsProceed = $pointsProceed;
                this.$rings = $rings;
                super(1);
            }

            @NotNull
            public final Pair<Integer, Integer> invoke(@NotNull Pair<Integer, Double> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                int n = MathKt.roundToInt((double)(((Number)p.getSecond()).doubleValue() / (this.$totalArea - this.$areaProceed.get()) * (double)(this.$totalPointsLimit - this.$pointsProceed.get())));
                int n2 = this.$rings.get(SamplingUtil.INSTANCE.getRingIndex(p)).size();
                boolean bl = false;
                int limit = Math.min(n, n2);
                if (limit >= 4) {
                    this.$areaProceed.getAndAdd(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, p));
                    this.$pointsProceed.getAndAdd(limit);
                } else {
                    limit = 0;
                }
                return new Pair((Object)SamplingUtil.INSTANCE.getRingIndex(p), (Object)limit);
            }
        })), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(SamplingUtil.INSTANCE.getRingIndex(it));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Integer.valueOf(SamplingUtil.INSTANCE.getRingIndex(it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }), (Function1)calculateRingLimits.5.INSTANCE));
    }

    public final int getRingIndex(@NotNull Pair<Integer, ?> pair2) {
        Intrinsics.checkNotNullParameter(pair2, (String)"pair");
        return ((Number)pair2.getFirst()).intValue();
    }

    private final double getRingArea(Pair<?, Double> pair2) {
        return ((Number)pair2.getSecond()).doubleValue();
    }

    public final int getRingLimit(@NotNull Pair<?, Integer> pair2) {
        Intrinsics.checkNotNullParameter(pair2, (String)"pair");
        return ((Number)pair2.getSecond()).intValue();
    }

    public static final /* synthetic */ double access$getRingArea(SamplingUtil $this, Pair pair2) {
        return $this.getRingArea(pair2);
    }
}

