/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0016\u0010\u001b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0012H\u0014R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0016j\b\u0012\u0004\u0012\u00020\u000e`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalMultilineLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "myMaxLines", "", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;I)V", "labelAdditionalOffsets", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getLabelAdditionalOffsets", "()Ljava/util/List;", "myShelfIndexForTickIndex", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "axisMapper", "Lkotlin/Function1;", "maxLabelsBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBounds", "labelNormalSize", "Companion", "plot-builder-portable"})
public final class HorizontalMultilineLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int myMaxLines;
    @NotNull
    private final ArrayList<Integer> myShelfIndexForTickIndex;
    private static final double LINE_HEIGHT = 1.2;
    private static final int MIN_DISTANCE = 60;

    public HorizontalMultilineLabelsLayout(@NotNull Orientation orientation, @NotNull ClosedRange<Double> axisDomain, @NotNull PlotLabelSpec labelSpec, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme, int myMaxLines) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, labelSpec, breaks, theme);
        this.myMaxLines = myMaxLines;
        this.myShelfIndexForTickIndex = new ArrayList();
    }

    private final List<DoubleVector> getLabelAdditionalOffsets() {
        double h = this.getLabelSpec().height() * 1.2;
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>();
        int n = 0;
        int n2 = this.getBreaks().getSize();
        if (n < n2) {
            do {
                int i = n++;
                result.add(new DoubleVector(0.0, ((Number)this.myShelfIndexForTickIndex.get(i)).doubleValue() * h));
            } while (n < n2);
        }
        return result;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper, @Nullable DoubleRectangle maxLabelsBounds) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        HashMap boundsByShelfIndex = new HashMap();
        List<Double> ticks = this.mapToAxis$plot_builder_portable(this.getBreaks().getTransformedValues(), axisMapper);
        List<DoubleRectangle> boundsList = this.labelBoundsList(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        block0: for (DoubleRectangle labelBounds : boundsList) {
            int shelfIndex = 0;
            while (true) {
                Object object;
                if (!boundsByShelfIndex.containsKey(shelfIndex)) {
                    Map map2 = boundsByShelfIndex;
                    object = shelfIndex;
                    boolean bl = false;
                    map2.put(object, labelBounds);
                    this.myShelfIndexForTickIndex.add(shelfIndex);
                    continue block0;
                }
                Intrinsics.checkNotNull(boundsByShelfIndex.get(shelfIndex));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"boundsByShelfIndex[shelfIndex]!!");
                DoubleRectangle shelfBounds = (DoubleRectangle)object;
                if (!shelfBounds.xRange().isConnected(new ClosedRange<Comparable>(Double.valueOf(labelBounds.getLeft() - (double)60), Double.valueOf(labelBounds.getRight() + (double)60)))) {
                    this.myShelfIndexForTickIndex.add(shelfIndex);
                    shelfBounds = shelfBounds.union(labelBounds);
                    object = boundsByShelfIndex;
                    Integer n = shelfIndex;
                    boolean bl = false;
                    object.put(n, shelfBounds);
                    continue block0;
                }
                int n = shelfIndex;
                shelfIndex = n + 1;
            }
        }
        if (boundsByShelfIndex.isEmpty()) {
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        } else {
            DoubleRectangle labelBounds;
            Object v = boundsByShelfIndex.get(0);
            Intrinsics.checkNotNull(v);
            labelBounds = v;
            Intrinsics.checkNotNullExpressionValue((Object)labelBounds, (String)"boundsByShelfIndex[0]!!");
            doubleRectangle = labelBounds;
        }
        DoubleRectangle bounds = doubleRectangle;
        double h = this.getLabelSpec().height() * 1.2;
        int shelfBounds = 0;
        int n = boundsByShelfIndex.size();
        if (shelfBounds < n) {
            do {
                Object v;
                int i = shelfBounds++;
                Intrinsics.checkNotNull(boundsByShelfIndex.get(i));
                Intrinsics.checkNotNullExpressionValue(v, (String)"boundsByShelfIndex[i]!!");
                DoubleRectangle shelfBounds2 = (DoubleRectangle)v;
                bounds = bounds.union(shelfBounds2.add(new DoubleVector(0.0, (double)i * h)));
            } while (shelfBounds < n);
        }
        int linesCount = boundsByShelfIndex.size();
        return new AxisLabelsLayoutInfo.Builder().breaks(this.getBreaks()).bounds(this.applyLabelsOffset$plot_builder_portable(bounds)).smallFont(false).overlap(linesCount > this.myMaxLines).labelAdditionalOffsets(this.getLabelAdditionalOffsets()).labelHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE).labelVerticalAnchor(TextLabel.VerticalAnchor.TOP).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        return BreakLabelsLayoutUtil.INSTANCE.horizontalCenteredLabelBounds(labelNormalSize);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalMultilineLabelsLayout$Companion;", "", "()V", "LINE_HEIGHT", "", "MIN_DISTANCE", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

