/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJB\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007J&\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotLayoutUtil;", "", "()V", "CLIP_EXTEND", "", "GEOM_MARGIN", "GEOM_MIN_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getGEOM_MIN_SIZE", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "clipBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomBounds", "hAxisThickness", "vAxisThickness", "plotSize", "hDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "vDomain", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "liveMapGeomBounds", "maxTickLabelsBounds", "axisOrientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "stretch", "subtractMargins", "plot-builder-portable"})
public final class XYPlotLayoutUtil {
    @NotNull
    public static final XYPlotLayoutUtil INSTANCE = new XYPlotLayoutUtil();
    public static final double GEOM_MARGIN = 0.0;
    private static final double CLIP_EXTEND = 5.0;
    @NotNull
    private static final DoubleVector GEOM_MIN_SIZE = new DoubleVector(50.0, 50.0);

    private XYPlotLayoutUtil() {
    }

    @NotNull
    public final DoubleVector getGEOM_MIN_SIZE() {
        return GEOM_MIN_SIZE;
    }

    @NotNull
    public final DoubleRectangle liveMapGeomBounds(@NotNull DoubleVector plotSize2) {
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        return this.subtractMargins(0.0, 0.0, plotSize2);
    }

    private final DoubleRectangle subtractMargins(double hAxisThickness, double vAxisThickness, DoubleVector plotSize2) {
        DoubleVector marginLeftTop = new DoubleVector(vAxisThickness, 0.0);
        DoubleVector marginRightBottom = new DoubleVector(0.0, hAxisThickness);
        DoubleVector geomSize = plotSize2.subtract(marginLeftTop).subtract(marginRightBottom);
        double d = geomSize.getX();
        double d2 = GEOM_MIN_SIZE.getX();
        boolean bl = false;
        double d3 = Math.max(d, d2);
        d = geomSize.getY();
        d2 = GEOM_MIN_SIZE.getY();
        bl = false;
        return new DoubleRectangle(marginLeftTop, new DoubleVector(d3, Math.max(d, d2)));
    }

    @NotNull
    public final DoubleRectangle geomBounds(double hAxisThickness, double vAxisThickness, @NotNull DoubleVector plotSize2, @NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleRectangle geomBounds = this.subtractMargins(hAxisThickness, vAxisThickness, plotSize2);
        DoubleVector geomSizeAdjusted = coordProvider.adjustGeomSize(hDomain, vDomain, geomBounds.getDimension());
        return new DoubleRectangle(geomBounds.getOrigin(), geomSizeAdjusted);
    }

    @NotNull
    public final DoubleRectangle clipBounds(@NotNull DoubleRectangle geomBounds) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        return new DoubleRectangle(geomBounds.getOrigin().subtract(new DoubleVector(5.0, 5.0)), new DoubleVector(geomBounds.getDimension().getX() + 10.0, geomBounds.getDimension().getY() + 10.0));
    }

    @NotNull
    public final DoubleRectangle maxTickLabelsBounds(@NotNull Orientation axisOrientation, double stretch, @NotNull DoubleRectangle geomBounds, @NotNull DoubleVector plotSize2) {
        Intrinsics.checkNotNullParameter((Object)((Object)axisOrientation), (String)"axisOrientation");
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        double geomPaddung = 10.0;
        DoubleRectangle maxGeomBounds = new DoubleRectangle(geomPaddung, geomPaddung, plotSize2.getX() - (double)2 * geomPaddung, plotSize2.getY() - (double)2 * geomPaddung);
        Orientation orientation = axisOrientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                double leftSpace = geomBounds.getLeft() - maxGeomBounds.getLeft() + stretch;
                double rightSpace = maxGeomBounds.getRight() - geomBounds.getRight() + stretch;
                double height = 1.0E42;
                Orientation orientation2 = axisOrientation;
                int n2 = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
                double top = n2 == 1 ? -height : 0.0;
                double left = -leftSpace;
                double width2 = leftSpace + rightSpace + geomBounds.getWidth();
                return new DoubleRectangle(left, top, width2, height);
            }
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Orientation not supported: ", (Object)((Object)axisOrientation)));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            nArray[Orientation.TOP.ordinal()] = 1;
            nArray[Orientation.BOTTOM.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

