/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendPosition;
import jetbrains.datalore.plot.builder.layout.LegendsBlockInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotLayoutUtil;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\rH\u0002J\"\u0010\u0018\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"JD\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\rJ\u0010\u0010'\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ>\u0010(\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotLayoutUtil;", "", "()V", "AXIS_TITLE_INNER_MARGIN", "", "AXIS_TITLE_OUTER_MARGIN", "LIVE_MAP_PLOT_MARGIN", "Ljetbrains/datalore/base/geometry/DoubleVector;", "LIVE_MAP_PLOT_PADDING", "TITLE_V_MARGIN", "addTitlesAndLegends", "base", "title", "", "axisTitleLeft", "axisTitleBottom", "axisEnabled", "", "legendsBlockInfo", "Ljetbrains/datalore/plot/builder/layout/LegendsBlockInfo;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "axisTitleDimensions", "text", "axisTitleSizeDelta", "axisTitleThickness", "legendBlockDelta", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "legendBlockLeftTopDelta", "liveMapBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "container", "overallGeomBounds", "plotLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "overallTileBounds", "subtractTitlesAndLegends", "baseSize", "titleDimensions", "titleSizeDelta", "titlesAndLegendsSizeDelta", "plot-builder-portable"})
public final class PlotLayoutUtil {
    @NotNull
    public static final PlotLayoutUtil INSTANCE = new PlotLayoutUtil();
    private static final double AXIS_TITLE_OUTER_MARGIN = 4.0;
    public static final double AXIS_TITLE_INNER_MARGIN = 4.0;
    private static final double TITLE_V_MARGIN = 4.0;
    @NotNull
    private static final DoubleVector LIVE_MAP_PLOT_PADDING = new DoubleVector(10.0, 0.0);
    @NotNull
    private static final DoubleVector LIVE_MAP_PLOT_MARGIN = new DoubleVector(10.0, 10.0);

    private PlotLayoutUtil() {
    }

    @NotNull
    public final DoubleVector titleDimensions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.PLOT_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height() + 8.0);
    }

    private final DoubleVector axisTitleDimensions(String text) {
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.AXIS_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle overallGeomBounds(@NotNull PlotLayoutInfo plotLayoutInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        Collection collection = plotLayoutInfo.getTiles();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Plot is empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = plotLayoutInfo.getTiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            DoubleRectangle doubleRectangle = it.getAbsoluteGeomBounds(DoubleVector.Companion.getZERO());
            collection2.add(doubleRectangle);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void r1;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle r0 = (DoubleRectangle)accumulator$iv;
            boolean bl6 = false;
            accumulator$iv = r0.union((DoubleRectangle)r1);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle overallTileBounds(@NotNull PlotLayoutInfo plotLayoutInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        Collection collection = plotLayoutInfo.getTiles();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Plot is empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = plotLayoutInfo.getTiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            DoubleRectangle doubleRectangle = it.getAbsoluteBounds(DoubleVector.Companion.getZERO());
            collection2.add(doubleRectangle);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void r1;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle r0 = (DoubleRectangle)accumulator$iv;
            boolean bl6 = false;
            accumulator$iv = r0.union((DoubleRectangle)r1);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    @NotNull
    public final DoubleRectangle liveMapBounds(@NotNull DoubleRectangle container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return new DoubleRectangle(container.getOrigin().add(LIVE_MAP_PLOT_PADDING), container.getDimension().subtract(LIVE_MAP_PLOT_MARGIN));
    }

    @NotNull
    public final DoubleVector subtractTitlesAndLegends(@NotNull DoubleVector baseSize, @Nullable String title, @Nullable String axisTitleLeft, @Nullable String axisTitleBottom, boolean axisEnabled, @NotNull LegendsBlockInfo legendsBlockInfo, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)baseSize, (String)"baseSize");
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        DoubleVector delta = this.titlesAndLegendsSizeDelta(title, axisTitleLeft, axisTitleBottom, axisEnabled, legendsBlockInfo, theme);
        DoubleVector reduced = baseSize.subtract(delta);
        double d = reduced.getX();
        double d2 = XYPlotLayoutUtil.INSTANCE.getGEOM_MIN_SIZE().getX();
        boolean bl = false;
        double d3 = Math.max(d, d2);
        d = reduced.getY();
        d2 = XYPlotLayoutUtil.INSTANCE.getGEOM_MIN_SIZE().getY();
        bl = false;
        return new DoubleVector(d3, Math.max(d, d2));
    }

    @NotNull
    public final DoubleVector addTitlesAndLegends(@NotNull DoubleVector base, @Nullable String title, @Nullable String axisTitleLeft, @Nullable String axisTitleBottom, boolean axisEnabled, @NotNull LegendsBlockInfo legendsBlockInfo, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        DoubleVector delta = this.titlesAndLegendsSizeDelta(title, axisTitleLeft, axisTitleBottom, axisEnabled, legendsBlockInfo, theme);
        return base.add(delta);
    }

    private final DoubleVector titlesAndLegendsSizeDelta(String title, String axisTitleLeft, String axisTitleBottom, boolean axisEnabled, LegendsBlockInfo legendsBlockInfo, Theme theme) {
        DoubleVector titleDelta = this.titleSizeDelta(title);
        DoubleVector axisTitlesDelta = this.axisTitleSizeDelta(axisTitleLeft, axisTitleBottom, axisEnabled);
        DoubleVector legendBlockDelta = this.legendBlockDelta(legendsBlockInfo, theme.legend());
        return titleDelta.add(axisTitlesDelta).add(legendBlockDelta);
    }

    @NotNull
    public final DoubleVector titleSizeDelta(@Nullable String title) {
        DoubleVector doubleVector;
        if (title != null) {
            DoubleVector titleSize = this.titleDimensions(title);
            doubleVector = new DoubleVector(0.0, titleSize.getY());
        } else {
            doubleVector = DoubleVector.Companion.getZERO();
        }
        return doubleVector;
    }

    @NotNull
    public final DoubleVector axisTitleSizeDelta(@Nullable String axisTitleLeft, @Nullable String axisTitleBottom, boolean axisEnabled) {
        if (!axisEnabled) {
            return DoubleVector.Companion.getZERO();
        }
        DoubleVector axisTitleLeftDelta = new DoubleVector(this.axisTitleThickness(axisTitleLeft), 0.0);
        DoubleVector axisTitleBottomDelta = new DoubleVector(0.0, this.axisTitleThickness(axisTitleBottom));
        return axisTitleLeftDelta.add(axisTitleBottomDelta);
    }

    private final double axisTitleThickness(String title) {
        if (title == null) {
            return 0.0;
        }
        DoubleVector titleSize = this.axisTitleDimensions(title);
        return titleSize.getY() + 4.0 + 4.0;
    }

    private final DoubleVector legendBlockDelta(LegendsBlockInfo legendsBlockInfo, LegendTheme theme) {
        if (!theme.position().isFixed()) {
            return DoubleVector.Companion.getZERO();
        }
        DoubleVector size2 = legendsBlockInfo.size();
        LegendPosition legendPosition = theme.position();
        return (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? true : Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getRIGHT())) ? new DoubleVector(size2.getX(), 0.0) : new DoubleVector(0.0, size2.getY());
    }

    @NotNull
    public final DoubleVector legendBlockLeftTopDelta(@NotNull LegendsBlockInfo legendsBlockInfo, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (!theme.position().isFixed()) {
            return DoubleVector.Companion.getZERO();
        }
        DoubleVector size2 = legendsBlockInfo.size();
        LegendPosition legendPosition = theme.position();
        return Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? new DoubleVector(size2.getX(), 0.0) : (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) ? new DoubleVector(0.0, size2.getY()) : DoubleVector.Companion.getZERO());
    }
}

