/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.LegendBoxLayout;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 %2\u00020\u0001:\u0004$%&'B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0006H \u00a2\u0006\u0002\b#R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "guideBarSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "reverse", "", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/guide/LegendDirection;Z)V", "<set-?>", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barBounds", "getBarBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barLengthExpand", "getBarLengthExpand", "()D", "breakInfos", "", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "getBreakInfos$plot_builder_portable", "()Ljava/util/List;", "guideBarLength", "getGuideBarLength", "getGuideBarSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "createBreakInfo", "tickLocation", "createBreakInfo$plot_builder_portable", "BreakInfo", "Companion", "HorizontalLayout", "VerticalLayout", "plot-builder-portable"})
public abstract class ColorBarComponentLayout
extends LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector guideBarSize;
    @NotNull
    private DoubleRectangle barBounds;
    private final double barLengthExpand;
    @NotNull
    private final List<BreakInfo> breakInfos;

    /*
     * WARNING - void declaration
     */
    public ColorBarComponentLayout(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector guideBarSize, @NotNull LegendDirection legendDirection, boolean reverse) {
        Collection<BreakInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)guideBarSize, (String)"guideBarSize");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        super(title, legendDirection);
        this.guideBarSize = guideBarSize;
        this.barLengthExpand = 2.0;
        double guideBarLength = this.getGuideBarLength();
        ClosedRange<Comparable> targetRange = new ClosedRange<Comparable>(Double.valueOf(0.0 + this.barLengthExpand), Double.valueOf(guideBarLength - this.barLengthExpand));
        Function1<Double, Double> mapper2 = Mappers.INSTANCE.linear(domain, targetRange, reverse);
        Iterable iterable = breaks.getTransformedValues();
        ColorBarComponentLayout colorBarComponentLayout = this;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            double tickLocation = ((Number)mapper2.invoke((Object)((double)it))).doubleValue();
            BreakInfo breakInfo = this.createBreakInfo$plot_builder_portable(tickLocation);
            collection.add(breakInfo);
        }
        collection = (List)destination$iv$iv;
        colorBarComponentLayout.breakInfos = collection;
        this.barBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.guideBarSize);
    }

    @NotNull
    protected final DoubleVector getGuideBarSize() {
        return this.guideBarSize;
    }

    @NotNull
    public final DoubleRectangle getBarBounds() {
        return this.barBounds;
    }

    public final double getBarLengthExpand() {
        return this.barLengthExpand;
    }

    protected abstract double getGuideBarLength();

    @NotNull
    public final List<BreakInfo> getBreakInfos$plot_builder_portable() {
        return this.breakInfos;
    }

    @NotNull
    public abstract BreakInfo createBreakInfo$plot_builder_portable(double var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "", "tickLocation", "", "labelLocation", "Ljetbrains/datalore/base/geometry/DoubleVector;", "labelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "labelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "(DLjetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;)V", "getLabelHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getLabelLocation", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getLabelVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getTickLocation", "()D", "plot-builder-portable"})
    public static final class BreakInfo {
        private final double tickLocation;
        @NotNull
        private final DoubleVector labelLocation;
        @NotNull
        private final TextLabel.HorizontalAnchor labelHorizontalAnchor;
        @NotNull
        private final TextLabel.VerticalAnchor labelVerticalAnchor;

        public BreakInfo(double tickLocation, @NotNull DoubleVector labelLocation, @NotNull TextLabel.HorizontalAnchor labelHorizontalAnchor, @NotNull TextLabel.VerticalAnchor labelVerticalAnchor) {
            Intrinsics.checkNotNullParameter((Object)labelLocation, (String)"labelLocation");
            Intrinsics.checkNotNullParameter((Object)((Object)labelHorizontalAnchor), (String)"labelHorizontalAnchor");
            Intrinsics.checkNotNullParameter((Object)((Object)labelVerticalAnchor), (String)"labelVerticalAnchor");
            this.tickLocation = tickLocation;
            this.labelLocation = labelLocation;
            this.labelHorizontalAnchor = labelHorizontalAnchor;
            this.labelVerticalAnchor = labelVerticalAnchor;
        }

        public final double getTickLocation() {
            return this.tickLocation;
        }

        @NotNull
        public final DoubleVector getLabelLocation() {
            return this.labelLocation;
        }

        @NotNull
        public final TextLabel.HorizontalAnchor getLabelHorizontalAnchor() {
            return this.labelHorizontalAnchor;
        }

        @NotNull
        public final TextLabel.VerticalAnchor getLabelVerticalAnchor() {
            return this.labelVerticalAnchor;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$HorizontalLayout;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;Z)V", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class HorizontalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        public HorizontalLayout(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            super(title, domain, breaks, barSize, LegendDirection.HORIZONTAL, reverse);
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX(), this.getGuideBarSize().getY() + this.getLabelDistance() + LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height());
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height() / (double)3;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getX();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(tickLocation, this.getGuideBarSize().getY() + this.getLabelDistance());
            return new BreakInfo(tickLocation, labelLocation, TextLabel.HorizontalAnchor.MIDDLE, TextLabel.VerticalAnchor.TOP);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$VerticalLayout;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;Z)V", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class VerticalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        /*
         * WARNING - void declaration
         */
        public VerticalLayout(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            super(title, domain, breaks, barSize, LegendDirection.VERTICAL, reverse);
            boolean bl = !breaks.isEmpty();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Colorbar VerticalLayout received empty breaks list.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable $this$map$iv = breaks.getLabels();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Integer n = it.length();
                collection.add(n);
            }
            Iterable iterable = (List)destination$iv$iv;
            boolean bl6 = false;
            iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            int it = ((Number)iterator2.next()).intValue();
            boolean bl7 = false;
            double d = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(it);
            while (iterator2.hasNext()) {
                int it2 = ((Number)iterator2.next()).intValue();
                $i$a$-maxOf-ColorBarComponentLayout$VerticalLayout$maxLabelWidth$2 = false;
                double d2 = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(it2);
                boolean bl8 = false;
                d = Math.max(d, d2);
            }
            double maxLabelWidth = d;
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance() + maxLabelWidth, this.getGuideBarSize().getY());
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(1) / (double)2;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getY();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance(), tickLocation);
            return new BreakInfo(tickLocation, labelLocation, TextLabel.HorizontalAnchor.LEFT, TextLabel.VerticalAnchor.CENTER);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$Companion;", "", "()V", "horizontal", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "vertical", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentLayout horizontal(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            return new HorizontalLayout(title, domain, breaks, barSize, reverse);
        }

        @NotNull
        public final ColorBarComponentLayout vertical(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            return new VerticalLayout(title, domain, breaks, barSize, reverse);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

