/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.plot.PlotHtmlExport;
import jetbrains.datalore.plot.PlotHtmlHelper;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J(\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/PlotHtmlExport;", "", "()V", "buildHtmlFromRawSpecs", "", "plotSpec", "", "scriptUrl", "iFrame", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "escapeHtmlAttr", "value", "preferredPlotSizeFromRawSpec", "plot-config-portable"})
public final class PlotHtmlExport {
    @NotNull
    public static final PlotHtmlExport INSTANCE = new PlotHtmlExport();

    private PlotHtmlExport() {
    }

    @NotNull
    public final String buildHtmlFromRawSpecs(@NotNull Map<String, Object> plotSpec, @NotNull String scriptUrl, boolean iFrame, @Nullable DoubleVector plotSize2) {
        String string;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        String configureHtml = PlotHtmlHelper.INSTANCE.getStaticConfigureHtml(scriptUrl);
        String displayHtml = PlotHtmlHelper.INSTANCE.getStaticDisplayHtmlForRawSpec(plotSpec, plotSize2);
        String style = iFrame ? "\n       <style> html, body { margin: 0; overflow: hidden; } </style>" : "";
        String html = StringsKt.trimMargin$default((String)("\n            |<html lang=\"en\">\n            |   <head>" + style + "\n            |       " + configureHtml + "\n            |   </head>\n            |   <body>\n            |       " + displayHtml + "\n            |   </body>\n            |</html>\n        "), null, (int)1, null);
        if (iFrame) {
            ArrayList<String> attributes2 = new ArrayList<String>();
            attributes2.add("src='about:blank'");
            attributes2.add("style='border:none !important;'");
            DoubleVector preferredSize = this.preferredPlotSizeFromRawSpec(plotSpec, plotSize2);
            if (preferredSize != null) {
                double d = preferredSize.getX() + 0.5;
                boolean bl = false;
                attributes2.add("width='" + (int)Math.rint(d) + '\'');
                d = preferredSize.getY() + 0.5;
                bl = false;
                attributes2.add("height='" + (int)Math.rint(d) + '\'');
            }
            attributes2.add("srcdoc=\"" + this.escapeHtmlAttr(html) + '\"');
            string = StringsKt.trimIndent((String)("\n            <iframe " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "></iframe>    \n            "));
        } else {
            string = html;
        }
        return string;
    }

    public static /* synthetic */ String buildHtmlFromRawSpecs$default(PlotHtmlExport plotHtmlExport, Map map2, String string, boolean bl, DoubleVector doubleVector, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            doubleVector = null;
        }
        return plotHtmlExport.buildHtmlFromRawSpecs(map2, string, bl, doubleVector);
    }

    private final String escapeHtmlAttr(String value) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null);
    }

    private final DoubleVector preferredPlotSizeFromRawSpec(Map<String, Object> plotSpec, DoubleVector plotSize2) {
        try {
            DoubleVector doubleVector;
            Map<String, Object> plotSpec2 = MonolithicCommon.INSTANCE.processRawSpecs(plotSpec, false);
            if (PlotConfig.Companion.isFailure(plotSpec2)) {
                return null;
            }
            if (PlotConfig.Companion.isPlotSpec(plotSpec2)) {
                PlotConfigClientSide config2 = PlotConfigClientSide.Companion.create(plotSpec2, (Function1<? super List<String>, Unit>)((Function1)preferredPlotSizeFromRawSpec.config.1.INSTANCE));
                doubleVector = PlotSizeHelper.INSTANCE.singlePlotSize(plotSpec2, plotSize2, null, config2.getFacets(), config2.getContainsLiveMap());
            } else {
                doubleVector = PlotConfig.Companion.isGGBunchSpec(plotSpec2) ? PlotSizeHelper.INSTANCE.plotBunchSize(plotSpec2) : null;
            }
            return doubleVector;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

