/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections.list;

import jetbrains.datalore.base.observable.collections.DataloreIndexOutOfBoundsException;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0013\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/base/observable/collections/list/TreeList;", "T", "Lkotlin/collections/AbstractMutableList;", "()V", "myTree", "Ljetbrains/datalore/base/observable/collections/list/TreeList$AvlTree;", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "check", "get", "(I)Ljava/lang/Object;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "AvlTree", "base"})
public final class TreeList<T>
extends AbstractMutableList<T> {
    @Nullable
    private AvlTree<T> myTree;

    public int getSize() {
        AvlTree<T> avlTree = this.myTree;
        return avlTree == null ? 0 : avlTree.getMySize$base();
    }

    public T get(int index) {
        T t;
        AvlTree<T> avlTree = this.myTree;
        T t2 = t = avlTree == null ? null : (T)avlTree.get$base(index);
        if (t == null) {
            throw new DataloreIndexOutOfBoundsException(index);
        }
        return t;
    }

    public T set(int index, T element) {
        if (this.myTree == null) {
            throw new DataloreIndexOutOfBoundsException(index);
        }
        AvlTree<T> avlTree = this.myTree;
        Intrinsics.checkNotNull(avlTree);
        T oldValue2 = avlTree.get$base(index);
        AvlTree<T> avlTree2 = this.myTree;
        Intrinsics.checkNotNull(avlTree2);
        this.myTree = avlTree2.set$base(index, element);
        return oldValue2;
    }

    public void add(int index, T element) {
        AvlTree<T> avlTree;
        if (this.myTree == null) {
            if (index != 0) {
                throw new DataloreIndexOutOfBoundsException(index);
            }
            avlTree = new AvlTree<T>(element);
        } else {
            AvlTree<T> avlTree2 = this.myTree;
            Intrinsics.checkNotNull(avlTree2);
            avlTree = avlTree2.insert$base(index, element);
        }
        this.myTree = avlTree;
    }

    public T removeAt(int index) {
        if (this.myTree == null) {
            throw new DataloreIndexOutOfBoundsException(index);
        }
        AvlTree<T> avlTree = this.myTree;
        Intrinsics.checkNotNull(avlTree);
        T oldValue2 = avlTree.get$base(index);
        AvlTree<T> avlTree2 = this.myTree;
        Intrinsics.checkNotNull(avlTree2);
        this.myTree = avlTree2.remove$base(index);
        return oldValue2;
    }

    public final void check() {
        if (this.myTree == null) {
            return;
        }
        AvlTree<T> avlTree = this.myTree;
        Intrinsics.checkNotNull(avlTree);
        avlTree.check$base();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004B-\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0002J\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0018\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\nH\u0080\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\b\u0010\u001c\u001a\u00020\nH\u0016J\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000H\u0002J%\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b \u0010!J\u001d\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00002\u0006\u0010\u0019\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b#J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0000\u00a2\u0006\u0002\b%J\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0000\u00a2\u0006\u0002\b'J&\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00028\u0001H\u0080\u0002\u00a2\u0006\u0004\b)\u0010!J\u0016\u0010*\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0007\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006+"}, d2={"Ljetbrains/datalore/base/observable/collections/list/TreeList$AvlTree;", "T", "", "value", "(Ljava/lang/Object;)V", "myLeft", "myRight", "myValue", "(Ljetbrains/datalore/base/observable/collections/list/TreeList$AvlTree;Ljetbrains/datalore/base/observable/collections/list/TreeList$AvlTree;Ljava/lang/Object;)V", "myHeight", "", "mySize", "getMySize$base", "()I", "Ljava/lang/Object;", "balanceLeft", "result", "balanceRight", "check", "", "check$base", "equals", "", "other", "get", "index", "get$base", "(I)Ljava/lang/Object;", "hashCode", "height", "tree", "insert", "insert$base", "(ILjava/lang/Object;)Ljetbrains/datalore/base/observable/collections/list/TreeList$AvlTree;", "remove", "remove$base", "rotateLeft", "rotateLeft$base", "rotateRight", "rotateRight$base", "set", "set$base", "size", "base"})
    private static final class AvlTree<T> {
        @Nullable
        private final AvlTree<T> myLeft;
        @Nullable
        private final AvlTree<T> myRight;
        private final T myValue;
        private final int myHeight;
        private final int mySize;

        public AvlTree(@Nullable AvlTree<T> myLeft, @Nullable AvlTree<T> myRight, T myValue) {
            this.myLeft = myLeft;
            this.myRight = myRight;
            this.myValue = myValue;
            int n = this.height(this.myLeft);
            int n2 = this.height(this.myRight);
            boolean bl = false;
            this.myHeight = Math.max(n, n2) + 1;
            this.mySize = 1 + this.size(this.myLeft) + this.size(this.myRight);
        }

        public final int getMySize$base() {
            return this.mySize;
        }

        public AvlTree(T value) {
            this(null, null, value);
        }

        @NotNull
        public final AvlTree<T> rotateRight$base() {
            if (this.myLeft == null) {
                throw new IllegalStateException();
            }
            return new AvlTree<T>(this.myLeft.myLeft, new AvlTree<T>(this.myLeft.myRight, this.myRight, this.myValue), this.myLeft.myValue);
        }

        @NotNull
        public final AvlTree<T> rotateLeft$base() {
            if (this.myRight == null) {
                throw new IllegalStateException();
            }
            return new AvlTree<T>(new AvlTree<T>(this.myLeft, this.myRight.myLeft, this.myValue), this.myRight.myRight, this.myRight.myValue);
        }

        public final T get$base(int index) {
            T t;
            int leftSize = this.size(this.myLeft);
            if (index < leftSize) {
                if (this.myLeft == null) {
                    throw new DataloreIndexOutOfBoundsException(index);
                }
                t = this.myLeft.get$base(index);
            } else if (index == leftSize) {
                t = this.myValue;
            } else {
                if (this.myRight == null) {
                    throw new DataloreIndexOutOfBoundsException(index);
                }
                t = this.myRight.get$base(index - leftSize - 1);
            }
            return t;
        }

        @NotNull
        public final AvlTree<T> set$base(int index, T value) {
            AvlTree<T> avlTree;
            int leftSize = this.size(this.myLeft);
            if (index < leftSize) {
                if (this.myLeft == null) {
                    throw new DataloreIndexOutOfBoundsException(index);
                }
                avlTree = new AvlTree<T>(this.myLeft.set$base(index, value), this.myRight, this.myValue);
            } else if (index == leftSize) {
                avlTree = new AvlTree<T>(this.myLeft, this.myRight, value);
            } else {
                if (this.myRight == null) {
                    throw new DataloreIndexOutOfBoundsException(index);
                }
                avlTree = new AvlTree<T>(this.myLeft, this.myRight.set$base(index - 1 - leftSize, value), this.myValue);
            }
            return avlTree;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final AvlTree<T> insert$base(int index, T value) {
            AvlTree<T> avlTree;
            int leftSize = this.size(this.myLeft);
            if (index <= leftSize) {
                AvlTree<T> avlTree2;
                if (this.myLeft == null) {
                    if (index != 0) throw new DataloreIndexOutOfBoundsException(index);
                    avlTree2 = new AvlTree<T>(new AvlTree<T>(value), this.myRight, this.myValue);
                } else {
                    avlTree2 = new AvlTree<T>(this.myLeft.insert$base(index, value), this.myRight, this.myValue);
                }
                AvlTree<T> unbalanced = avlTree2;
                return this.balanceLeft(unbalanced);
            }
            if (this.myRight == null) {
                if (index != leftSize + 1) throw new DataloreIndexOutOfBoundsException(index);
                avlTree = new AvlTree<T>(this.myLeft, new AvlTree<T>(value), this.myValue);
            } else {
                avlTree = new AvlTree<T>(this.myLeft, this.myRight.insert$base(index - 1 - leftSize, value), this.myValue);
            }
            AvlTree<T> unbalanced = avlTree;
            return this.balanceRight(unbalanced);
        }

        private final AvlTree<T> balanceRight(AvlTree<T> result) {
            AvlTree<T> avlTree;
            int delta = this.height(result.myRight) - this.height(result.myLeft);
            if (delta > 1) {
                AvlTree<T> avlTree2 = result.myRight;
                Intrinsics.checkNotNull(avlTree2);
                avlTree = this.height(avlTree2.myLeft) <= this.height(result.myRight.myRight) ? result.rotateLeft$base() : new AvlTree<T>(result.myLeft, result.myRight.rotateRight$base(), result.myValue).rotateLeft$base();
            } else {
                avlTree = result;
            }
            return avlTree;
        }

        private final AvlTree<T> balanceLeft(AvlTree<T> result) {
            AvlTree<T> avlTree;
            int delta = this.height(result.myLeft) - this.height(result.myRight);
            if (delta > 1) {
                AvlTree<T> avlTree2 = result.myLeft;
                Intrinsics.checkNotNull(avlTree2);
                avlTree = this.height(avlTree2.myLeft) >= this.height(result.myLeft.myRight) ? result.rotateRight$base() : new AvlTree<T>(result.myLeft.rotateLeft$base(), result.myRight, result.myValue).rotateRight$base();
            } else {
                avlTree = result;
            }
            return avlTree;
        }

        @Nullable
        public final AvlTree<T> remove$base(int index) {
            int leftSize = this.size(this.myLeft);
            if (index == leftSize) {
                if (this.myLeft == null) {
                    return this.myRight;
                }
                if (this.myRight == null) {
                    return this.myLeft;
                }
                T newVal = this.myRight.get$base(0);
                return this.balanceLeft(new AvlTree<T>(this.myLeft, this.myRight.remove$base(0), newVal));
            }
            if (index < leftSize) {
                if (this.myLeft == null) {
                    throw new DataloreIndexOutOfBoundsException(index);
                }
                return this.balanceRight(new AvlTree<T>(this.myLeft.remove$base(index), this.myRight, this.myValue));
            }
            if (this.myRight == null) {
                throw new DataloreIndexOutOfBoundsException(index);
            }
            return this.balanceLeft(new AvlTree<T>(this.myLeft, this.myRight.remove$base(index - leftSize - 1), this.myValue));
        }

        public final void check$base() {
            int n = this.height(this.myLeft) - this.height(this.myRight);
            boolean bl = false;
            if (Math.abs(n) > 1) {
                throw new IllegalStateException();
            }
            AvlTree<T> avlTree = this.myLeft;
            if (avlTree != null) {
                avlTree.check$base();
            }
            avlTree = this.myRight;
            if (avlTree != null) {
                avlTree.check$base();
            }
        }

        private final int height(AvlTree<?> tree) {
            AvlTree<?> avlTree = tree;
            return avlTree == null ? 0 : avlTree.myHeight;
        }

        private final int size(AvlTree<?> tree) {
            AvlTree<?> avlTree = tree;
            return avlTree == null ? 0 : avlTree.mySize;
        }

        public int hashCode() {
            int n;
            T t;
            int result = 0;
            if (this.myLeft != null) {
                result += 31 * this.myLeft.hashCode();
            }
            if (this.myRight != null) {
                result += 71 * this.myRight.hashCode();
            }
            return result += (t = this.myValue) == null ? 0 : (n = t.hashCode());
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof AvlTree)) {
                return false;
            }
            AvlTree otherTree = (AvlTree)other;
            return otherTree.myValue == this.myValue && Intrinsics.areEqual(otherTree.myLeft, this.myLeft) && Intrinsics.areEqual(otherTree.myRight, this.myRight);
        }
    }
}

