/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.statistics.KotlinObjectSizeCalculator;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirLibrarySession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStatistics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStatisticsCalculator;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.UtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.symbolProviders.LLFirJavaSymbolProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.symbolProviders.LLFirJavaSymbolProviderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.symbolProviders.LLKotlinStubBasedLibrarySymbolProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.symbolProviders.LLModuleWithDependenciesSymbolProvider;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.FirLazyJavaDeclarationList;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaTypeParameter;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaAnnotationList;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaDeclarationList;
import org.jetbrains.kotlin.fir.java.enhancement.FirLazyJavaAnnotationList;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J%\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0002R\u0004\u0018\u00010\tj\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0002R\u0004\u0018\u00010\tj\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0014\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u0004\u0018\u00010\tj\b\u0010\u0016\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u00020\tj\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator;", "", "<init>", "()V", "calculateSessionStatistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;", "session", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "calculateResolvableSessionStatistics", "Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;", "<unused var>", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirResolvableModuleSession;", "(Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirResolvableModuleSession;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;", "calculateLibrarySessionStatistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirLibrarySession;", "(Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirLibrarySession;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;", "currentLifetime", "", "getCurrentLifetime", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;)D", "calculateFirElementWeight", "", "objectSizeCalculator", "firElements", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;Ljava/util/Collection;)J", "firElement", "(Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;Lorg/jetbrains/kotlin/fir/FirElement;)J", "FirElementWeightCalculatorVisitor", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLSessionStatisticsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLSessionStatisticsCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1#2:213\n812#3,12:214\n812#3,12:226\n*S KotlinDebug\n*F\n+ 1 LLSessionStatisticsCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator\n*L\n68#1:214,12\n72#1:226,12\n*E\n"})
public final class LLSessionStatisticsCalculator {
    @NotNull
    public static final LLSessionStatisticsCalculator INSTANCE = new LLSessionStatisticsCalculator();

    private LLSessionStatisticsCalculator() {
    }

    @NotNull
    public final LLSessionStatistics calculateSessionStatistics(@NotNull LLFirSession session2) {
        KotlinObjectSizeCalculator objectSizeCalculator;
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        KotlinObjectSizeCalculator kotlinObjectSizeCalculator = objectSizeCalculator = KotlinObjectSizeCalculator.Companion.getInstance(session2.getProject());
        boolean bl = false;
        LLFirSession lLFirSession = session2;
        return lLFirSession instanceof LLFirResolvableModuleSession ? INSTANCE.calculateResolvableSessionStatistics(kotlinObjectSizeCalculator, (LLFirResolvableModuleSession)session2) : (lLFirSession instanceof LLFirLibrarySession ? INSTANCE.calculateLibrarySessionStatistics(kotlinObjectSizeCalculator, (LLFirLibrarySession)session2) : LLSessionStatistics.Companion.getZERO());
    }

    private final LLSessionStatistics calculateResolvableSessionStatistics(KotlinObjectSizeCalculator kotlinObjectSizeCalculator, LLFirResolvableModuleSession session2) {
        long l;
        LLFirJavaSymbolProvider lLFirJavaSymbolProvider;
        ModuleFileCache moduleFileCache = session2.getModuleComponents$low_level_api_fir().getCache();
        Collection<FirFile> firFiles = moduleFileCache.getAllCachedFirFiles();
        long kotlinWeight = this.calculateFirElementWeight(kotlinObjectSizeCalculator, firFiles);
        Object object = LLFirJavaSymbolProviderKt.getNullableJavaSymbolProvider(session2);
        LLFirJavaSymbolProvider lLFirJavaSymbolProvider2 = lLFirJavaSymbolProvider = object instanceof LLFirJavaSymbolProvider ? (LLFirJavaSymbolProvider)object : null;
        if (lLFirJavaSymbolProvider != null && (object = lLFirJavaSymbolProvider.getCachedDeclarations$low_level_api_fir()) != null) {
            Object it = object;
            boolean bl = false;
            l = INSTANCE.calculateFirElementWeight(kotlinObjectSizeCalculator, (Collection<? extends FirElement>)it);
        } else {
            l = 0L;
        }
        long javaWeight = l;
        return new LLSessionStatistics(kotlinWeight, javaWeight, this.getCurrentLifetime(session2));
    }

    /*
     * WARNING - void declaration
     */
    private final LLSessionStatistics calculateLibrarySessionStatistics(KotlinObjectSizeCalculator kotlinObjectSizeCalculator, LLFirLibrarySession session2) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        long l;
        long l2;
        Iterable $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        FirSymbolProvider firSymbolProvider = FirSymbolProviderKt.getSymbolProvider((FirSession)session2);
        Object object = firSymbolProvider instanceof LLModuleWithDependenciesSymbolProvider ? (LLModuleWithDependenciesSymbolProvider)firSymbolProvider : null;
        if (object == null || (object = object.getProviders()) == null) {
            return LLSessionStatistics.Companion.getZERO();
        }
        Object symbolProviders = object;
        Iterable iterable = (Iterable)symbolProviders;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof LLKotlinStubBasedLibrarySymbolProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv;
        long l3 = 0L;
        for (Object $i$f$filterIsInstanceTo2 : $this$filterIsInstance$iv2) {
            void it;
            Iterator iterator = (LLKotlinStubBasedLibrarySymbolProvider)$i$f$filterIsInstanceTo2;
            l2 = l3;
            boolean bl = false;
            l = INSTANCE.calculateFirElementWeight(kotlinObjectSizeCalculator, (Collection<? extends FirElement>)it.getCachedDeclarations$low_level_api_fir());
            l3 = l2 + l;
        }
        long kotlinWeight = l3;
        $this$filterIsInstanceTo$iv$iv2 = (Iterable)symbolProviders;
        boolean $i$f$filterIsInstance2 = false;
        void $i$f$filterIsInstanceTo2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LLFirJavaSymbolProvider)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        iterable2 = (List)destination$iv$iv2;
        long l4 = 0L;
        for (Object t : iterable2) {
            void it;
            LLFirJavaSymbolProvider lLFirJavaSymbolProvider = (LLFirJavaSymbolProvider)t;
            l2 = l4;
            boolean bl = false;
            l = INSTANCE.calculateFirElementWeight(kotlinObjectSizeCalculator, it.getCachedDeclarations$low_level_api_fir());
            l4 = l2 + l;
        }
        long javaWeight = l4;
        return new LLSessionStatistics(kotlinWeight, javaWeight, this.getCurrentLifetime(session2));
    }

    private final double getCurrentLifetime(LLFirSession $this$currentLifetime) {
        return Duration.toDouble-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)$this$currentLifetime.getCreationTimeMark-z9LOYto()), (DurationUnit)DurationUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private final long calculateFirElementWeight(KotlinObjectSizeCalculator objectSizeCalculator, Collection<? extends FirElement> firElements) {
        if (objectSizeCalculator == null) {
            return 0L;
        }
        Iterable iterable = firElements;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            FirElement firElement = (FirElement)t;
            long l2 = l;
            boolean bl = false;
            long l3 = INSTANCE.calculateFirElementWeight(objectSizeCalculator, (FirElement)it);
            l = l2 + l3;
        }
        return l;
    }

    private final long calculateFirElementWeight(KotlinObjectSizeCalculator objectSizeCalculator, FirElement firElement) {
        FirElementWeightCalculatorVisitor visitor2 = new FirElementWeightCalculatorVisitor(objectSizeCalculator);
        firElement.accept((FirVisitor)visitor2, null);
        return visitor2.getTotalWeight();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator$FirElementWeightCalculatorVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "objectSizeCalculator", "Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;)V", "value", "", "totalWeight", "getTotalWeight", "()J", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitJavaDeclarationList", "declarationList", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirJavaDeclarationList;", "visitJavaAnnotationList", "annotationList", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLSessionStatisticsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLSessionStatisticsCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator$FirElementWeightCalculatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1915#2,2:213\n1915#2,2:215\n1915#2,2:217\n1915#2,2:219\n1915#2,2:221\n1915#2,2:223\n1915#2,2:225\n1915#2,2:227\n1915#2,2:229\n1915#2,2:231\n*S KotlinDebug\n*F\n+ 1 LLSessionStatisticsCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatisticsCalculator$FirElementWeightCalculatorVisitor\n*L\n122#1:213,2\n128#1:215,2\n135#1:217,2\n136#1:219,2\n146#1:221,2\n159#1:223,2\n165#1:225,2\n184#1:227,2\n196#1:229,2\n208#1:231,2\n*E\n"})
    private static final class FirElementWeightCalculatorVisitor
    extends FirVisitorVoid {
        @NotNull
        private final KotlinObjectSizeCalculator objectSizeCalculator;
        private long totalWeight;

        public FirElementWeightCalculatorVisitor(@NotNull KotlinObjectSizeCalculator objectSizeCalculator) {
            Intrinsics.checkNotNullParameter((Object)objectSizeCalculator, (String)"objectSizeCalculator");
            this.objectSizeCalculator = objectSizeCalculator;
        }

        public final long getTotalWeight() {
            return this.totalWeight;
        }

        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.totalWeight += this.objectSizeCalculator.shallowSize(element);
            FirElement firElement = element;
            if (firElement instanceof FirJavaClass) {
                FirTypeParameterRef it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                this.visitJavaDeclarationList(((FirJavaClass)element).getDeclarationList());
                this.visitJavaAnnotationList(((FirJavaClass)element).getAnnotations());
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.1.INSTANCE, element)) {
                    $this$forEach$iv = ((FirJavaClass)element).getTypeParameters();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (FirTypeParameterRef)element$iv;
                        boolean bl = false;
                        it.accept((FirVisitor)this, null);
                    }
                }
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.3.INSTANCE, element)) {
                    ((FirJavaClass)element).getStatus().accept((FirVisitor)this, null);
                }
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.4.INSTANCE, element)) {
                    $this$forEach$iv = ((FirJavaClass)element).getSuperTypeRefs();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (FirTypeRef)element$iv;
                        boolean bl = false;
                        it.accept((FirVisitor)this, null);
                    }
                }
            } else if (firElement instanceof FirJavaConstructor) {
                FirTypeParameterRef it;
                ((FirJavaConstructor)element).getReturnTypeRef().accept((FirVisitor)this, null);
                FirControlFlowGraphReference firControlFlowGraphReference = ((FirJavaConstructor)element).getControlFlowGraphReference();
                if (firControlFlowGraphReference != null) {
                    firControlFlowGraphReference.accept((FirVisitor)this, null);
                }
                Iterable $this$forEach$iv = ((FirJavaConstructor)element).getTypeParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
                $this$forEach$iv = ((FirJavaConstructor)element).getValueParameters();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (FirValueParameter)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.8.INSTANCE, element)) {
                    ((FirJavaConstructor)element).getStatus().accept((FirVisitor)this, null);
                }
                this.visitJavaAnnotationList(((FirJavaConstructor)element).getAnnotations());
            } else if (firElement instanceof FirJavaField) {
                ((FirJavaField)element).getReturnTypeRef().accept((FirVisitor)this, null);
                this.visitJavaAnnotationList(((FirJavaField)element).getAnnotations());
                Iterable $this$forEach$iv = ((FirJavaField)element).getTypeParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.10.INSTANCE, element)) {
                    ((FirJavaField)element).getStatus().accept((FirVisitor)this, null);
                }
                if (((FirJavaField)element).getLazyInitializer().isInitialized()) {
                    FirExpression firExpression = ((FirJavaField)element).getInitializer();
                    if (firExpression != null) {
                        firExpression.accept((FirVisitor)this, null);
                    }
                }
            } else if (firElement instanceof FirJavaMethod) {
                FirValueParameter it;
                ((FirJavaMethod)element).getReturnTypeRef().accept((FirVisitor)this, null);
                FirReceiverParameter firReceiverParameter = ((FirJavaMethod)element).getReceiverParameter();
                if (firReceiverParameter != null) {
                    firReceiverParameter.accept((FirVisitor)this, null);
                }
                FirControlFlowGraphReference firControlFlowGraphReference = ((FirJavaMethod)element).getControlFlowGraphReference();
                if (firControlFlowGraphReference != null) {
                    firControlFlowGraphReference.accept((FirVisitor)this, null);
                }
                Iterable $this$forEach$iv = ((FirJavaMethod)element).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (FirValueParameter)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
                FirBlock firBlock = ((FirJavaMethod)element).getBody();
                if (firBlock != null) {
                    firBlock.accept((FirVisitor)this, null);
                }
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.12.INSTANCE, element)) {
                    ((FirJavaMethod)element).getStatus().accept((FirVisitor)this, null);
                }
                this.visitJavaAnnotationList(((FirJavaMethod)element).getAnnotations());
                $this$forEach$iv = ((FirJavaMethod)element).getTypeParameters();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (FirTypeParameter)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
            } else if (firElement instanceof FirJavaTypeParameter) {
                this.visitJavaAnnotationList(((FirJavaTypeParameter)element).getAnnotations());
            } else if (firElement instanceof FirJavaValueParameter) {
                ((FirJavaValueParameter)element).getReturnTypeRef().accept((FirVisitor)this, null);
                this.visitJavaAnnotationList(((FirJavaValueParameter)element).getAnnotations());
                Lazy lazy = ((FirJavaValueParameter)element).getLazyDefaultValue();
                boolean bl = lazy != null ? lazy.isInitialized() : false;
                if (bl) {
                    FirExpression firExpression = ((FirJavaValueParameter)element).getDefaultValue();
                    if (firExpression != null) {
                        firExpression.accept((FirVisitor)this, null);
                    }
                }
            } else if (firElement instanceof FirJavaTypeRef) {
                if (UtilsKt.isLazyInitialized((KProperty1)visitElement.14.INSTANCE, element)) {
                    Iterable $this$forEach$iv = ((FirJavaTypeRef)element).getAnnotations();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl = false;
                        it.accept((FirVisitor)this, null);
                    }
                }
            } else {
                element.acceptChildren((FirVisitor)this, null);
            }
        }

        private final void visitJavaDeclarationList(FirJavaDeclarationList declarationList) {
            if (declarationList instanceof FirLazyJavaDeclarationList && UtilsKt.isLazyInitialized((KProperty1)visitJavaDeclarationList.1.INSTANCE, declarationList)) {
                Iterable $this$forEach$iv = ((FirLazyJavaDeclarationList)declarationList).getDeclarations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
            }
        }

        private final void visitJavaAnnotationList(List<? extends FirAnnotation> annotationList) {
            block1: {
                List annotations;
                List list = annotationList;
                List list2 = annotations = list instanceof FirLazyJavaAnnotationList ? (List)(((FirLazyJavaAnnotationList)annotationList).isInitialized() ? (FirLazyJavaAnnotationList)annotationList : null) : (list instanceof FirJavaAnnotationList ? null : annotationList);
                if (list2 == null) break block1;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation it = (FirAnnotation)element$iv;
                    boolean bl = false;
                    it.accept((FirVisitor)this, null);
                }
            }
        }
    }
}

