/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.export.utilities;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\n\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u000b"}, d2={"isImplementsCloneable", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "isCloneable", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)Z", "isClone", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "analysis-api-based-export-common"})
@SourceDebugExtension(value={"SMAP\nisCloneable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 isCloneable.kt\norg/jetbrains/kotlin/analysis/api/export/utilities/IsCloneableKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,39:1\n1761#2,3:40\n1255#3,2:43\n*S KotlinDebug\n*F\n+ 1 isCloneable.kt\norg/jetbrains/kotlin/analysis/api/export/utilities/IsCloneableKt\n*L\n18#1:40,3\n37#1:43,2\n*E\n"})
public final class IsCloneableKt {
    public static final boolean isImplementsCloneable(@NotNull KaSession $this$isImplementsCloneable, @NotNull KaClassSymbol symbol) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isImplementsCloneable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Iterable $this$any$iv = symbol.getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KaType it = (KaType)element$iv;
                    boolean bl2 = false;
                    KaClassSymbol kaClassSymbol = $this$isImplementsCloneable.getExpandedSymbol(it);
                    if (!(kaClassSymbol != null ? IsCloneableKt.isCloneable(kaClassSymbol) : false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isCloneable(@NotNull KaClassSymbol $this$isCloneable) {
        Intrinsics.checkNotNullParameter((Object)$this$isCloneable, (String)"<this>");
        ClassId classId = $this$isCloneable.getClassId();
        return classId != null ? IsCloneableKt.isCloneable(classId) : false;
    }

    public static final boolean isCloneable(@NotNull ClassId $this$isCloneable) {
        Intrinsics.checkNotNullParameter((Object)$this$isCloneable, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isCloneable.asSingleFqName(), (Object)StandardNames.FqNames.cloneable.toSafe());
    }

    public static final boolean isClone(@NotNull KaSession $this$isClone, @NotNull KaNamedFunctionSymbol symbol) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$isClone, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            ClassId classId = StandardClassIds.INSTANCE.getCloneable();
            Name name = Name.identifier((String)"clone");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            CallableId cloneCallableId = new CallableId(classId, name);
            if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)cloneCallableId)) {
                return true;
            }
            Sequence<KaCallableSymbol> $this$any$iv = $this$isClone.getAllOverriddenSymbols(symbol);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KaCallableSymbol it = (KaCallableSymbol)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getCallableId(), (Object)cloneCallableId)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }
}

