/*
 * Decompiled with CFR 0.152.
 */
package kotlin.concurrent;

import java.util.NoSuchElementException;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Pair;
import kotlin.concurrent.FunctionalList;

@JetClass(signature="<erased T:?Ljava/lang/Object;>Ljava/lang/Object;", flags=16, abiVersion=6)
public final class FunctionalQueue<T> {
    private final FunctionalList<T> input;
    private final FunctionalList<T> output;

    @JetMethod(flags=17, propertyType="I")
    public final int getSize() {
        return this.input.getSize() + this.output.getSize();
    }

    @JetMethod(flags=17, propertyType="Z")
    public final boolean getEmpty() {
        boolean bl = true;
        if (this.getSize() != 0) {
            bl = false;
        }
        return bl;
    }

    @JetMethod(returnType="Lkotlin/concurrent/FunctionalQueue<TT;>;")
    public final FunctionalQueue<T> add(@JetValueParameter(name="element", type="TT;") T element) {
        return new FunctionalQueue<T>(this.input.add(element), this.output);
    }

    @JetMethod(returnType="Lkotlin/concurrent/FunctionalQueue<TT;>;")
    public final FunctionalQueue<T> addFirst(@JetValueParameter(name="element", type="TT;") T element) {
        return new FunctionalQueue<T>(this.input, this.output.add(element));
    }

    @JetMethod(returnType="Lkotlin/Pair<TT;Lkotlin/concurrent/FunctionalQueue<TT;>;>;")
    public final Pair<T, FunctionalQueue<T>> removeFirst() {
        Pair pair;
        if (this.output.getEmpty()) {
            if (this.input.getEmpty()) {
                throw (Throwable)new NoSuchElementException();
            }
            pair = new FunctionalQueue(FunctionalList.object$.emptyList(), this.input.reversed()).removeFirst();
        } else {
            pair = new Pair(this.output.getHead(), new FunctionalQueue<T>(this.input, this.output.getTail()));
        }
        return pair;
    }

    @JetMethod(flags=17, propertyType="Lkotlin/concurrent/FunctionalList<TT;>;")
    public final FunctionalList<T> getInput() {
        return this.input;
    }

    @JetMethod(flags=17, propertyType="Lkotlin/concurrent/FunctionalList<TT;>;")
    public final FunctionalList<T> getOutput() {
        return this.output;
    }

    @JetConstructor
    public FunctionalQueue(@JetValueParameter(name="input", hasDefaultValue=true, type="Lkotlin/concurrent/FunctionalList<TT;>;") FunctionalList<T> input, @JetValueParameter(name="output", hasDefaultValue=true, type="Lkotlin/concurrent/FunctionalList<TT;>;") FunctionalList<T> output) {
        this.input = input;
        this.output = output;
    }

    public /* synthetic */ FunctionalQueue(FunctionalList functionalList, FunctionalList functionalList2, int n) {
        if ((n & 1) != 0) {
            functionalList = FunctionalList.object$.emptyList();
        }
        if ((n & 2) != 0) {
            functionalList2 = FunctionalList.object$.emptyList();
        }
        this(functionalList, functionalList2);
    }

    public FunctionalQueue() {
        this(null, null, 3);
    }
}

