/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sourceSections;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.sourceSections.FilteredSectionsTokensRangeIterator;
import org.jetbrains.kotlin.sourceSections.TokenRange;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a8\u0006\f"}, d2={"filterByteContents", "", "sectionIds", "", "", "bytes", "charset", "Ljava/nio/charset/Charset;", "filterStringBuilderContents", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "content", "kotlin-source-sections-compiler-plugin"})
public final class FilteredSectionsVirtualFileKt {
    private static final byte[] filterByteContents(Collection<String> sectionIds, byte[] bytes, Charset charset) {
        byte[] byArray;
        StringBuilder content = new StringBuilder(charset.decode(ByteBuffer.wrap(bytes)));
        FilteredSectionsVirtualFileKt.filterStringBuilderContents(content, sectionIds);
        ByteBuffer buffer = charset.encode(CharBuffer.wrap(content));
        if (buffer.limit() == buffer.capacity()) {
            byte[] byArray2 = buffer.array();
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"buffer.array()");
        } else {
            byte[] res = new byte[buffer.limit()];
            buffer.get(res);
            byArray = res;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final StringBuilder filterStringBuilderContents(StringBuilder content, Collection<String> sectionIds) {
        Iterator iterator;
        int n = 0;
        int n2 = content.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (content.charAt((int)i) == '\r') {
                    StringBuilder stringBuilder = content;
                    char c = ' ';
                    stringBuilder.setCharAt((int)i, c);
                }
                if (i == n2) break;
                ++i;
            }
        }
        int curPos = 0;
        FilteredSectionsTokensRangeIterator sectionsIter = new FilteredSectionsTokensRangeIterator(content, sectionIds);
        Iterator iterator2 = iterator = (Iterator)sectionsIter;
        while (iterator2.hasNext()) {
            int n3 = curPos;
            TokenRange range = (TokenRange)iterator2.next();
            int n4 = range.getStart() - 1;
            if (n3 <= n4) {
                while (true) {
                    void i;
                    if (content.charAt((int)i) != '\n') {
                        content.setCharAt((int)i, ' ');
                    }
                    if (i == n4) break;
                    ++i;
                }
            }
            curPos = range.getEnd();
        }
        int range = curPos;
        int n5 = content.length() - 1;
        if (range <= n5) {
            while (true) {
                void i;
                if (content.charAt((int)i) != '\n') {
                    content.setCharAt((int)i, ' ');
                }
                if (i == n5) break;
                ++i;
            }
        }
        return content;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$filterByteContents(@NotNull Collection sectionIds, @NotNull byte[] bytes, @NotNull Charset charset) {
        return FilteredSectionsVirtualFileKt.filterByteContents(sectionIds, bytes, charset);
    }

    @NotNull
    public static final /* synthetic */ StringBuilder access$filterStringBuilderContents(@NotNull StringBuilder content, @NotNull Collection sectionIds) {
        return FilteredSectionsVirtualFileKt.filterStringBuilderContents(content, sectionIds);
    }
}

