/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sourceSections;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.sourceSections.FilteredSectionsTokensRangeIterator;
import org.jetbrains.kotlin.sourceSections.TokenRange;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0002H\u0096\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/sourceSections/FilteredSectionsTokensRangeIterator;", "", "Lorg/jetbrains/kotlin/sourceSections/TokenRange;", "script", "", "sectionIds", "", "", "(Ljava/lang/CharSequence;Ljava/util/Collection;)V", "currentRange", "lexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "getSectionIds", "()Ljava/util/Collection;", "advanceToNextFilteredSection", "hasNext", "", "next", "kotlin-source-sections-compiler-plugin"})
final class FilteredSectionsTokensRangeIterator
implements Iterator<TokenRange>,
KMappedMarker {
    private final KotlinLexer lexer;
    private TokenRange currentRange;
    @NotNull
    private final Collection<String> sectionIds;

    @Nullable
    public final TokenRange advanceToNextFilteredSection() {
        KotlinLexer kotlinLexer;
        advanceToNextFilteredSection.1 skipWhiteSpaceAndComments$ = advanceToNextFilteredSection.1.INSTANCE;
        int depth = 0;
        int sectionStartPos = 0;
        boolean inside = false;
        KotlinLexer $receiver = kotlinLexer = this.lexer;
        while ($receiver.getTokenType() != null) {
            IElementType iElementType;
            if (!inside && depth == 0 && Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.IDENTIFIER) && this.sectionIds.contains($receiver.getTokenText())) {
                sectionStartPos = $receiver.getCurrentPosition().getOffset();
                $receiver.advance();
                advanceToNextFilteredSection.1.INSTANCE.invoke($receiver);
                inside = Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.LBRACE);
            }
            if (Intrinsics.areEqual((Object)(iElementType = $receiver.getTokenType()), (Object)KtTokens.LBRACE)) {
                ++depth;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
                --depth;
            }
            if (inside && depth == 0) {
                $receiver.advance();
                break;
            }
            $receiver.advance();
        }
        return this.lexer.getTokenType() == null && !inside ? null : new TokenRange(sectionStartPos, this.lexer.getCurrentPosition().getOffset());
    }

    @Override
    public boolean hasNext() {
        return this.currentRange != null;
    }

    @Override
    @NotNull
    public TokenRange next() {
        TokenRange ret = this.currentRange;
        this.currentRange = this.advanceToNextFilteredSection();
        TokenRange tokenRange = ret;
        if (tokenRange == null) {
            Intrinsics.throwNpe();
        }
        return tokenRange;
    }

    @NotNull
    public final Collection<String> getSectionIds() {
        return this.sectionIds;
    }

    public FilteredSectionsTokensRangeIterator(@NotNull CharSequence script, @NotNull Collection<String> sectionIds) {
        KotlinLexer kotlinLexer;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull(sectionIds, (String)"sectionIds");
        this.sectionIds = sectionIds;
        KotlinLexer kotlinLexer2 = new KotlinLexer();
        FilteredSectionsTokensRangeIterator filteredSectionsTokensRangeIterator = this;
        KotlinLexer $receiver = kotlinLexer2;
        $receiver.start(script);
        filteredSectionsTokensRangeIterator.lexer = kotlinLexer = kotlinLexer2;
        this.currentRange = this.advanceToNextFilteredSection();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

