/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ImmutableList;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.internal.ListImplementation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001(B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J#\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\u001d\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u0016\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020%0$H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0016J#\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "E", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/ImmutableList;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "buffer", "", "", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "size", "", "getSize", "()I", "add", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "element", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "index", "(ILjava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "addAll", "c", "", "elements", "bufferOfSize", "(I)[Ljava/lang/Object;", "builder", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList$Builder;", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "listIterator", "", "removeAll", "predicate", "Lkotlin/Function1;", "", "removeAt", "set", "Companion", "kotlinx-collections-immutable"})
@SourceDebugExtension(value={"SMAP\nSmallPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,161:1\n41#2:162\n41#2:163\n26#3:164\n*S KotlinDebug\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n*L\n48#1:162\n91#1:163\n159#1:164\n*E\n"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E>
implements ImmutableList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object[] buffer;
    @NotNull
    private static final SmallPersistentVector EMPTY;

    public SmallPersistentVector(@NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    public int getSize() {
        return this.buffer.length;
    }

    private final Object[] bufferOfSize(int size) {
        return new Object[size];
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(element);
        return new PersistentVector(this.buffer, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.size() + elements.size() <= 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int index = this.size();
            for (E element : elements) {
                newBuffer[index++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(elements);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList persistentList;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Object[] newBuffer = this.buffer;
        int newSize = this.size();
        boolean anyRemoved = false;
        int n = this.size();
        for (int index = 0; index < n; ++index) {
            Object element = this.buffer[index];
            if (((Boolean)predicate.invoke(element)).booleanValue()) {
                if (anyRemoved) continue;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(this.buffer, this.buffer.length), (String)"copyOf(...)");
                newSize = index;
                anyRemoved = true;
                continue;
            }
            if (!anyRemoved) continue;
            newBuffer[newSize++] = element;
        }
        int n2 = newSize;
        if (n2 == this.size()) {
            persistentList = this;
        } else if (n2 == 0) {
            persistentList = EMPTY;
        } else {
            Object[] objectArray = newBuffer;
            int n3 = 0;
            persistentList = new SmallPersistentVector<E>(ArraysKt.copyOfRange((Object[])objectArray, (int)n3, (int)newSize));
        }
        return persistentList;
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(int index, @NotNull Collection<? extends E> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        if (this.size() + c.size() <= 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + c.size());
            ArraysKt.copyInto$default((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)0, (int)index, (int)6, null);
            ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(index + c.size()), (int)index, (int)this.size());
            int position = index;
            for (E element : c) {
                newBuffer[position++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(index, c);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index, E element) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        if (index == this.size()) {
            return this.add((Object)element);
        }
        if (this.size() < 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + 1);
            ArraysKt.copyInto$default((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)0, (int)index, (int)6, null);
            ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(index + 1), (int)index, (int)this.size());
            newBuffer[index] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] root = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])root, (int)(index + 1), (int)index, (int)(this.size() - 1));
        root[index] = element;
        Object[] tail = UtilsKt.presizedBufferWith(this.buffer[31]);
        return new PersistentVector(root, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)index, (int)(index + 1), (int)this.size());
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Override
    @NotNull
    public PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    @Override
    public int indexOf(Object element) {
        return ArraysKt.indexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ArraysKt.lastIndexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        return new BufferIterator<Object>(this.buffer, index, this.size());
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        return (E)this.buffer[index];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index, E element) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[index] = element;
        return new SmallPersistentVector<E>(newBuffer);
    }

    static {
        boolean $i$f$emptyArray = false;
        EMPTY = new SmallPersistentVector(new Object[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "", "getEMPTY", "()Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "kotlinx-collections-immutable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

