/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.math.BasicStats;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0006\u001a#\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\b\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\u0002H\u0001\u00a2\u0006\u0002\b\n\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000b0\u0002H\u0001\u00a2\u0006\u0002\b\f\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\r0\u0002H\u0001\u00a2\u0006\u0002\b\u000e\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000f0\u0002H\u0001\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"varianceAndMean", "Lorg/jetbrains/kotlinx/dataframe/math/BasicStats;", "", "", "skipNA", "", "doubleVarianceAndMean", "", "floatVarianceAndMean", "", "intVarianceAndMean", "", "longVarianceAndMean", "Ljava/math/BigDecimal;", "bigDecimalVarianceAndMean", "Ljava/math/BigInteger;", "bigIntegerVarianceAndMean", "core"})
public final class StdMeanKt {
    @JvmName(name="doubleVarianceAndMean")
    @Nullable
    public static final BasicStats doubleVarianceAndMean(@NotNull Iterable<Double> $this$varianceAndMean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator<Double> iterator2 = $this$varianceAndMean.iterator();
        while (iterator2.hasNext()) {
            double element = ((Number)iterator2.next()).doubleValue();
            if (Double.isNaN(element)) {
                if (skipNA) continue;
                return null;
            }
            sum2 += element;
            ++count;
        }
        double mean = sum2 / (double)count;
        double variance = 0.0;
        Iterator<Double> iterator3 = $this$varianceAndMean.iterator();
        while (iterator3.hasNext()) {
            double element = ((Number)iterator3.next()).doubleValue();
            if (Double.isNaN(element)) continue;
            double diff = element - mean;
            variance += diff * diff;
        }
        return new BasicStats(count, mean, variance);
    }

    public static /* synthetic */ BasicStats doubleVarianceAndMean$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return StdMeanKt.doubleVarianceAndMean(iterable, bl);
    }

    @JvmName(name="floatVarianceAndMean")
    @Nullable
    public static final BasicStats floatVarianceAndMean(@NotNull Iterable<Float> $this$varianceAndMean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator<Float> iterator2 = $this$varianceAndMean.iterator();
        while (iterator2.hasNext()) {
            float element = ((Number)iterator2.next()).floatValue();
            if (Float.isNaN(element)) {
                if (skipNA) continue;
                return null;
            }
            sum2 += (double)element;
            ++count;
        }
        double mean = sum2 / (double)count;
        double variance = 0.0;
        Iterator<Float> iterator3 = $this$varianceAndMean.iterator();
        while (iterator3.hasNext()) {
            float element = ((Number)iterator3.next()).floatValue();
            if (Float.isNaN(element)) continue;
            double diff = (double)element - mean;
            variance += diff * diff;
        }
        return new BasicStats(count, mean, variance);
    }

    public static /* synthetic */ BasicStats floatVarianceAndMean$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return StdMeanKt.floatVarianceAndMean(iterable, bl);
    }

    @JvmName(name="intVarianceAndMean")
    @NotNull
    public static final BasicStats intVarianceAndMean(@NotNull Iterable<Integer> $this$varianceAndMean) {
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator<Integer> iterator2 = $this$varianceAndMean.iterator();
        while (iterator2.hasNext()) {
            int element = ((Number)iterator2.next()).intValue();
            sum2 += (double)element;
            ++count;
        }
        double mean = sum2 / (double)count;
        double variance = 0.0;
        Iterator<Integer> iterator3 = $this$varianceAndMean.iterator();
        while (iterator3.hasNext()) {
            int element = ((Number)iterator3.next()).intValue();
            double diff = (double)element - mean;
            variance += diff * diff;
        }
        return new BasicStats(count, mean, variance);
    }

    @JvmName(name="longVarianceAndMean")
    @NotNull
    public static final BasicStats longVarianceAndMean(@NotNull Iterable<Long> $this$varianceAndMean) {
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator<Long> iterator2 = $this$varianceAndMean.iterator();
        while (iterator2.hasNext()) {
            long element = ((Number)iterator2.next()).longValue();
            sum2 += (double)element;
            ++count;
        }
        double mean = sum2 / (double)count;
        double variance = 0.0;
        Iterator<Long> iterator3 = $this$varianceAndMean.iterator();
        while (iterator3.hasNext()) {
            long element = ((Number)iterator3.next()).longValue();
            double diff = (double)element - mean;
            variance += diff * diff;
        }
        return new BasicStats(count, mean, variance);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="bigDecimalVarianceAndMean")
    @NotNull
    public static final BasicStats bigDecimalVarianceAndMean(@NotNull Iterable<? extends BigDecimal> $this$varianceAndMean) {
        void var4_8;
        Object object;
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        BigDecimal sum2 = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : $this$varianceAndMean) {
            object = sum2;
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)((BigDecimal)object).add(bigDecimal), (String)"add(...)");
            ++count;
        }
        BigDecimal bigDecimal = sum2;
        Intrinsics.checkNotNull((Object)bigDecimal);
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimal.valueOf(count);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
        object = bigDecimal3;
        BigDecimal bigDecimal4 = bigDecimal2.divide((BigDecimal)object, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
        BigDecimal mean = bigDecimal4;
        BigDecimal bigDecimal5 = BigDecimal.ZERO;
        for (BigDecimal bigDecimal6 : $this$varianceAndMean) {
            BigDecimal bigDecimal7;
            BigDecimal diff;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6.subtract(mean), (String)"subtract(...)");
            void var8_13 = var4_8;
            Intrinsics.checkNotNull((Object)var8_13);
            Intrinsics.checkNotNullExpressionValue((Object)diff.multiply(diff), (String)"multiply(...)");
            Intrinsics.checkNotNullExpressionValue((Object)var8_13.add(bigDecimal7), (String)"add(...)");
        }
        return new BasicStats(count, mean.doubleValue(), var4_8.doubleValue());
    }

    @JvmName(name="bigIntegerVarianceAndMean")
    @NotNull
    public static final BasicStats bigIntegerVarianceAndMean(@NotNull Iterable<? extends BigInteger> $this$varianceAndMean) {
        Intrinsics.checkNotNullParameter($this$varianceAndMean, (String)"<this>");
        int count = 0;
        BigInteger sum2 = BigInteger.ZERO;
        for (BigInteger bigInteger : $this$varianceAndMean) {
            BigInteger bigInteger2 = sum2;
            Intrinsics.checkNotNull((Object)bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.add(bigInteger), (String)"add(...)");
            ++count;
        }
        double mean = sum2.doubleValue() / (double)count;
        double variance = 0.0;
        for (BigInteger bigInteger : $this$varianceAndMean) {
            double diff = bigInteger.doubleValue() - mean;
            variance += diff * diff;
        }
        return new BasicStats(count, mean, variance);
    }
}

