/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.math.SumKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0001\u001a0\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\t2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00120\t2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0013\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0014\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00120\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0015\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0001\u00a2\u0006\u0002\b\u0017\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00180\u0004H\u0001\u00a2\u0006\u0002\b\u0019\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u001a0\u0004H\u0001\u00a2\u0006\u0002\b\u001b\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u001c0\u0004H\u0001\u00a2\u0006\u0002\b\u001d\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u001e0\u0004H\u0001\u00a2\u0006\u0002\b\u001f\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020 0\u0004H\u0001\u00a2\u0006\u0002\b!\"J\u0010\n\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000bj\u0002`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"mean", "", "T", "", "", "type", "Lkotlin/reflect/KType;", "skipNA", "", "Lkotlin/sequences/Sequence;", "meanTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnTypeOrNull;", "getMeanTypeConversion", "()Lkotlin/jvm/functions/Function2;", "", "meanFloat", "doubleMean", "floatMean", "", "intMean", "", "shortMean", "", "byteMean", "", "longMean", "Ljava/math/BigInteger;", "bigIntegerMean", "Ljava/math/BigDecimal;", "bigDecimalMean", "core"})
@SourceDebugExtension(value={"SMAP\nmean.kt\nKotlin\n*S Kotlin\n*F\n+ 1 mean.kt\norg/jetbrains/kotlinx/dataframe/math/MeanKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class MeanKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> meanTypeConversion = MeanKt::meanTypeConversion$lambda$7;

    @PublishedApi
    public static final <T extends Number> double mean(@NotNull Iterable<? extends T> $this$mean, @NotNull KType type, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return MeanKt.mean(CollectionsKt.asSequence($this$mean), type, skipNA);
    }

    public static /* synthetic */ double mean$default(Iterable iterable, KType kType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.mean(iterable, kType, bl);
    }

    public static final <T extends Number> double mean(@NotNull Sequence<? extends T> $this$mean, @NotNull KType type, boolean skipNA) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            return MeanKt.mean(SequencesKt.filterNotNull($this$mean), KTypes.withNullability((KType)type, (boolean)false), skipNA);
        }
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            d = MeanKt.mean($this$mean, skipNA);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            d = MeanKt.meanFloat($this$mean, skipNA);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$0), false);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$1), false);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$2), false);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$3), false);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$4), false);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$5), skipNA);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$6), skipNA);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            d = Double.NaN;
        } else {
            throw new IllegalArgumentException("Unable to compute the mean for type " + RenderingKt.renderType(type));
        }
        return d;
    }

    public static /* synthetic */ double mean$default(Sequence sequence, KType kType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.mean(sequence, kType, bl);
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getMeanTypeConversion() {
        return meanTypeConversion;
    }

    public static final double mean(@NotNull Sequence<Double> $this$mean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator iterator2 = $this$mean.iterator();
        while (iterator2.hasNext()) {
            double element = ((Number)iterator2.next()).doubleValue();
            if (Double.isNaN(element)) {
                if (skipNA) continue;
                return Double.NaN;
            }
            sum2 += element;
            ++count;
        }
        return count > 0 ? sum2 / (double)count : Double.NaN;
    }

    public static /* synthetic */ double mean$default(Sequence sequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.mean((Sequence<Double>)sequence, bl);
    }

    @JvmName(name="meanFloat")
    public static final double meanFloat(@NotNull Sequence<Float> $this$mean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        int count = 0;
        double sum2 = 0.0;
        Iterator iterator2 = $this$mean.iterator();
        while (iterator2.hasNext()) {
            float element = ((Number)iterator2.next()).floatValue();
            if (Float.isNaN(element)) {
                if (skipNA) continue;
                return Double.NaN;
            }
            sum2 += (double)element;
            ++count;
        }
        return count > 0 ? sum2 / (double)count : Double.NaN;
    }

    public static /* synthetic */ double meanFloat$default(Sequence sequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.meanFloat((Sequence<Float>)sequence, bl);
    }

    @JvmName(name="doubleMean")
    public static final double doubleMean(@NotNull Iterable<Double> $this$mean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        return MeanKt.mean((Sequence<Double>)CollectionsKt.asSequence($this$mean), skipNA);
    }

    public static /* synthetic */ double doubleMean$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.doubleMean(iterable, bl);
    }

    @JvmName(name="floatMean")
    public static final double floatMean(@NotNull Iterable<Float> $this$mean, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        return MeanKt.meanFloat((Sequence<Float>)CollectionsKt.asSequence($this$mean), skipNA);
    }

    public static /* synthetic */ double floatMean$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        return MeanKt.floatMean(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="intMean")
    public static final double intMean(@NotNull Iterable<Integer> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            if (((Collection)$this$mean).size() > 0) {
                Iterable<Integer> iterable = $this$mean;
                double d2 = 0.0;
                for (Integer n : iterable) {
                    void it;
                    int n2 = ((Number)n).intValue();
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = (double)it;
                    d2 = d3 + d4;
                }
                d = d2 / (double)((Collection)$this$mean).size();
            } else {
                d = Double.NaN;
            }
        } else {
            int count = 0;
            Iterable<Integer> iterable = $this$mean;
            double d5 = 0.0;
            for (Integer n : iterable) {
                void it;
                int n3 = ((Number)n).intValue();
                double d6 = d5;
                boolean bl = false;
                ++count;
                double d7 = (double)it;
                d5 = d6 + d7;
            }
            double sum2 = d5;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="shortMean")
    public static final double shortMean(@NotNull Iterable<Short> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            if (((Collection)$this$mean).size() > 0) {
                Iterable<Short> iterable = $this$mean;
                double d2 = 0.0;
                for (Short s : iterable) {
                    void it;
                    short s2 = ((Number)s).shortValue();
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = (double)it;
                    d2 = d3 + d4;
                }
                d = d2 / (double)((Collection)$this$mean).size();
            } else {
                d = Double.NaN;
            }
        } else {
            int count = 0;
            Iterable<Short> iterable = $this$mean;
            double d5 = 0.0;
            for (Short s : iterable) {
                void it;
                short s3 = ((Number)s).shortValue();
                double d6 = d5;
                boolean bl = false;
                ++count;
                double d7 = (double)it;
                d5 = d6 + d7;
            }
            double sum2 = d5;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="byteMean")
    public static final double byteMean(@NotNull Iterable<Byte> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            if (((Collection)$this$mean).size() > 0) {
                Iterable<Byte> iterable = $this$mean;
                double d2 = 0.0;
                for (Byte by2 : iterable) {
                    void it;
                    byte by3 = ((Number)by2).byteValue();
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = (double)it;
                    d2 = d3 + d4;
                }
                d = d2 / (double)((Collection)$this$mean).size();
            } else {
                d = Double.NaN;
            }
        } else {
            int count = 0;
            Iterable<Byte> iterable = $this$mean;
            double d5 = 0.0;
            for (Byte by4 : iterable) {
                void it;
                byte by5 = ((Number)by4).byteValue();
                double d6 = d5;
                boolean bl = false;
                ++count;
                double d7 = (double)it;
                d5 = d6 + d7;
            }
            double sum2 = d5;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="longMean")
    public static final double longMean(@NotNull Iterable<Long> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            if (((Collection)$this$mean).size() > 0) {
                Iterable<Long> iterable = $this$mean;
                double d2 = 0.0;
                for (Long l : iterable) {
                    void it;
                    long l2 = ((Number)l).longValue();
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = (double)it;
                    d2 = d3 + d4;
                }
                d = d2 / (double)((Collection)$this$mean).size();
            } else {
                d = Double.NaN;
            }
        } else {
            int count = 0;
            Iterable<Long> iterable = $this$mean;
            double d5 = 0.0;
            for (Long l : iterable) {
                void it;
                long l3 = ((Number)l).longValue();
                double d6 = d5;
                boolean bl = false;
                ++count;
                double d7 = (double)it;
                d5 = d6 + d7;
            }
            double sum2 = d5;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="bigIntegerMean")
    public static final double bigIntegerMean(@NotNull Iterable<? extends BigInteger> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            if (((Collection)$this$mean).size() > 0) {
                Iterable<? extends BigInteger> iterable = $this$mean;
                double d2 = 0.0;
                Iterator<? extends BigInteger> iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    BigInteger bigInteger;
                    BigInteger bigInteger2 = bigInteger = iterator2.next();
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = it.doubleValue();
                    d2 = d3 + d4;
                }
                d = d2 / (double)((Collection)$this$mean).size();
            } else {
                d = Double.NaN;
            }
        } else {
            int count = 0;
            Iterable<? extends BigInteger> iterable = $this$mean;
            double d5 = 0.0;
            Iterator<? extends BigInteger> iterator3 = iterable.iterator();
            while (iterator3.hasNext()) {
                void it;
                BigInteger bigInteger;
                BigInteger bigInteger3 = bigInteger = iterator3.next();
                double d6 = d5;
                boolean bl = false;
                ++count;
                double d7 = it.doubleValue();
                d5 = d6 + d7;
            }
            double sum2 = d5;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="bigDecimalMean")
    public static final double bigDecimalMean(@NotNull Iterable<? extends BigDecimal> $this$mean) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        if ($this$mean instanceof Collection) {
            d = ((Collection)$this$mean).size() > 0 ? SumKt.sum($this$mean).doubleValue() / (double)((Collection)$this$mean).size() : Double.NaN;
        } else {
            int count = 0;
            Iterable<? extends BigDecimal> iterable = $this$mean;
            double d2 = 0.0;
            Iterator<? extends BigDecimal> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = iterator2.next();
                double d3 = d2;
                boolean bl = false;
                ++count;
                double d4 = it.doubleValue();
                d2 = d3 + d4;
            }
            double sum2 = d2;
            d = count > 0 ? sum2 / (double)count : Double.NaN;
        }
        return d;
    }

    private static final double mean$lambda$0(int it) {
        return it;
    }

    private static final double mean$lambda$1(short it) {
        return it;
    }

    private static final double mean$lambda$2(byte it) {
        return it;
    }

    private static final double mean$lambda$3(long it) {
        return it;
    }

    private static final double mean$lambda$4(BigInteger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.doubleValue();
    }

    private static final double mean$lambda$5(BigDecimal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.doubleValue();
    }

    private static final double mean$lambda$6(Number it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.doubleValue();
    }

    private static final KType meanTypeConversion$lambda$7(KType kType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"<unused var>");
        return Reflection.typeOf(Double.TYPE);
    }
}

