/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.math.PercentileKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0010\b\u0000\u0010\u0001\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0081\b\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"median", "T", "", "", "type", "Lkotlin/reflect/KType;", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;)Ljava/lang/Comparable;", "core"})
@SourceDebugExtension(value={"SMAP\nmedian.kt\nKotlin\n*S Kotlin\n*F\n+ 1 median.kt\norg/jetbrains/kotlinx/dataframe/math/MedianKt\n+ 2 percentile.kt\norg/jetbrains/kotlinx/dataframe/math/PercentileKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,11:1\n14#2:12\n17#2:14\n16#2,60:15\n1#3:13\n*S KotlinDebug\n*F\n+ 1 median.kt\norg/jetbrains/kotlinx/dataframe/math/MedianKt\n*L\n10#1:12\n10#1:14\n10#1:15,60\n10#1:13\n*E\n"})
public final class MedianKt {
    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public static final /* synthetic */ <T extends Comparable<? super T>> T median(Iterable<? extends T> $this$median, KType type) {
        Comparable comparable;
        void $this$percentile$iv;
        Intrinsics.checkNotNullParameter($this$median, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$median = false;
        Iterable<? extends T> iterable = $this$median;
        double percentile$iv = 50.0;
        boolean $i$f$percentile = false;
        if (!(0.0 <= percentile$iv ? percentile$iv <= 100.0 : false)) {
            boolean $i$a$-require-PercentileKt$percentile$1$iv22 = false;
            String $i$a$-require-PercentileKt$percentile$1$iv22 = "Percentile must be in range [0, 100]";
            throw new IllegalArgumentException($i$a$-require-PercentileKt$percentile$1$iv22.toString());
        }
        List list$iv = type.isMarkedNullable() ? CollectionsKt.filterNotNull((Iterable)$this$percentile$iv) : UtilsKt.asList((Iterable)$this$percentile$iv);
        int size$iv = list$iv.size();
        if (size$iv == 0) {
            comparable = null;
        } else {
            int index$iv = (int)(percentile$iv / 100.0 * (double)(size$iv - 1));
            double fraction$iv = percentile$iv / 100.0 * (double)(size$iv - 1) - (double)index$iv;
            if (percentile$iv == 50.0 && size$iv % 2 == 0) {
                Object lower$iv = PercentileKt.quickSelect(list$iv, index$iv);
                Object upper$iv = PercentileKt.quickSelect(list$iv, index$iv + 1);
                KClassifier kClassifier = type.getClassifier();
                if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    double d = (Double)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    Double d2 = (d + (Double)upper$iv) / 2.0;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    float f = ((Float)lower$iv).floatValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    Float f2 = Float.valueOf((f + ((Float)upper$iv).floatValue()) / 2.0f);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = f2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    int n = (Integer)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    Integer n2 = (n + (Integer)upper$iv) / 2;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = n2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    short s = (Short)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    Short s2 = (short)((s + (Short)upper$iv) / 2);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = s2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    long l = (Long)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    Long l2 = (l + (Long)upper$iv) / 2L;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = l2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    byte by2 = (Byte)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    Byte by3 = (byte)((by2 + (Byte)upper$iv) / 2);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = by3;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal = (BigDecimal)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)upper$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"add(...)");
                    BigDecimal bigDecimal3 = BigDecimal.valueOf(2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
                    BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, RoundingMode.HALF_EVEN);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigDecimal4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger = (BigInteger)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger2 = bigInteger.add((BigInteger)upper$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    BigInteger bigInteger3 = BigInteger.valueOf(2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                    BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigInteger4;
                } else {
                    comparable = (Comparable)lower$iv;
                }
            } else if (fraction$iv == 0.0) {
                comparable = (Comparable)PercentileKt.quickSelect(list$iv, index$iv);
            } else {
                Object lower$iv = PercentileKt.quickSelect(list$iv, index$iv);
                Object upper$iv = PercentileKt.quickSelect(list$iv, index$iv + 1);
                KClassifier kClassifier = type.getClassifier();
                if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    double d = (Double)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    Double d3 = d + ((Double)upper$iv - (Double)lower$iv) * fraction$iv;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d3;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    double d = ((Float)lower$iv).floatValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    Double d4 = d + (double)(((Float)upper$iv).floatValue() - ((Float)lower$iv).floatValue()) * fraction$iv;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    double d = ((Integer)lower$iv).intValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    Integer n = (int)(d + (double)((Integer)upper$iv - (Integer)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = n;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    double d = ((Short)lower$iv).shortValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    Short s = (short)(d + (double)((Short)upper$iv - (Short)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = s;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    double d = ((Long)lower$iv).longValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    Long l = (long)(d + (double)((Long)upper$iv - (Long)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = l;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    double d = ((Byte)lower$iv).byteValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    Byte by4 = (byte)(d + (double)((Byte)upper$iv - (Byte)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = by4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal = (BigDecimal)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal5 = ((BigDecimal)upper$iv).subtract((BigDecimal)lower$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"subtract(...)");
                    BigDecimal bigDecimal6 = bigDecimal5.multiply(new BigDecimal(String.valueOf(fraction$iv)));
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
                    BigDecimal bigDecimal7 = bigDecimal.add(bigDecimal6);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"add(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigDecimal7;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger = (BigInteger)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger5 = ((BigInteger)upper$iv).subtract((BigInteger)lower$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"subtract(...)");
                    BigInteger bigInteger6 = bigInteger5;
                    BigInteger bigInteger7 = new BigDecimal(String.valueOf(fraction$iv)).toBigInteger();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"toBigInteger(...)");
                    BigInteger bigInteger8 = bigInteger7;
                    BigInteger bigInteger9 = bigInteger6.multiply(bigInteger8);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
                    bigInteger6 = bigInteger9;
                    BigInteger bigInteger10 = bigInteger.add(bigInteger6);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigInteger10;
                } else {
                    comparable = (Comparable)lower$iv;
                }
            }
        }
        return (T)comparable;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Comparable median$default(Iterable $this$median_u24default, KType type, int n, Object object) {
        Comparable comparable;
        void $this$percentile$iv;
        if ((n & 1) != 0) {
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            type = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$median_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$median = false;
        object = $this$median_u24default;
        double percentile$iv = 50.0;
        boolean $i$f$percentile = false;
        if (!(0.0 <= percentile$iv ? percentile$iv <= 100.0 : false)) {
            boolean $i$a$-require-PercentileKt$percentile$1$iv22 = false;
            String $i$a$-require-PercentileKt$percentile$1$iv22 = "Percentile must be in range [0, 100]";
            throw new IllegalArgumentException($i$a$-require-PercentileKt$percentile$1$iv22.toString());
        }
        List list$iv = type.isMarkedNullable() ? CollectionsKt.filterNotNull((Iterable)$this$percentile$iv) : UtilsKt.asList((Iterable)$this$percentile$iv);
        int size$iv = list$iv.size();
        if (size$iv == 0) {
            comparable = null;
        } else {
            int index$iv = (int)(percentile$iv / 100.0 * (double)(size$iv - 1));
            double fraction$iv = percentile$iv / 100.0 * (double)(size$iv - 1) - (double)index$iv;
            if (percentile$iv == 50.0 && size$iv % 2 == 0) {
                Object lower$iv = PercentileKt.quickSelect(list$iv, index$iv);
                Object upper$iv = PercentileKt.quickSelect(list$iv, index$iv + 1);
                KClassifier kClassifier = type.getClassifier();
                if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    double d = (Double)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    Double d2 = (d + (Double)upper$iv) / 2.0;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    float f = ((Float)lower$iv).floatValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    Float f2 = Float.valueOf((f + ((Float)upper$iv).floatValue()) / 2.0f);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = f2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    int n2 = (Integer)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    Integer n3 = (n2 + (Integer)upper$iv) / 2;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = n3;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    short s = (Short)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    Short s2 = (short)((s + (Short)upper$iv) / 2);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = s2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    long l = (Long)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    Long l2 = (l + (Long)upper$iv) / 2L;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = l2;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    byte by2 = (Byte)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    Byte by3 = (byte)((by2 + (Byte)upper$iv) / 2);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = by3;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal = (BigDecimal)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)upper$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"add(...)");
                    BigDecimal bigDecimal3 = BigDecimal.valueOf(2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
                    BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, RoundingMode.HALF_EVEN);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigDecimal4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger = (BigInteger)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger2 = bigInteger.add((BigInteger)upper$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    BigInteger bigInteger3 = BigInteger.valueOf(2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                    BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigInteger4;
                } else {
                    comparable = (Comparable)lower$iv;
                }
            } else if (fraction$iv == 0.0) {
                comparable = (Comparable)PercentileKt.quickSelect(list$iv, index$iv);
            } else {
                Object lower$iv = PercentileKt.quickSelect(list$iv, index$iv);
                Object upper$iv = PercentileKt.quickSelect(list$iv, index$iv + 1);
                KClassifier kClassifier = type.getClassifier();
                if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    double d = (Double)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Double");
                    Double d3 = d + ((Double)upper$iv - (Double)lower$iv) * fraction$iv;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d3;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    double d = ((Float)lower$iv).floatValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Float");
                    Double d4 = d + (double)(((Float)upper$iv).floatValue() - ((Float)lower$iv).floatValue()) * fraction$iv;
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = d4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    double d = ((Integer)lower$iv).intValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Int");
                    Integer n4 = (int)(d + (double)((Integer)upper$iv - (Integer)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = n4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    double d = ((Short)lower$iv).shortValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Short");
                    Short s = (short)(d + (double)((Short)upper$iv - (Short)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = s;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    double d = ((Long)lower$iv).longValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Long");
                    Long l = (long)(d + (double)((Long)upper$iv - (Long)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = l;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    double d = ((Byte)lower$iv).byteValue();
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type kotlin.Byte");
                    Byte by4 = (byte)(d + (double)((Byte)upper$iv - (Byte)lower$iv) * fraction$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = by4;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal = (BigDecimal)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                    BigDecimal bigDecimal5 = ((BigDecimal)upper$iv).subtract((BigDecimal)lower$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"subtract(...)");
                    BigDecimal bigDecimal6 = bigDecimal5.multiply(new BigDecimal(String.valueOf(fraction$iv)));
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
                    BigDecimal bigDecimal7 = bigDecimal.add(bigDecimal6);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"add(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigDecimal7;
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    Intrinsics.checkNotNull(lower$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger = (BigInteger)lower$iv;
                    Intrinsics.checkNotNull(upper$iv, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger bigInteger5 = ((BigInteger)upper$iv).subtract((BigInteger)lower$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"subtract(...)");
                    BigInteger bigInteger6 = bigInteger5;
                    BigInteger bigInteger7 = new BigDecimal(String.valueOf(fraction$iv)).toBigInteger();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"toBigInteger(...)");
                    BigInteger bigInteger8 = bigInteger7;
                    BigInteger bigInteger9 = bigInteger6.multiply(bigInteger8);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
                    bigInteger6 = bigInteger9;
                    BigInteger bigInteger10 = bigInteger.add(bigInteger6);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    comparable = bigInteger10;
                } else {
                    comparable = (Comparable)lower$iv;
                }
            }
        }
        return comparable;
    }
}

