/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import androidx.compose.compiler.plugins.kotlin.KtxNameConventions;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a-\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\b*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"unsafeSymbolsRegex", "Lkotlin/text/Regex;", "composerParam", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isComposerParam", "", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "arity", "", "hasAnnotationSafe", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "annotationClass", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getAnnotationClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "includeFileNameInExceptionTrace", "T", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "topLevelName", "", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nAbstractComposeLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractComposeLowering.kt\nandroidx/compose/compiler/plugins/kotlin/lower/AbstractComposeLoweringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1494:1\n1755#2,3:1495\n*S KotlinDebug\n*F\n+ 1 AbstractComposeLowering.kt\nandroidx/compose/compiler/plugins/kotlin/lower/AbstractComposeLoweringKt\n*L\n1472#1:1495,3\n*E\n"})
public final class AbstractComposeLoweringKt {
    @NotNull
    private static final Regex unsafeSymbolsRegex = new Regex("[ <>]");

    @Nullable
    public static final IrValueParameter composerParam(@NotNull IrFunction $this$composerParam) {
        Intrinsics.checkNotNullParameter((Object)$this$composerParam, (String)"<this>");
        for (IrValueParameter param : CollectionsKt.asReversed((List)$this$composerParam.getValueParameters())) {
            if (AbstractComposeLoweringKt.isComposerParam(param)) {
                return param;
            }
            String string = param.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) continue;
            return null;
        }
        return null;
    }

    public static final boolean isComposerParam(@NotNull IrValueParameter $this$isComposerParam) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposerParam, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isComposerParam.getName(), (Object)KtxNameConventions.INSTANCE.getCOMPOSER_PARAMETER()) && Intrinsics.areEqual((Object)IrTypesKt.getClassFqName((IrType)$this$isComposerParam.getType()), (Object)ComposeFqNames.INSTANCE.getComposer());
    }

    @NotNull
    public static final IrClassSymbol function(@NotNull IrPluginContext $this$function, int arity) {
        Intrinsics.checkNotNullParameter((Object)$this$function, (String)"<this>");
        FqName fqName = new FqName("kotlin");
        Name name = Name.identifier((String)("Function" + arity));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        IrClassSymbol irClassSymbol = $this$function.referenceClass(new ClassId(fqName, name));
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    public static final boolean hasAnnotationSafe(@NotNull IrAnnotationContainer $this$hasAnnotationSafe, @NotNull FqName fqName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasAnnotationSafe, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Iterable $this$any$iv = $this$hasAnnotationSafe.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrConstructorCall it = (IrConstructorCall)element$iv;
                    boolean bl2 = false;
                    IrClassSymbol irClassSymbol = AbstractComposeLoweringKt.getAnnotationClass(it);
                    if (!Intrinsics.areEqual((Object)fqName, irClassSymbol != null && (irClassSymbol = (ClassDescriptor)irClassSymbol.getDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)irClassSymbol)) : null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final IrClassSymbol getAnnotationClass(@NotNull IrConstructorCall $this$annotationClass) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationClass, (String)"<this>");
        return IrTypesKt.getClassOrNull((IrType)$this$annotationClass.getType());
    }

    public static final <T> T includeFileNameInExceptionTrace(@NotNull IrFile file, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$includeFileNameInExceptionTrace = false;
        try {
            return (T)body.invoke();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("IR lowering failed at: " + IrDeclarationsKt.getName((IrFile)file), e);
        }
    }

    @NotNull
    public static final String topLevelName(@NotNull FqName $this$topLevelName) {
        Intrinsics.checkNotNullParameter((Object)$this$topLevelName, (String)"<this>");
        String string = $this$topLevelName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return StringsKt.substringBefore$default((String)string, (String)".", null, (int)2, null);
    }

    public static final /* synthetic */ Regex access$getUnsafeSymbolsRegex$p() {
        return unsafeSymbolsRegex;
    }
}

