/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.atomicfu.compiler.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlinx.atomicfu.compiler.backend.jvm.AtomicfuJvmIrTransformer;
import org.jetbrains.kotlinx.atomicfu.compiler.backend.jvm.JvmAtomicSymbols;
import org.jetbrains.kotlinx.atomicfu.compiler.backend.native.AtomicfuNativeIrTransformer;
import org.jetbrains.kotlinx.atomicfu.compiler.backend.native.NativeAtomicSymbols;
import org.jetbrains.kotlinx.atomicfu.compiler.extensions.AtomicfuClassLowering;
import org.jetbrains.kotlinx.atomicfu.compiler.extensions.AtomicfuLoweringExtensionKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/atomicfu/compiler/extensions/AtomicfuLoweringExtension;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "<init>", "()V", "generate", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "kotlin-atomicfu-compiler-plugin"})
public class AtomicfuLoweringExtension
implements IrGenerationExtension {
    public void generate(@NotNull IrModuleFragment moduleFragment, @NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        TargetPlatform platform = pluginContext.getPlatform();
        if (JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            new AtomicfuJvmIrTransformer(new JvmAtomicSymbols(pluginContext, moduleFragment), pluginContext).transform(moduleFragment);
        } else if (NativePlatformKt.isNative((TargetPlatform)platform)) {
            new AtomicfuNativeIrTransformer(new NativeAtomicSymbols(pluginContext, moduleFragment), pluginContext).transform(moduleFragment);
        } else if (JsPlatformKt.isJs((TargetPlatform)platform)) {
            for (IrFile file : moduleFragment.getFiles()) {
                AtomicfuLoweringExtensionKt.runOnFileInOrder(new AtomicfuClassLowering(pluginContext), file);
            }
        }
    }
}

