/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin.k2.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.assignment.plugin.k2.FirAssignAnnotationMatchingServiceKt;
import org.jetbrains.kotlin.assignment.plugin.k2.diagnostics.FirErrorsAssignmentPlugin;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;)V", "isAssignMethod", "", "kotlin-assignment-compiler-plugin.k2"})
public final class FirAssignmentPluginFunctionChecker
extends FirDeclarationChecker<FirNamedFunction> {
    @NotNull
    public static final FirAssignmentPluginFunctionChecker INSTANCE = new FirAssignmentPluginFunctionChecker();

    private FirAssignmentPluginFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirNamedFunction declaration) {
        FirRegularClassSymbol receiverClassSymbol;
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        if (!this.isAssignMethod(declaration)) {
            return;
        }
        if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)((FirCallableDeclaration)declaration))) {
            FirResolvedTypeRef firResolvedTypeRef = declaration.getSymbol().getResolvedReceiverTypeRef();
            firRegularClassSymbol = firResolvedTypeRef != null ? TypeUtilsKt.toRegularClassSymbol((FirTypeRef)((FirTypeRef)firResolvedTypeRef), (FirSession)context.getSession()) : null;
        } else {
            ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
            firRegularClassSymbol = receiverClassSymbol = coneSimpleKotlinType != null ? ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)((SessionHolder)context), (ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType)) : null;
        }
        if (!FirAssignAnnotationMatchingServiceKt.getAnnotationMatchingService(context.getSession()).isAnnotated(receiverClassSymbol)) {
            return;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)context), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getDECLARATION_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT(), null, (int)8, null);
        }
    }

    private final boolean isAssignMethod(FirNamedFunction $this$isAssignMethod) {
        return $this$isAssignMethod.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)$this$isAssignMethod.getName(), (Object)OperatorConventions.ASSIGN_METHOD);
    }
}

