/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.scopes;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.name.Name;

@KaExperimentalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/api/scopes/KaScopeLike;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner;", "getAllPossibleNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getPossibleCallableNames", "getPossibleClassifierNames", "mayContainName", "", "name", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKaScopeLike.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaScopeLike.kt\norg/jetbrains/kotlin/analysis/api/scopes/KaScopeLike\n+ 2 KaLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerKt\n+ 3 KaLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenKt\n*L\n1#1,48:1\n23#2:49\n19#2:50\n20#2,5:58\n23#2:63\n19#2:64\n20#2,5:72\n24#3,7:51\n24#3,7:65\n*S KotlinDebug\n*F\n+ 1 KaScopeLike.kt\norg/jetbrains/kotlin/analysis/api/scopes/KaScopeLike\n*L\n19#1:49\n19#1:50\n19#1:58,5\n40#1:63\n40#1:64\n40#1:72,5\n19#1:51,7\n40#1:65,7\n*E\n"})
public interface KaScopeLike
extends KaLifetimeOwner {
    @NotNull
    default public Set<Name> getAllPossibleNames() {
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return SetsKt.plus(this.getPossibleCallableNames(), (Iterable)this.getPossibleClassifierNames());
    }

    @NotNull
    public Set<Name> getPossibleCallableNames();

    @NotNull
    public Set<Name> getPossibleClassifierNames();

    default public boolean mayContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this.getPossibleCallableNames().contains(name) || this.getPossibleClassifierNames().contains(name);
    }
}

