/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaCompileTimeConstantProvider;
import org.jetbrains.kotlin.analysis.api.components.KaConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "evaluate", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KaConstantEvaluationMode;", "evaluateAsAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "evaluateFir", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
public final class KaFirCompileTimeConstantProvider
extends KaCompileTimeConstantProvider
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirCompileTimeConstantProvider(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KaConstantValue evaluate(@NotNull KtExpression expression, @NotNull KaConstantEvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)expression, this.getFirResolveSession()), expression, mode);
    }

    @Override
    @Nullable
    public KaAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression expression) {
        KaAnnotationValue kaAnnotationValue;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)expression, this.getFirResolveSession());
        FirExpression firExpression = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl = false;
            kaAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir());
        } else {
            kaAnnotationValue = null;
        }
        return kaAnnotationValue;
    }

    private final KaConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi, KaConstantEvaluationMode mode) {
        KaConstantValue kaConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KaConstantValue kaConstantValue2;
            try {
                kaConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir, mode);
            }
            catch (ArithmeticException e) {
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                kaConstantValue2 = new KaConstantValue.KaErrorConstantValue(string, (KtElement)sourcePsi);
            }
            kaConstantValue = kaConstantValue2;
        } else {
            kaConstantValue = null;
        }
        return kaConstantValue;
    }
}

