/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.TargetPlatformEnum;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CliTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.LibraryWasNotCompiledDueToExpectedCompilationError;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J4\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H$J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006H$J6\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "<init>", "()V", "buildPlatformCompilerOptions", "", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "doCompile", "", "sourcesPath", "Ljava/nio/file/Path;", "options", "libraryOutputPath", "extraClasspath", "inputPath", "libraryName", "compile", "tmpDir", "dependencyBinaryRoots", "", "compileSources", "files", "Lorg/jetbrains/kotlin/test/model/TestFile;", "buildExtraClasspath", "buildPlatformExtraClasspath", "buildCompilerOptions", "buildCommonCompilerOptions", "addFileToJar", "path", "text", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "analysis-test-framework_testFixtures"})
@SourceDebugExtension(value={"SMAP\nCliTestModuleCompilers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliTestModuleCompilers.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1586#2:277\n1661#2,3:278\n1661#2,3:282\n1915#2,2:285\n1#3:281\n*S KotlinDebug\n*F\n+ 1 CliTestModuleCompilers.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler\n*L\n51#1:277\n51#1:278,3\n99#1:282,3\n118#1:285,2\n*E\n"})
public abstract class CliTestModuleCompiler
extends TestModuleCompiler {
    @NotNull
    protected abstract List<String> buildPlatformCompilerOptions(@NotNull TestModule var1, @NotNull TestServices var2);

    protected abstract void doCompile(@NotNull Path var1, @NotNull List<String> var2, @NotNull Path var3, @NotNull List<String> var4);

    @NotNull
    protected abstract Path libraryOutputPath(@NotNull Path var1, @NotNull String var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Path compile(@NotNull Path tmpDir, @NotNull TestModule module, @NotNull String libraryName, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices) {
        Iterable library;
        block11: {
            block10: {
                boolean bl;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
                Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
                Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
                Iterable $this$map$iv = module.getDirectives().get(TestModuleCompiler.Directives.INSTANCE.getLIBRARY_PLATFORMS());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TargetPlatformEnum targetPlatformEnum = (TargetPlatformEnum)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getTargetPlatform());
                }
                List allowedLibraryPlatforms = (List)destination$iv$iv;
                boolean compilationErrorExpected = module.getDirectives().contains((Directive)TestModuleCompiler.Directives.INSTANCE.getCOMPILATION_ERRORS()) || !((Collection)allowedLibraryPlatforms).isEmpty() && !allowedLibraryPlatforms.contains(TargetPlatformProviderKt.targetPlatform((TestModule)module, (TestServices)testServices));
                try {
                    Path outputPath = this.libraryOutputPath(tmpDir, libraryName);
                    this.doCompile(tmpDir, this.buildCompilerOptions(module, testServices), outputPath, this.buildExtraClasspath(module, dependencyBinaryRoots, testServices));
                    iterable = outputPath;
                }
                catch (Throwable e) {
                    if (!compilationErrorExpected) {
                        throw new IllegalStateException("Unexpected compilation error while compiling library", e);
                    }
                    iterable = null;
                }
                Iterable iterable2 = library = iterable;
                if (iterable2 != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl = Files.exists((Path)iterable2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                } else {
                    bl = false;
                }
                if (bl && compilationErrorExpected) {
                    throw new IllegalStateException("Compilation error expected but, code was compiled successfully".toString());
                }
                if (library == null) break block10;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.notExists((Path)library, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block11;
            }
            throw new LibraryWasNotCompiledDueToExpectedCompilationError();
        }
        return library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Path compileSources(@NotNull List<TestFile> files, @NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Path tmpDir = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
        Intrinsics.checkNotNull((Object)tmpDir);
        Path path = tmpDir.resolve(module.getName() + "-sources.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path librarySourcesPath = path;
        Object object = new Manifest();
        Manifest $this$compileSources_u24lambda_u240 = object;
        boolean bl = false;
        Attributes attributes = $this$compileSources_u24lambda_u240.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getMainAttributes(...)");
        Map map = attributes;
        Attributes.Name name = Attributes.Name.MANIFEST_VERSION;
        String string = "1.0";
        map.put(name, string);
        Manifest manifest = object;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(librarySourcesPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = new JarOutputStream(outputStream, manifest);
        Throwable throwable = null;
        try {
            JarOutputStream jarOutputStream = (JarOutputStream)object;
            boolean bl2 = false;
            for (TestFile testFile : files) {
                String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
                this.addFileToJar(testFile.getRelativePath(), text2, jarOutputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return librarySourcesPath;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> buildExtraClasspath(TestModule module, Collection<? extends Path> dependencyBinaryRoots, TestServices testServices) {
        void $this$mapTo$iv;
        List list;
        List $this$buildExtraClasspath_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildExtraClasspath_u24lambda_u240.addAll((Collection)this.buildPlatformExtraClasspath(module, testServices));
        Iterable iterable = dependencyBinaryRoots;
        Collection destination$iv = $this$buildExtraClasspath_u24lambda_u240;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Path path = (Path)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    protected List<String> buildPlatformExtraClasspath(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return CollectionsKt.emptyList();
    }

    private final List<String> buildCompilerOptions(TestModule module, TestServices testServices) {
        List list;
        List $this$buildCompilerOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildCompilerOptions_u24lambda_u240.addAll((Collection)this.buildCommonCompilerOptions(module));
        $this$buildCompilerOptions_u24lambda_u240.addAll((Collection)this.buildPlatformCompilerOptions(module, testServices));
        return CollectionsKt.build((List)list);
    }

    private final List<String> buildCommonCompilerOptions(TestModule module) {
        Object[] objectArray;
        List list;
        List $this$buildCommonCompilerOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ApiVersion apiVersion = (ApiVersion)DirectiveKt.singleOrZeroValue((RegisteredDirectives)module.getDirectives(), (ValueDirective)LanguageSettingsDirectives.INSTANCE.getAPI_VERSION());
        if (apiVersion != null) {
            ApiVersion apiVersion2 = apiVersion;
            boolean bl2 = false;
            objectArray = new String[]{ArgumentUtilsKt.getCliArgument((KProperty1)((KProperty1)buildCommonCompilerOptions.1.1.1.INSTANCE)), apiVersion2.getVersionString()};
            $this$buildCommonCompilerOptions_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        LanguageVersion languageVersion = (LanguageVersion)DirectiveKt.singleOrZeroValue((RegisteredDirectives)module.getDirectives(), (ValueDirective)LanguageSettingsDirectives.INSTANCE.getLANGUAGE_VERSION());
        if (languageVersion != null) {
            LanguageVersion languageVersion2 = languageVersion;
            boolean bl3 = false;
            objectArray = new String[]{ArgumentUtilsKt.getCliArgument((KProperty1)((KProperty1)buildCommonCompilerOptions.1.2.1.INSTANCE)), languageVersion2.getVersionString()};
            $this$buildCommonCompilerOptions_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        Iterable $this$forEach$iv = module.getDirectives().get(LanguageSettingsDirectives.INSTANCE.getLANGUAGE());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            $this$buildCommonCompilerOptions_u24lambda_u240.add("-XXLanguage:" + it);
        }
        if (module.getDirectives().contains((Directive)LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())) {
            $this$buildCommonCompilerOptions_u24lambda_u240.add(ArgumentUtilsKt.getCliArgument((KProperty1)((KProperty1)buildCommonCompilerOptions.1.4.INSTANCE)));
        }
        $this$buildCommonCompilerOptions_u24lambda_u240.addAll(module.getDirectives().get(TestModuleCompiler.Directives.INSTANCE.getCOMPILER_ARGUMENTS()));
        return CollectionsKt.build((List)list);
    }

    private final void addFileToJar(String path, String text2, JarOutputStream jarOutputStream) {
        jarOutputStream.putNextEntry(new JarEntry(path));
        String string = text2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)jarOutputStream, (int)0, (int)2, null);
        jarOutputStream.closeEntry();
    }
}

