/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based;

import java.io.File;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.LLFirDivergenceUtilsKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "low-level-api-fir_testFixtures"})
@SourceDebugExtension(value={"SMAP\nLLFirIdenticalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirIdenticalChecker.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class LLFirIdenticalChecker
extends AbstractFirIdenticalChecker {
    public LLFirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    protected void checkTestDataFile(@NotNull File testDataFile) {
        String llContent;
        File baseFile;
        String baseContent;
        File file;
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!CustomTestDataUtilsKt.isLLFirTestData((File)testDataFile)) {
            return;
        }
        AbstractFirIdenticalChecker.Helper helper = new AbstractFirIdenticalChecker.Helper((AbstractFirIdenticalChecker)this);
        File originalFile = helper.getClassicFileToCompare(testDataFile);
        File it = file = helper.getFirFileToCompare(originalFile);
        boolean bl = false;
        File file2 = it.exists() ? file : null;
        if (file2 == null) {
            file2 = originalFile;
        }
        if (Intrinsics.areEqual((Object)(baseContent = ((Object)StringsKt.trimStart((CharSequence)helper.readContent(baseFile = file2, true))).toString()), (Object)(llContent = LLFirDivergenceUtilsKt.removeLlFirDivergenceDirective(helper.readContent(testDataFile, false), true)))) {
            AssertionsKt.getAssertions((TestServices)this.getTestServices()).fail(() -> LLFirIdenticalChecker.checkTestDataFile$lambda$1(testDataFile, baseFile));
            throw new KotlinNothingValueException();
        }
        this.assertPreprocessedTestDataAreEqual(this.getTestServices(), baseFile, baseContent, testDataFile, llContent, () -> LLFirIdenticalChecker.checkTestDataFile$lambda$2(baseFile, testDataFile));
    }

    private static final String checkTestDataFile$lambda$1(File $testDataFile, File $baseFile) {
        return '`' + $testDataFile.getName() + "` and `" + $baseFile.getName() + "` are identical. Remove `" + $testDataFile + "`.";
    }

    private static final String checkTestDataFile$lambda$2(File $baseFile, File $testDataFile) {
        return "When ignoring diagnostics, the contents of `" + $baseFile.getName() + "` (expected) and `" + $testDataFile.getName() + "` (actual) are not identical. `.ll.kt` test data may only differ from its base `.fir.kt` or `.kt` test data in the reported diagnostics and the `LL_FIR_DIVERGENCE` directive. Update one of these test data files.";
    }
}

