/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.symbols;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaJavaInteroperabilityComponent;
import org.jetbrains.kotlin.analysis.api.components.KaJavaInteroperabilityComponentKt;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolRelationProvider;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolRelationProviderKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocationKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\n\u001a;\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0000R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"checkContainingFileSymbol", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "ktFileSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol;Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkContainingJvmClassName", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "analysis-api-impl-base_testFixtures"})
public final class SymbolTestUtilsKt {
    public static final void checkContainingFileSymbol(@NotNull KaSession kaSession, @NotNull KaFileSymbol ktFileSymbol, @NotNull KaSymbol symbol, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)ktFileSymbol, (String)"ktFileSymbol");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (symbol.getOrigin() != KaSymbolOrigin.SOURCE) {
            return;
        }
        KaFileSymbol containingFileSymbol = KaSymbolRelationProviderKt.getContainingFile((KaSymbolRelationProvider)((KaSymbolRelationProvider)kaSession), (KaSymbol)symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)ktFileSymbol, (Object)containingFileSymbol, () -> SymbolTestUtilsKt.checkContainingFileSymbol$lambda$0(symbol, ktFileSymbol, containingFileSymbol));
    }

    public static final void checkContainingJvmClassName(@NotNull KaSession kaSession, @NotNull KtFile ktFile, @Nullable KtClassOrObject ktClass, @NotNull KaCallableSymbol symbol, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (ktFile.isScript()) {
            return;
        }
        String expectedClassName = SymbolTestUtilsKt.checkContainingJvmClassName$computeExpectedJvmClassName(symbol, kaSession, ktClass, ktFile);
        String actualClassName = KaJavaInteroperabilityComponentKt.getContainingJvmClassName((KaJavaInteroperabilityComponent)((KaJavaInteroperabilityComponent)kaSession), (KaCallableSymbol)symbol);
        AssertionsKt.getAssertions((TestServices)testServices).assertEquals((Object)expectedClassName, (Object)actualClassName, () -> SymbolTestUtilsKt.checkContainingJvmClassName$lambda$0(symbol, expectedClassName, actualClassName));
    }

    private static final String checkContainingFileSymbol$lambda$0(KaSymbol $symbol, KaFileSymbol $ktFileSymbol, KaFileSymbol $containingFileSymbol) {
        return "Invalid file for " + $symbol + ", expected " + $ktFileSymbol + " but " + $containingFileSymbol + " found";
    }

    private static final String checkContainingJvmClassName$computeExpectedJvmClassName(KaCallableSymbol $this$checkContainingJvmClassName_u24computeExpectedJvmClassName, KaSession kaSession, KtClassOrObject $ktClass, KtFile $ktFile) {
        String string;
        if ($this$checkContainingJvmClassName_u24computeExpectedJvmClassName instanceof KaParameterSymbol) {
            KaSymbol kaSymbol = KaSymbolRelationProviderKt.getContainingSymbol((KaSymbolRelationProvider)((KaSymbolRelationProvider)kaSession), (KaSymbol)((KaSymbol)$this$checkContainingJvmClassName_u24computeExpectedJvmClassName));
            KaFunctionSymbol kaFunctionSymbol = kaSymbol instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaSymbol : null;
            string = kaFunctionSymbol != null ? SymbolTestUtilsKt.checkContainingJvmClassName$computeExpectedJvmClassName((KaCallableSymbol)kaFunctionSymbol, kaSession, $ktClass, $ktFile) : null;
        } else if (KaSymbolLocationKt.isLocal((KaSymbol)((KaSymbol)$this$checkContainingJvmClassName_u24computeExpectedJvmClassName))) {
            string = null;
        } else {
            KtClassOrObject ktClassOrObject = $ktClass;
            if (ktClassOrObject != null) {
                ClassId classId = ktClassOrObject.getClassId();
                string = classId != null ? classId.asFqNameString() : null;
            } else {
                string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)$ktFile).asString();
            }
        }
        return string;
    }

    private static final String checkContainingJvmClassName$lambda$0(KaCallableSymbol $symbol, String $expectedClassName, String $actualClassName) {
        return "Invalid JvmClassName for " + $symbol + ", expected " + $expectedClassName + " but " + $actualClassName + " found";
    }
}

