/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.test;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.test.configurators.AnalysisApiFirSourceTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiExecutionTest;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/test/CustomIsReferenceToTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiExecutionTest;", "<init>", "()V", "configurator", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/test/configurators/AnalysisApiFirSourceTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/test/configurators/AnalysisApiFirSourceTestConfigurator;", "defaultNoArgConstructor", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-api-fir_test"})
public final class CustomIsReferenceToTest
extends AbstractAnalysisApiExecutionTest {
    @NotNull
    private final AnalysisApiFirSourceTestConfigurator configurator = new AnalysisApiFirSourceTestConfigurator(false);

    public CustomIsReferenceToTest() {
        super("analysis/analysis-api/testData/references/customIsReferenceTo");
    }

    @Override
    @NotNull
    public AnalysisApiFirSourceTestConfigurator getConfigurator() {
        return this.configurator;
    }

    @Test
    public final void defaultNoArgConstructor(@NotNull KtFile mainFile) {
        Intrinsics.checkNotNullParameter((Object)mainFile, (String)"mainFile");
        Object object = CollectionsKt.first((List)mainFile.getDeclarations());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
        KtClass fooClass = (KtClass)object;
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)fooClass));
        if (ktLightClass == null) {
            throw new IllegalStateException("Light class cannot be created".toString());
        }
        KtLightClass lightClass = ktLightClass;
        PsiMethod[] psiMethodArray = lightClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        Object object2 = ArraysKt.single((Object[])psiMethodArray);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.asJava.elements.KtLightMethod");
        KtLightMethod lightConstructor = (KtLightMethod)object2;
        Object object3 = CollectionsKt.last((List)mainFile.getDeclarations());
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
        KtNamedFunction usageFunction = (KtNamedFunction)object3;
        List list = usageFunction.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        KtTypeReference ktTypeReference = ((KtParameter)CollectionsKt.single((List)list)).getTypeReference();
        Object object4 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUserType");
        KtUserType typeElement = (KtUserType)object4;
        KtSimpleNameExpression ktSimpleNameExpression = typeElement.getReferenceExpression();
        KtSimpleNameReference typeReference = ktSimpleNameExpression != null ? ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression) : null;
        AssertionsKt.assertNotNull$default((Object)typeReference, null, (int)2, null);
        AssertionsKt.assertTrue$default((boolean)typeReference.isReferenceTo((PsiElement)lightClass), null, (int)2, null);
        AssertionsKt.assertFalse$default((boolean)typeReference.isReferenceTo((PsiElement)lightConstructor), null, (int)2, null);
        Object object5 = usageFunction.getBodyBlockExpression();
        KtExpression ktExpression = object5 != null && (object5 = object5.getStatements()) != null ? (KtExpression)CollectionsKt.single((List)object5) : null;
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        KtCallExpression constructorCall = (KtCallExpression)ktExpression;
        KtExpression ktExpression2 = constructorCall.getCalleeExpression();
        KtReference constructorReference = ktExpression2 != null ? ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression2)) : null;
        AssertionsKt.assertNotNull$default((Object)constructorReference, null, (int)2, null);
        AssertionsKt.assertTrue$default((boolean)constructorReference.isReferenceTo((PsiElement)lightClass), null, (int)2, null);
        AssertionsKt.assertTrue$default((boolean)constructorReference.isReferenceTo((PsiElement)lightConstructor), null, (int)2, null);
    }
}

