/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractOutOfContentRootLazyDeclarationResolveForTypeAnnotationsTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations")
@TestDataPath(value="$PROJECT_ROOT")
public class OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated
extends AbstractOutOfContentRootLazyDeclarationResolveForTypeAnnotationsTest {
    @Test
    public void testAllFilesPresentInLazyResolveTypeAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAlias {
        @Test
        public void testAllFilesPresentInTypeAlias() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="innerAliasWithNestedAnnotationInLocalClass.kt")
        public void testInnerAliasWithNestedAnnotationInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/innerAliasWithNestedAnnotationInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="insideFunction.kt")
        public void testInsideFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunction.kt");
        }

        @Test
        @TestMetadata(value="insideFunctionComplex.kt")
        public void testInsideFunctionComplex() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunctionComplex.kt");
        }

        @Test
        @TestMetadata(value="nestedAliasWithNestedAnnotationInLocalClass.kt")
        public void testNestedAliasWithNestedAnnotationInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/nestedAliasWithNestedAnnotationInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/simple.kt");
        }

        @Test
        @TestMetadata(value="withMissedArguments.kt")
        public void testWithMissedArguments() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/withMissedArguments.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperty {
        @Test
        public void testAllFilesPresentInSyntheticProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="getterAndSetterWithExplicitReturnType.kt")
        public void testGetterAndSetterWithExplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterAndSetterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithExplicitReturnType.kt")
        public void testGetterWithExplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithImplicitReturnType.kt")
        public void testGetterWithImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithImplicitReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SubstitutionOverride {
        @Test
        public void testAllFilesPresentInSubstitutionOverride() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructor.kt")
        public void testConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructor.kt");
        }

        @Test
        @TestMetadata(value="constructorCallSite.kt")
        public void testConstructorCallSite() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructorCallSite.kt");
        }

        @Test
        @TestMetadata(value="function.kt")
        public void testFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/function.kt");
        }

        @Test
        @TestMetadata(value="functionUnavailable.kt")
        public void testFunctionUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/functionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitFunction.kt")
        public void testImplicitFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunction.kt");
        }

        @Test
        @TestMetadata(value="implicitFunctionUnavailable.kt")
        public void testImplicitFunctionUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunctionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitProperty.kt")
        public void testImplicitProperty() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitProperty.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyAndReceiver.kt")
        public void testImplicitPropertyAndReceiver() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyAndReceiver.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyUnavailable.kt")
        public void testImplicitPropertyUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyUnavailable.kt");
        }

        @Test
        @TestMetadata(value="property.kt")
        public void testProperty() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/property.kt");
        }

        @Test
        @TestMetadata(value="propertyUnavailable.kt")
        public void testPropertyUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/propertyUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Property {
        @Test
        public void testAllFilesPresentInProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="contextParameter.kt")
        public void testContextParameter() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextParameter.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnType.kt")
        public void testContextReceiverAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnTypePropagation.kt")
        public void testContextReceiverAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromConstructor.kt")
        public void testGeneratedPropertyFromConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/generatedPropertyFromConstructor.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectAccessors.kt")
        public void testImplicitTypeFromIncorrectAccessors() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectAccessors.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectAccessorsPropagation.kt")
        public void testImplicitTypeFromIncorrectAccessorsPropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectAccessorsPropagation.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectSetter.kt")
        public void testImplicitTypeFromIncorrectSetter() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectSetter.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectSetterPropagation.kt")
        public void testImplicitTypeFromIncorrectSetterPropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectSetterPropagation.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeInLocalClass.kt")
        public void testImplicitTypeInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedType.kt")
        public void testLocalDelegatedPropertyWithPropagatedType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalDelegatedPropertyWithPropagatedTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailable.kt")
        public void testLocalImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailableInImplicitBody.kt")
        public void testLocalImplicitTypeUnavailableInImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localImplicitTypeUnavailableInImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithExplicitType.kt")
        public void testLocalPropertyWithExplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedType.kt")
        public void testLocalPropertyWithPropagatedType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalPropertyWithPropagatedTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberProperties.kt")
        public void testPropagationBetweenLocalMemberProperties() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationBetweenLocalMemberProperties.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberPropertiesImplicitBody.kt")
        public void testPropagationBetweenLocalMemberPropertiesImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationBetweenLocalMemberPropertiesImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberProperty.kt")
        public void testPropagationToLocalMemberProperty() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationToLocalMemberProperty.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberPropertyImplicitBody.kt")
        public void testPropagationToLocalMemberPropertyImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationToLocalMemberPropertyImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propertyTypeCollisionAndAnnotations.kt")
        public void testPropertyTypeCollisionAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propertyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnType.kt")
        public void testReceiverAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/receiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnTypePropagation.kt")
        public void testReceiverAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/receiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/typeParameterAnnotationsInLocalClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Initializer {
        @Test
        public void testAllFilesPresentInInitializer() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classInitializer.kt")
        public void testClassInitializer() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer/classInitializer.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Function {
        @Test
        public void testAllFilesPresentInFunction() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="component1TypeCollisionAndAnnotations.kt")
        public void testComponent1TypeCollisionAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/component1TypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="contextParameter.kt")
        public void testContextParameter() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextParameter.kt");
        }

        @Test
        @TestMetadata(value="contextParameterAsImplicitReturnType.kt")
        public void testContextParameterAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextParameterAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="contextParameterAsImplicitReturnTypePropagation.kt")
        public void testContextParameterAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextParameterAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnType.kt")
        public void testContextReceiverAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnTypePropagation.kt")
        public void testContextReceiverAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="copyTypeCollisionAndAnnotations.kt")
        public void testCopyTypeCollisionAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/copyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotationsAsConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="explicitParameterName.kt")
        public void testExplicitParameterName() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/explicitParameterName.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedComponentN.kt")
        public void testGeneratedComponentN() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedComponentN.kt");
        }

        @Test
        @TestMetadata(value="generatedCopy.kt")
        public void testGeneratedCopy() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedCopy.kt");
        }

        @Test
        @TestMetadata(value="implicitParameterName.kt")
        public void testImplicitParameterName() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitParameterName.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localContextParameters.kt")
        public void testLocalContextParameters() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localContextParameters.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunction.kt");
        }

        @Test
        @TestMetadata(value="localFunctionImplicitType.kt")
        public void testLocalFunctionImplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunctionImplicitType.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailable.kt")
        public void testLocalImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailableInImplicitBody.kt")
        public void testLocalImplicitTypeUnavailableInImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localImplicitTypeUnavailableInImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="multiDeclaration.kt")
        public void testMultiDeclaration() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/multiDeclaration.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnType.kt")
        public void testParameterAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnTypeBodyResolve.kt")
        public void testParameterAsImplicitReturnTypeBodyResolve() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnTypeBodyResolve.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnTypePropagation.kt")
        public void testParameterAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberFunctions.kt")
        public void testPropagationBetweenLocalMemberFunctions() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationBetweenLocalMemberFunctions.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberFunctionsImplicitBody.kt")
        public void testPropagationBetweenLocalMemberFunctionsImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationBetweenLocalMemberFunctionsImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunction.kt")
        public void testPropagationToLocalMemberFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationToLocalMemberFunction.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunctionImplicitBody.kt")
        public void testPropagationToLocalMemberFunctionImplicitBody() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationToLocalMemberFunctionImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnType.kt")
        public void testReceiverAsImplicitReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/receiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnTypePropagation.kt")
        public void testReceiverAsImplicitReturnTypePropagation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/receiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotations.kt")
        public void testTypeParameterAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotations.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromFunctionWithInaccessibleAnnotationArgument() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromPropertyWithInaccessibleAnnotationArgument() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ErrorType {
        @Test
        public void testAllFilesPresentInErrorType() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="errorType.kt")
        public void testErrorType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/errorType.kt");
        }

        @Test
        @TestMetadata(value="nestedErrorReturnType.kt")
        public void testNestedErrorReturnType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/nestedErrorReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DestructuringDeclaration {
        @Test
        public void testAllFilesPresentInDestructuringDeclaration() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classLevel.kt")
        public void testClassLevel() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration/classLevel.kt");
        }

        @Test
        @TestMetadata(value="topLevel.kt")
        public void testTopLevel() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration/topLevel.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Delegate {
        @Test
        public void testAllFilesPresentInDelegate() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitType.kt")
        public void testDelegateWithExplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitTypeUnavailable.kt")
        public void testDelegateWithExplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitType.kt")
        public void testDelegateWithImplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitTypeUnavailable.kt")
        public void testDelegateWithImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedName.kt")
        public void testDelegatedFieldNestedName() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedName.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="field.kt")
        public void testField() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/field.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitType.kt")
        public void testPropertyWithExplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitTypeUnavailable.kt")
        public void testPropertyWithExplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitType.kt")
        public void testPropertyWithImplicitType() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitTypeUnavailable.kt")
        public void testPropertyWithImplicitTypeUnavailable() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitTypeUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constructor {
        @Test
        public void testAllFilesPresentInConstructor() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="call.kt")
        public void testCall() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/call.kt");
        }

        @Test
        @TestMetadata(value="callWithConstructor.kt")
        public void testCallWithConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/callWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverExplicitPrimaryConstructor.kt")
        public void testContextReceiverExplicitPrimaryConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverExplicitPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverImplicitPrimaryConstructor.kt")
        public void testContextReceiverImplicitPrimaryConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverImplicitPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverSecondaryConstructor.kt")
        public void testContextReceiverSecondaryConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverSecondaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="parameterWithAnnotations.kt")
        public void testParameterWithAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/parameterWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="parameterWithAnnotationsBodyResolve.kt")
        public void testParameterWithAnnotationsBodyResolve() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/parameterWithAnnotationsBodyResolve.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunction.kt")
        public void testPropagationToLocalMemberFunction() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/propagationToLocalMemberFunction.kt");
        }

        @Test
        @TestMetadata(value="reference.kt")
        public void testReference() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/reference.kt");
        }

        @Test
        @TestMetadata(value="referenceWithConstructor.kt")
        public void testReferenceWithConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/referenceWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructor.kt")
        public void testSecondaryConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/secondaryConstructor.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Class {
        @Test
        public void testAllFilesPresentInClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classAnnotationsInLocalClass.kt")
        public void testClassAnnotationsInLocalClass() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/classAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument.kt")
        public void testNestedClassAsAnnotationArgument() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument2.kt")
        public void testNestedClassAsAnnotationArgument2() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="parameterTypeCollisionAndAnnotations.kt")
        public void testParameterTypeCollisionAndAnnotations() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/parameterTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument.kt")
        public void testQualifiedNestedClassAsAnnotationArgument() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument2.kt")
        public void testQualifiedNestedClassAsAnnotationArgument2() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() {
            OutOfContentRootLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }
    }
}

