/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KaLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.TestModuleStructureFactory;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0086\b\u00f8\u0001\u0000J\u0014\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryCache;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lcom/intellij/openapi/project/Project;)V", "binaryRootToLibraryModule", "", "Ljava/nio/file/Path;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "jdkModule", "libraryModules", "", "getLibraryModules", "()Ljava/util/List;", "registerLibraryModuleIfNeeded", "", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getOrCreateLibraryModule", "binaryRoot", "createLibraryModule", "Lkotlin/Function0;", "getOrCreateJdkModule", "jdkRoots", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleStructureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1869#2,2:352\n382#3,7:354\n1#4:361\n*S KotlinDebug\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryCache\n*L\n317#1:352,2\n328#1:354,7\n*E\n"})
final class LibraryCache {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Path, KaLibraryModule> binaryRootToLibraryModule;
    @Nullable
    private KaLibraryModule jdkModule;

    public LibraryCache(@NotNull TestServices testServices, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.testServices = testServices;
        this.project = project;
        this.binaryRootToLibraryModule = new LinkedHashMap();
    }

    @NotNull
    public final List<KaLibraryModule> getLibraryModules() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.jdkModule), (Iterable)CollectionsKt.distinct((Iterable)this.binaryRootToLibraryModule.values()));
    }

    public final void registerLibraryModuleIfNeeded(@NotNull KaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!(module instanceof KaLibraryModule)) {
            return;
        }
        Iterable $this$forEach$iv = ((KaLibraryModule)module).getBinaryRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path binaryRoot = (Path)element$iv;
            boolean bl = false;
            if (!(!this.binaryRootToLibraryModule.containsKey(binaryRoot))) {
                boolean bl2 = false;
                String string = "Each binary root should be uniquely associated with a single library module.\nBinary root: " + binaryRoot + "\nLibrary module: " + module;
                throw new IllegalStateException(string.toString());
            }
            this.binaryRootToLibraryModule.put(binaryRoot, (KaLibraryModule)module);
        }
    }

    @NotNull
    public final KaLibraryModule getOrCreateLibraryModule(@NotNull Path binaryRoot, @NotNull Function0<? extends KaLibraryModule> createLibraryModule) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)binaryRoot, (String)"binaryRoot");
        Intrinsics.checkNotNullParameter(createLibraryModule, (String)"createLibraryModule");
        boolean $i$f$getOrCreateLibraryModule = false;
        Map $this$getOrPut$iv = this.binaryRootToLibraryModule;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(binaryRoot);
        if (value$iv == null) {
            boolean bl = false;
            KaLibraryModule answer$iv = (KaLibraryModule)createLibraryModule.invoke();
            $this$getOrPut$iv.put(binaryRoot, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KaLibraryModule)object;
    }

    @NotNull
    public final KaLibraryModule getOrCreateJdkModule(@NotNull List<? extends Path> jdkRoots) {
        Intrinsics.checkNotNullParameter(jdkRoots, (String)"jdkRoots");
        if (!(!((Collection)jdkRoots).isEmpty())) {
            boolean $i$a$-require-LibraryCache$getOrCreateJdkModule$22 = false;
            String $i$a$-require-LibraryCache$getOrCreateJdkModule$22 = "At least one JDK root is required.";
            throw new IllegalArgumentException($i$a$-require-LibraryCache$getOrCreateJdkModule$22.toString());
        }
        KaLibraryModule kaLibraryModule = this.jdkModule;
        if (kaLibraryModule != null) {
            KaLibraryModule it = kaLibraryModule;
            boolean bl = false;
            return it;
        }
        GlobalSearchScope jdkScope = TestModuleStructureFactory.INSTANCE.getScopeForLibraryByRoots(this.project, (Collection<? extends Path>)jdkRoots, this.testServices);
        KaLibraryModuleImpl jdkModule = new KaLibraryModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), jdkScope, this.project, (Collection<? extends Path>)jdkRoots, null, true);
        this.jdkModule = jdkModule;
        return jdkModule;
    }
}

