/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.targets;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntryInitializerSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaTypeParameterOwnerSymbol;
import org.jetbrains.kotlin.analysis.test.framework.targets.KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$lambda$9$;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTarget;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTargetResolver;
import org.jetbrains.kotlin.analysis.test.framework.targets.UtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0014J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u001aH\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/targets/KaSymbolTestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "resolvePackageTarget", "", "target", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$PackageTarget;", "resolveClassTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ClassTarget;", "resolveClass", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveScriptTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ScriptTarget;", "resolveTypeAliasTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeAliasTarget;", "resolveCallableTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$CallableTarget;", "resolveEnumEntryInitializerTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$EnumEntryInitializerTarget;", "resolveSamConstructorTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$SamConstructorTarget;", "resolveTypeParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeParameterTarget;", "owner", "resolveValueParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ValueParameterTarget;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKaSymbolTestSymbolTargetResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaSymbolTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KaSymbolTestSymbolTargetResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 TestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver\n*L\n1#1,94:1\n1#2:95\n477#3:96\n63#4,4:97\n63#4,4:101\n*S KotlinDebug\n*F\n+ 1 KaSymbolTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KaSymbolTestSymbolTargetResolver\n*L\n67#1:96\n83#1:97,4\n89#1:101,4\n*E\n"})
public final class KaSymbolTestSymbolTargetResolver
extends TestSymbolTargetResolver<KaSymbol> {
    @NotNull
    private final KaSession session;

    public KaSymbolTestSymbolTargetResolver(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolvePackageTarget(@NotNull TestSymbolTarget.PackageTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolvePackageTarget_u24lambda_u240 = this.session;
        boolean bl = false;
        KaPackageSymbol kaPackageSymbol = $this$resolvePackageTarget_u24lambda_u240.findPackage(target.getPackageFqName());
        if (kaPackageSymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the package `" + target.getPackageFqName() + "`.").toString());
        }
        KaPackageSymbol symbol = kaPackageSymbol;
        return CollectionsKt.listOf((Object)symbol);
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolveClassTarget(@NotNull TestSymbolTarget.ClassTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolveClassTarget_u24lambda_u241 = this.session;
        boolean bl = false;
        KaClassSymbol symbol = this.resolveClass($this$resolveClassTarget_u24lambda_u241, target.getClassId());
        return CollectionsKt.listOf((Object)symbol);
    }

    private final KaClassSymbol resolveClass(KaSession $this$resolveClass, ClassId classId) {
        KaClassSymbol kaClassSymbol = $this$resolveClass.findClass(classId);
        if (kaClassSymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the class `" + classId + "`.").toString());
        }
        return kaClassSymbol;
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolveScriptTarget(@NotNull TestSymbolTarget.ScriptTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolveScriptTarget_u24lambda_u242 = this.session;
        boolean bl = false;
        KtScript ktScript = target.getFile().getScript();
        if (ktScript == null) {
            throw new IllegalStateException(("The file `" + target.getFile().getName() + "` is not a script.").toString());
        }
        KtScript script = ktScript;
        return CollectionsKt.listOf((Object)$this$resolveScriptTarget_u24lambda_u242.getSymbol(script));
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolveTypeAliasTarget(@NotNull TestSymbolTarget.TypeAliasTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolveTypeAliasTarget_u24lambda_u243 = this.session;
        boolean bl = false;
        KaTypeAliasSymbol kaTypeAliasSymbol = $this$resolveTypeAliasTarget_u24lambda_u243.findTypeAlias(target.getClassId());
        if (kaTypeAliasSymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the type alias `" + target.getClassId() + "`.").toString());
        }
        KaTypeAliasSymbol symbol = kaTypeAliasSymbol;
        return CollectionsKt.listOf((Object)symbol);
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolveCallableTarget(@NotNull TestSymbolTarget.CallableTarget target) {
        List<KaCallableSymbol> symbols;
        List<KaCallableSymbol> list;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolveCallableTarget_u24lambda_u244 = this.session;
        boolean bl = false;
        CallableId callableId = target.getCallableId();
        ClassId classId = callableId.getClassId();
        if (classId == null) {
            list = SequencesKt.toList((Sequence)$this$resolveCallableTarget_u24lambda_u244.findTopLevelCallables(callableId.getPackageName(), callableId.getCallableName()));
        } else {
            KaClassSymbol classSymbol = this.resolveClass($this$resolveCallableTarget_u24lambda_u244, classId);
            list = symbols = UtilsKt.findMatchingCallableSymbols($this$resolveCallableTarget_u24lambda_u244, callableId, classSymbol);
        }
        if (symbols.isEmpty()) {
            throw new IllegalStateException(("Cannot find a symbol for the callable `" + callableId + "`.").toString());
        }
        return symbols;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<KaSymbol> resolveEnumEntryInitializerTarget(@NotNull TestSymbolTarget.EnumEntryInitializerTarget target) {
        Object v3;
        CallableId enumEntryId;
        block8: {
            void $this$filterIsInstance$iv;
            ClassId classId;
            KaSession $this$resolveEnumEntryInitializerTarget_u24lambda_u249;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                    $this$resolveEnumEntryInitializerTarget_u24lambda_u249 = this.session;
                    boolean bl = false;
                    enumEntryId = target.getEnumEntryId();
                    classId = enumEntryId.getClassId();
                    if (classId == null) break block9;
                    ClassId it = classId;
                    boolean bl2 = false;
                    KaClassSymbol kaClassSymbol = $this$resolveEnumEntryInitializerTarget_u24lambda_u249.findClass(it);
                    classId = kaClassSymbol;
                    if (kaClassSymbol != null) break block10;
                }
                throw new IllegalStateException(("Cannot find a symbol for the enum class `" + enumEntryId.getClassId() + "`.").toString());
            }
            ClassId classSymbol = classId;
            if (!(classSymbol instanceof KaNamedClassSymbol)) {
                boolean $i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$32 = false;
                String $i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$32 = "" + '`' + enumEntryId.getClassId() + "` must be a named class.";
                throw new IllegalArgumentException($i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$32.toString());
            }
            if (!(classSymbol.getClassKind() == KaClassKind.ENUM_CLASS)) {
                boolean $i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$42 = false;
                String $i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$42 = "" + '`' + enumEntryId.getClassId() + "` must be an enum class.";
                throw new IllegalArgumentException($i$a$-require-KaSymbolTestSymbolTargetResolver$resolveEnumEntryInitializerTarget$1$42.toString());
            }
            Sequence sequence = new Sequence[]{enumEntryId.getCallableName()};
            sequence = $this$resolveEnumEntryInitializerTarget_u24lambda_u249.getStaticDeclaredMemberScope((KaDeclarationContainerSymbol)classSymbol).callables((Name[])sequence);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)resolveEnumEntryInitializerTarget$lambda$9$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence sequence3 = sequence2;
            for (Object e : sequence3) {
                KaEnumEntrySymbol it = (KaEnumEntrySymbol)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)enumEntryId.getCallableName())) continue;
                v3 = e;
                break block8;
            }
            v3 = null;
        }
        KaEnumEntrySymbol kaEnumEntrySymbol = v3;
        if (kaEnumEntrySymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the enum entry `" + enumEntryId + "`.").toString());
        }
        KaEnumEntrySymbol enumEntrySymbol = kaEnumEntrySymbol;
        KaEnumEntryInitializerSymbol kaEnumEntryInitializerSymbol = enumEntrySymbol.getEnumEntryInitializer();
        if (kaEnumEntryInitializerSymbol == null) {
            throw new IllegalStateException(("" + '`' + enumEntryId.getCallableName() + "` must have an initializer.").toString());
        }
        KaEnumEntryInitializerSymbol initializerSymbol = kaEnumEntryInitializerSymbol;
        return CollectionsKt.listOf((Object)initializerSymbol);
    }

    @Override
    @NotNull
    protected List<KaSymbol> resolveSamConstructorTarget(@NotNull TestSymbolTarget.SamConstructorTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KaSession $this$resolveSamConstructorTarget_u24lambda_u2410 = this.session;
        boolean bl = false;
        KaClassLikeSymbol kaClassLikeSymbol = $this$resolveSamConstructorTarget_u24lambda_u2410.findClassLike(target.getClassId());
        if (kaClassLikeSymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the class `" + target.getClassId() + "`.").toString());
        }
        KaClassLikeSymbol symbol = kaClassLikeSymbol;
        KaSamConstructorSymbol kaSamConstructorSymbol = $this$resolveSamConstructorTarget_u24lambda_u2410.getSamConstructor(symbol);
        if (kaSamConstructorSymbol == null) {
            throw new IllegalStateException(("Cannot find a symbol for the SAM constructor of `" + target.getClassId() + "`.").toString());
        }
        KaSamConstructorSymbol samConstructor = kaSamConstructorSymbol;
        return CollectionsKt.listOf((Object)samConstructor);
    }

    @Override
    @Nullable
    protected KaSymbol resolveTypeParameterTarget(@NotNull TestSymbolTarget.TypeParameterTarget target, @NotNull KaSymbol owner) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            KaSession $this$resolveTypeParameterTarget_u24lambda_u2412 = this.session;
            boolean bl = false;
            TestSymbolTargetResolver this_$iv = this;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner instanceof KaTypeParameterOwnerSymbol)) {
                boolean bl2 = false;
                String string = "Expected a `" + Reflection.getOrCreateKotlinClass(KaTypeParameterOwnerSymbol.class).getSimpleName() + "` owner for `" + (TestSymbolTarget)target + "`, but found: " + owner + '.';
                throw new IllegalArgumentException(string.toString());
            }
            Iterable iterable = ((KaTypeParameterOwnerSymbol)owner).getTypeParameters();
            for (Object t : iterable) {
                KaTypeParameterSymbol it = (KaTypeParameterSymbol)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return (KaSymbol)((KaTypeParameterSymbol)v0);
    }

    @Override
    @Nullable
    protected KaSymbol resolveValueParameterTarget(@NotNull TestSymbolTarget.ValueParameterTarget target, @NotNull KaSymbol owner) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            KaSession $this$resolveValueParameterTarget_u24lambda_u2414 = this.session;
            boolean bl = false;
            TestSymbolTargetResolver this_$iv = this;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner instanceof KaFunctionSymbol)) {
                boolean bl2 = false;
                String string = "Expected a `" + Reflection.getOrCreateKotlinClass(KaFunctionSymbol.class).getSimpleName() + "` owner for `" + (TestSymbolTarget)target + "`, but found: " + owner + '.';
                throw new IllegalArgumentException(string.toString());
            }
            Iterable iterable = ((KaFunctionSymbol)owner).getValueParameters();
            for (Object t : iterable) {
                KaValueParameterSymbol it = (KaValueParameterSymbol)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return (KaSymbol)((KaValueParameterSymbol)v0);
    }
}

