/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.test.framework.AnalysisApiTestDirectives;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KaLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtModuleWithModifiableDependencies;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleFactoryKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleStructure;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.LibraryCache;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J4\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012j\u0002`\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&2\u0006\u0010\b\u001a\u00020\tJ$\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/TestModuleStructureFactory;", "", "<init>", "()V", "createProjectStructureByTestStructure", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "createModules", "", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "addDependencies", "", "modulesByName", "", "", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/ModulesByName;", "libraryCache", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryCache;", "addModuleDependencies", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "ktModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtModuleWithModifiableDependencies;", "addLibraryDependencies", "createLibraryModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KaLibraryModuleImpl;", "libraryFile", "Ljava/nio/file/Path;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getScopeForLibraryByRoots", "Lcom/intellij/psi/search/GlobalSearchScope;", "roots", "", "createSourcePsiFiles", "Lcom/intellij/psi/PsiFile;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleStructureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/TestModuleStructureFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryCache\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,318:1\n1208#2,2:319\n1236#2,4:321\n1374#2:326\n1460#2,5:327\n1869#2,2:332\n1617#2,9:334\n1869#2:343\n1870#2:345\n1626#2:346\n3303#2,10:347\n1563#2:373\n1634#2,3:374\n1#3:325\n1#3:344\n295#4:357\n295#4:365\n384#5,7:358\n384#5,7:366\n*S KotlinDebug\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/TestModuleStructureFactory\n*L\n50#1:319,2\n50#1:321,4\n84#1:326\n84#1:327,5\n123#1:332,2\n144#1:334,9\n144#1:343\n144#1:345\n144#1:346\n152#1:347,10\n223#1:373\n223#1:374,3\n144#1:344\n171#1:357\n188#1:365\n171#1:358,7\n188#1:366,7\n*E\n"})
public final class TestModuleStructureFactory {
    @NotNull
    public static final TestModuleStructureFactory INSTANCE = new TestModuleStructureFactory();

    private TestModuleStructureFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KtTestModuleStructure createProjectStructureByTestStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<KtTestModule> modules = this.createModules(moduleStructure, testServices, project);
        Iterable $this$associateBy$iv = modules;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtTestModule ktTestModule = (KtTestModule)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTestModule().getName(), element$iv$iv);
        }
        Map modulesByName = destination$iv$iv;
        LibraryCache libraryCache = new LibraryCache(testServices, project);
        for (KtTestModule ktTestModule : modules) {
            libraryCache.registerLibraryModuleIfNeeded(ktTestModule.getKtModule());
            this.addDependencies(ktTestModule, testServices, modulesByName, libraryCache);
        }
        return new KtTestModuleStructure(moduleStructure, modules, (Iterable<? extends KaLibraryModule>)libraryCache.getLibraryModules());
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtTestModule> createModules(TestModuleStructure moduleStructure, TestServices testServices, Project project) {
        int moduleCount = moduleStructure.getModules().size();
        HashMap existingModules = new HashMap(moduleCount);
        ArrayList<KtTestModule> result = new ArrayList<KtTestModule>(moduleCount);
        for (TestModule testModule : moduleStructure.getModules()) {
            void $this$flatMapTo$iv$iv;
            KtTestModule ktTestModule;
            KtTestModule ktTestModule2;
            String contextModuleName = DirectiveKt.singleOrZeroValue((RegisteredDirectives)testModule.getDirectives(), (StringDirective)AnalysisApiTestDirectives.INSTANCE.getCONTEXT_MODULE());
            if (contextModuleName != null) {
                String p0;
                boolean bl = false;
                ktTestModule2 = (KtTestModule)MapsKt.getValue((Map)existingModules, (Object)p0);
            } else {
                ktTestModule2 = null;
            }
            KtTestModule contextModule = ktTestModule2;
            String analysisContextModuleName = DirectiveKt.singleOrZeroValue((RegisteredDirectives)testModule.getDirectives(), (StringDirective)AnalysisApiTestDirectives.INSTANCE.getANALYSIS_CONTEXT_MODULE());
            if (analysisContextModuleName != null) {
                String p0;
                boolean bl = false;
                ktTestModule = (KtTestModule)MapsKt.getValue((Map)existingModules, (Object)p0);
            } else {
                ktTestModule = null;
            }
            KtTestModule analysisContextModule = ktTestModule;
            Iterable $this$flatMap$iv = testModule.getRegularDependencies();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KaLibraryModule libraryModule;
                DependencyDescription dependency = (DependencyDescription)element$iv$iv;
                boolean bl = false;
                KaModule kaModule = ((KtTestModule)MapsKt.getValue((Map)existingModules, (Object)dependency.getDependencyModule().getName())).getKtModule();
                KaLibraryModule kaLibraryModule = libraryModule = kaModule instanceof KaLibraryModule ? (KaLibraryModule)kaModule : null;
                Collection collection = kaLibraryModule != null ? kaLibraryModule.getBinaryRoots() : null;
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List dependencyBinaryRoots = (List)destination$iv$iv;
            KtTestModuleFactory ktTestModuleFactory = KtTestModuleFactoryKt.getKtModuleFactoryForTestModule(testServices, testModule);
            KtTestModule ktTestModule3 = analysisContextModule;
            if (ktTestModule3 == null) {
                ktTestModule3 = contextModule;
            }
            KtTestModule ktTestModule4 = ktTestModuleFactory.createModule(testModule, ktTestModule3, dependencyBinaryRoots, testServices, project);
            ((Map)existingModules).put(testModule.getName(), ktTestModule4);
            result.add(ktTestModule4);
        }
        return result;
    }

    private final void addDependencies(KtTestModule $this$addDependencies, TestServices testServices, Map<String, KtTestModule> modulesByName, LibraryCache libraryCache) {
        KaModule kaModule = $this$addDependencies.getKtModule();
        if (!(kaModule instanceof KaNotUnderContentRootModule || kaModule instanceof KaBuiltinsModule || kaModule instanceof KaDanglingFileModule)) {
            if (kaModule instanceof KtModuleWithModifiableDependencies) {
                this.addModuleDependencies($this$addDependencies.getTestModule(), modulesByName, (KtModuleWithModifiableDependencies)$this$addDependencies.getKtModule());
                this.addLibraryDependencies($this$addDependencies.getTestModule(), testServices, (KtModuleWithModifiableDependencies)$this$addDependencies.getKtModule(), libraryCache);
            } else {
                throw new IllegalStateException(("Unexpected module type: " + $this$addDependencies.getKtModule().getClass().getName()).toString());
            }
        }
    }

    private final void addModuleDependencies(TestModule testModule, Map<String, KtTestModule> modulesByName, KtModuleWithModifiableDependencies ktModule) {
        Iterable $this$forEach$iv = testModule.getAllDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv;
            boolean bl = false;
            KaModule dependencyKtModule = ((KtTestModule)MapsKt.getValue(modulesByName, (Object)dependency.getDependencyModule().getName())).getKtModule();
            switch (WhenMappings.$EnumSwitchMapping$0[dependency.getRelation().ordinal()]) {
                case 1: {
                    boolean bl2 = ktModule.getDirectRegularDependencies().add(dependencyKtModule);
                    break;
                }
                case 2: {
                    boolean bl2 = ktModule.getDirectFriendDependencies().add(dependencyKtModule);
                    break;
                }
                case 3: {
                    boolean bl2 = ktModule.getDirectDependsOnDependencies().add(dependencyKtModule);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addLibraryDependencies(TestModule testModule, TestServices testServices, KtModuleWithModifiableDependencies ktModule, LibraryCache libraryCache) {
        List list;
        LibraryCache targetPlatform;
        Pair $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Project project = ktModule.getProject();
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)testServices).getCompilerConfiguration(testModule);
        Object object = compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS, (Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        boolean $i$f$mapNotNull = false;
        void var10_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ContentRoot it = (ContentRoot)element$iv$iv;
            boolean bl2 = false;
            Object object2 = it instanceof JvmClasspathRoot ? (JvmClasspathRoot)it : null;
            if ((object2 != null && (object2 = object2.getFile()) != null ? ((File)object2).toPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classpathRoots = (List)destination$iv$iv;
        if (!((Collection)classpathRoots).isEmpty()) {
            Object it;
            TestJdkKind jdkKind = JvmEnvironmentConfigurator.Companion.extractJdkKind(testModule.getDirectives());
            Comparable<File> comparable = JvmEnvironmentConfigurator.Companion.getJdkHome(jdkKind);
            if (comparable == null || (comparable = comparable.toPath()) == null) {
                File file = JvmEnvironmentConfigurator.Companion.getJdkClasspathRoot(jdkKind);
                comparable = file != null ? file.toPath() : null;
                if (comparable == null) {
                    comparable = Paths.get(System.getProperty("java.home"), new String[0]);
                }
            }
            Comparable<File> jdkHome = comparable;
            Iterable $this$partition$iv = classpathRoots;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (Path)element$iv;
                boolean bl = false;
                boolean bl4 = jdkHome != null && it.startsWith((Path)jdkHome) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            $this$mapNotNullTo$iv$iv = new Pair(first$iv, second$iv);
            List jdkRoots = (List)$this$mapNotNullTo$iv$iv.component1();
            List libraryRoots = (List)$this$mapNotNullTo$iv$iv.component2();
            targetPlatform = TargetPlatformProviderKt.targetPlatform((TestModule)testModule, (TestServices)testServices);
            if (JvmPlatformKt.isJvm((TargetPlatform)targetPlatform) && !((Collection)jdkRoots).isEmpty()) {
                ktModule.getDirectRegularDependencies().add((KaModule)libraryCache.getOrCreateJdkModule(jdkRoots));
            }
            for (Path libraryRoot : libraryRoots) {
                Object object3;
                it = PathsKt.getExtension((Path)libraryRoot);
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)"jar") || Intrinsics.areEqual((Object)it, (Object)"klib"))) {
                    boolean $i$a$-check-TestModuleStructureFactory$addLibraryDependencies$42 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown library format: ");
                    Path path = libraryRoot.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
                    String $i$a$-check-TestModuleStructureFactory$addLibraryDependencies$42 = stringBuilder.append(path).toString();
                    throw new IllegalStateException($i$a$-check-TestModuleStructureFactory$addLibraryDependencies$42.toString());
                }
                LibraryCache platform = Intrinsics.areEqual((Object)CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)PathsKt.getExtension((Path)libraryRoot)), (Object)"jar") ? JvmPlatforms.INSTANCE.getDefaultJvmPlatform() : targetPlatform;
                LibraryCache this_$iv = libraryCache;
                boolean $i$f$getOrCreateLibraryModule = false;
                Map $this$getOrPut$iv$iv = LibraryCache.access$getBinaryRootToLibraryModule$p(this_$iv);
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(libraryRoot);
                if (value$iv$iv == null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    KaLibraryModule answer$iv$iv = INSTANCE.createLibraryModule(project, libraryRoot, (TargetPlatform)platform, testServices);
                    $this$getOrPut$iv$iv.put(libraryRoot, answer$iv$iv);
                    object3 = answer$iv$iv;
                } else {
                    object3 = value$iv$iv;
                }
                KaLibraryModule libraryModule = (KaLibraryModule)object3;
                if (ktModule.getDirectRegularDependencies().contains(libraryModule)) continue;
                ktModule.getDirectRegularDependencies().add((KaModule)libraryModule);
            }
        }
        if ((list = (List)compilerConfiguration.get(JSConfigurationKeys.LIBRARIES)) == null) {
            list = CollectionsKt.emptyList();
        }
        List jsLibraryRootPaths = list;
        for (String libraryRootPath : jsLibraryRootPaths) {
            Object object4;
            void this_$iv;
            Path libraryRoot = Paths.get(libraryRootPath, new String[0]);
            Intrinsics.checkNotNull((Object)libraryRoot);
            if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)libraryRoot), (Object)"klib")) {
                throw new IllegalStateException("Check failed.");
            }
            targetPlatform = libraryCache;
            Path binaryRoot$iv = libraryRoot;
            boolean $i$f$getOrCreateLibraryModule = false;
            Map $this$getOrPut$iv$iv = LibraryCache.access$getBinaryRootToLibraryModule$p((LibraryCache)this_$iv);
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(binaryRoot$iv);
            if (value$iv$iv == null) {
                boolean bl = false;
                boolean bl7 = false;
                KaLibraryModule answer$iv$iv = INSTANCE.createLibraryModule(project, libraryRoot, JsPlatforms.INSTANCE.getDefaultJsPlatform(), testServices);
                $this$getOrPut$iv$iv.put(binaryRoot$iv, answer$iv$iv);
                object4 = answer$iv$iv;
            } else {
                object4 = value$iv$iv;
            }
            KaLibraryModule libraryModule = (KaLibraryModule)object4;
            ktModule.getDirectRegularDependencies().add((KaModule)libraryModule);
        }
    }

    private final KaLibraryModuleImpl createLibraryModule(Project project, Path libraryFile, TargetPlatform platform, TestServices testServices) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(libraryFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-check-TestModuleStructureFactory$createLibraryModule$22 = false;
            String $i$a$-check-TestModuleStructureFactory$createLibraryModule$22 = "Library " + libraryFile + " does not exist";
            throw new IllegalStateException($i$a$-check-TestModuleStructureFactory$createLibraryModule$22.toString());
        }
        String libraryName = PathsKt.getNameWithoutExtension((Path)libraryFile);
        GlobalSearchScope libraryScope = this.getScopeForLibraryByRoots(project, CollectionsKt.listOf((Object)libraryFile), testServices);
        return new KaLibraryModuleImpl(libraryName, platform, libraryScope, project, CollectionsKt.listOf((Object)libraryFile), null, false);
    }

    @NotNull
    public final GlobalSearchScope getScopeForLibraryByRoots(@NotNull Project project, @NotNull Collection<? extends Path> roots, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots(roots, (Collection)CollectionsKt.emptyList(), (CoreApplicationEnvironment)AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment(), project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> createSourcePsiFiles(@NotNull TestModule testModule, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = testModule.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile psiFile;
            void testFile;
            TestFile testFile2 = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (SourceFileProviderKt.isKtFile((TestFile)testFile)) {
                String fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile((TestFile)testFile);
                KtFile ktFile = KtTestUtil.createFile((String)testFile.getName(), (String)fileText, (Project)project);
                Intrinsics.checkNotNull((Object)ktFile);
                psiFile = (PsiFile)ktFile;
            } else if (SourceFileProviderKt.isJavaFile((TestFile)testFile) || SourceFileProviderKt.isExternalAnnotation((TestFile)testFile)) {
                VirtualFile virtualFile;
                File filePath = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getOrCreateRealFileForSourceFile((TestFile)testFile);
                if (AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment().getLocalFileSystem().findFileByIoFile(filePath) == null) {
                    throw new IllegalStateException(("Virtual file not found for " + filePath).toString());
                }
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    throw new IllegalStateException(("PsiFile file not found for " + filePath).toString());
                }
            } else {
                throw new IllegalStateException(("Unexpected file " + testFile.getName()).toString());
            }
            collection.add(psiFile);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyRelation.values().length];
            try {
                nArray[DependencyRelation.RegularDependency.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.FriendDependency.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.DependsOnDependency.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

