/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractSourceLazyDeclarationResolveForTypeAnnotationsTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations")
@TestDataPath(value="$PROJECT_ROOT")
public class SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated
extends AbstractSourceLazyDeclarationResolveForTypeAnnotationsTest {
    @Test
    public void testAllFilesPresentInLazyResolveTypeAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAlias {
        @Test
        public void testAllFilesPresentInTypeAlias() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="insideFunction.kt")
        public void testInsideFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunction.kt");
        }

        @Test
        @TestMetadata(value="insideFunctionComplex.kt")
        public void testInsideFunctionComplex() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunctionComplex.kt");
        }

        @Test
        @TestMetadata(value="nestedAliasWithNestedAnnotationInLocalClass.kt")
        public void testNestedAliasWithNestedAnnotationInLocalClass() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/nestedAliasWithNestedAnnotationInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/simple.kt");
        }

        @Test
        @TestMetadata(value="withMissedArguments.kt")
        public void testWithMissedArguments() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/withMissedArguments.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperty {
        @Test
        public void testAllFilesPresentInSyntheticProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="getterAndSetterWithExplicitReturnType.kt")
        public void testGetterAndSetterWithExplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterAndSetterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithExplicitReturnType.kt")
        public void testGetterWithExplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithImplicitReturnType.kt")
        public void testGetterWithImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithImplicitReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SubstitutionOverride {
        @Test
        public void testAllFilesPresentInSubstitutionOverride() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructor.kt")
        public void testConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructor.kt");
        }

        @Test
        @TestMetadata(value="constructorCallSite.kt")
        public void testConstructorCallSite() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructorCallSite.kt");
        }

        @Test
        @TestMetadata(value="function.kt")
        public void testFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/function.kt");
        }

        @Test
        @TestMetadata(value="functionUnavailable.kt")
        public void testFunctionUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/functionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitFunction.kt")
        public void testImplicitFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunction.kt");
        }

        @Test
        @TestMetadata(value="implicitFunctionUnavailable.kt")
        public void testImplicitFunctionUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunctionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitProperty.kt")
        public void testImplicitProperty() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitProperty.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyAndReceiver.kt")
        public void testImplicitPropertyAndReceiver() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyAndReceiver.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyUnavailable.kt")
        public void testImplicitPropertyUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyUnavailable.kt");
        }

        @Test
        @TestMetadata(value="property.kt")
        public void testProperty() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/property.kt");
        }

        @Test
        @TestMetadata(value="propertyUnavailable.kt")
        public void testPropertyUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/propertyUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Property {
        @Test
        public void testAllFilesPresentInProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnType.kt")
        public void testContextReceiverAsImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnTypePropagation.kt")
        public void testContextReceiverAsImplicitReturnTypePropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/contextReceiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromConstructor.kt")
        public void testGeneratedPropertyFromConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/generatedPropertyFromConstructor.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectAccessors.kt")
        public void testImplicitTypeFromIncorrectAccessors() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectAccessors.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectAccessorsPropagation.kt")
        public void testImplicitTypeFromIncorrectAccessorsPropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectAccessorsPropagation.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectSetter.kt")
        public void testImplicitTypeFromIncorrectSetter() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectSetter.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeFromIncorrectSetterPropagation.kt")
        public void testImplicitTypeFromIncorrectSetterPropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeFromIncorrectSetterPropagation.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeInLocalClass.kt")
        public void testImplicitTypeInLocalClass() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedType.kt")
        public void testLocalDelegatedPropertyWithPropagatedType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalDelegatedPropertyWithPropagatedTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailable.kt")
        public void testLocalImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailableInImplicitBody.kt")
        public void testLocalImplicitTypeUnavailableInImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localImplicitTypeUnavailableInImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithExplicitType.kt")
        public void testLocalPropertyWithExplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedType.kt")
        public void testLocalPropertyWithPropagatedType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalPropertyWithPropagatedTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberProperties.kt")
        public void testPropagationBetweenLocalMemberProperties() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationBetweenLocalMemberProperties.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberPropertiesImplicitBody.kt")
        public void testPropagationBetweenLocalMemberPropertiesImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationBetweenLocalMemberPropertiesImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberProperty.kt")
        public void testPropagationToLocalMemberProperty() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationToLocalMemberProperty.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberPropertyImplicitBody.kt")
        public void testPropagationToLocalMemberPropertyImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propagationToLocalMemberPropertyImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propertyTypeCollisionAndAnnotations.kt")
        public void testPropertyTypeCollisionAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propertyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnType.kt")
        public void testReceiverAsImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/receiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnTypePropagation.kt")
        public void testReceiverAsImplicitReturnTypePropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/receiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/typeParameterAnnotationsInLocalClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Initializer {
        @Test
        public void testAllFilesPresentInInitializer() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classInitializer.kt")
        public void testClassInitializer() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/initializer/classInitializer.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Function {
        @Test
        public void testAllFilesPresentInFunction() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="component1TypeCollisionAndAnnotations.kt")
        public void testComponent1TypeCollisionAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/component1TypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnType.kt")
        public void testContextReceiverAsImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverAsImplicitReturnTypePropagation.kt")
        public void testContextReceiverAsImplicitReturnTypePropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/contextReceiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="copyTypeCollisionAndAnnotations.kt")
        public void testCopyTypeCollisionAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/copyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotationsAsConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="explicitParameterName.kt")
        public void testExplicitParameterName() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/explicitParameterName.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedComponentN.kt")
        public void testGeneratedComponentN() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedComponentN.kt");
        }

        @Test
        @TestMetadata(value="generatedCopy.kt")
        public void testGeneratedCopy() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedCopy.kt");
        }

        @Test
        @TestMetadata(value="implicitParameterName.kt")
        public void testImplicitParameterName() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitParameterName.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunction.kt");
        }

        @Test
        @TestMetadata(value="localFunctionImplicitType.kt")
        public void testLocalFunctionImplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunctionImplicitType.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailable.kt")
        public void testLocalImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localImplicitTypeUnavailableInImplicitBody.kt")
        public void testLocalImplicitTypeUnavailableInImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localImplicitTypeUnavailableInImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="multiDeclaration.kt")
        public void testMultiDeclaration() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/multiDeclaration.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnType.kt")
        public void testParameterAsImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnTypeBodyResolve.kt")
        public void testParameterAsImplicitReturnTypeBodyResolve() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnTypeBodyResolve.kt");
        }

        @Test
        @TestMetadata(value="parameterAsImplicitReturnTypePropagation.kt")
        public void testParameterAsImplicitReturnTypePropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/parameterAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberFunctions.kt")
        public void testPropagationBetweenLocalMemberFunctions() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationBetweenLocalMemberFunctions.kt");
        }

        @Test
        @TestMetadata(value="propagationBetweenLocalMemberFunctionsImplicitBody.kt")
        public void testPropagationBetweenLocalMemberFunctionsImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationBetweenLocalMemberFunctionsImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunction.kt")
        public void testPropagationToLocalMemberFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationToLocalMemberFunction.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunctionImplicitBody.kt")
        public void testPropagationToLocalMemberFunctionImplicitBody() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/propagationToLocalMemberFunctionImplicitBody.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnType.kt")
        public void testReceiverAsImplicitReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/receiverAsImplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="receiverAsImplicitReturnTypePropagation.kt")
        public void testReceiverAsImplicitReturnTypePropagation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/receiverAsImplicitReturnTypePropagation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotations.kt")
        public void testTypeParameterAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotations.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromFunctionWithInaccessibleAnnotationArgument() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromPropertyWithInaccessibleAnnotationArgument() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ErrorType {
        @Test
        public void testAllFilesPresentInErrorType() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="errorType.kt")
        public void testErrorType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/errorType.kt");
        }

        @Test
        @TestMetadata(value="nestedErrorReturnType.kt")
        public void testNestedErrorReturnType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/nestedErrorReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DestructuringDeclaration {
        @Test
        public void testAllFilesPresentInDestructuringDeclaration() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classLevel.kt")
        public void testClassLevel() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration/classLevel.kt");
        }

        @Test
        @TestMetadata(value="topLevel.kt")
        public void testTopLevel() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/destructuringDeclaration/topLevel.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Delegate {
        @Test
        public void testAllFilesPresentInDelegate() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitType.kt")
        public void testDelegateWithExplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitTypeUnavailable.kt")
        public void testDelegateWithExplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitType.kt")
        public void testDelegateWithImplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitTypeUnavailable.kt")
        public void testDelegateWithImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedName.kt")
        public void testDelegatedFieldNestedName() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedName.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="field.kt")
        public void testField() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/field.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitType.kt")
        public void testPropertyWithExplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitTypeUnavailable.kt")
        public void testPropertyWithExplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitType.kt")
        public void testPropertyWithImplicitType() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitTypeUnavailable.kt")
        public void testPropertyWithImplicitTypeUnavailable() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitTypeUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constructor {
        @Test
        public void testAllFilesPresentInConstructor() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="call.kt")
        public void testCall() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/call.kt");
        }

        @Test
        @TestMetadata(value="callWithConstructor.kt")
        public void testCallWithConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/callWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverExplicitPrimaryConstructor.kt")
        public void testContextReceiverExplicitPrimaryConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverExplicitPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverImplicitPrimaryConstructor.kt")
        public void testContextReceiverImplicitPrimaryConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverImplicitPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverSecondaryConstructor.kt")
        public void testContextReceiverSecondaryConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/contextReceiverSecondaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="parameterWithAnnotations.kt")
        public void testParameterWithAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/parameterWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="parameterWithAnnotationsBodyResolve.kt")
        public void testParameterWithAnnotationsBodyResolve() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/parameterWithAnnotationsBodyResolve.kt");
        }

        @Test
        @TestMetadata(value="propagationToLocalMemberFunction.kt")
        public void testPropagationToLocalMemberFunction() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/propagationToLocalMemberFunction.kt");
        }

        @Test
        @TestMetadata(value="reference.kt")
        public void testReference() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/reference.kt");
        }

        @Test
        @TestMetadata(value="referenceWithConstructor.kt")
        public void testReferenceWithConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/referenceWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructor.kt")
        public void testSecondaryConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/secondaryConstructor.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Class {
        @Test
        public void testAllFilesPresentInClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classAnnotationsInLocalClass.kt")
        public void testClassAnnotationsInLocalClass() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/classAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument.kt")
        public void testNestedClassAsAnnotationArgument() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument2.kt")
        public void testNestedClassAsAnnotationArgument2() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="parameterTypeCollisionAndAnnotations.kt")
        public void testParameterTypeCollisionAndAnnotations() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/parameterTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument.kt")
        public void testQualifiedNestedClassAsAnnotationArgument() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument2.kt")
        public void testQualifiedNestedClassAsAnnotationArgument2() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }
    }
}

