/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtLibraryBinaryTestModuleFactoryBase;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleDecompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleDecompilerKt;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtLibraryBinaryDecompiledTestModuleFactory;", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtLibraryBinaryTestModuleFactoryBase;", "<init>", "()V", "testModuleKind", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/TestModuleKind;", "getTestModuleKind", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/TestModuleKind;", "decompileToPsiFiles", "", "Lcom/intellij/psi/PsiFile;", "binaryRoot", "Ljava/nio/file/Path;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "analysis-test-framework_test"})
public final class KtLibraryBinaryDecompiledTestModuleFactory
extends KtLibraryBinaryTestModuleFactoryBase {
    @NotNull
    public static final KtLibraryBinaryDecompiledTestModuleFactory INSTANCE = new KtLibraryBinaryDecompiledTestModuleFactory();

    private KtLibraryBinaryDecompiledTestModuleFactory() {
    }

    @Override
    @NotNull
    protected TestModuleKind getTestModuleKind() {
        return TestModuleKind.LibraryBinaryDecompiled;
    }

    @Override
    @NotNull
    protected List<PsiFile> decompileToPsiFiles(@NotNull Path binaryRoot, @NotNull TestServices testServices, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)binaryRoot, (String)"binaryRoot");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(binaryRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.endsWith$default((String)((Object)binaryRoot).toString(), (String)".jar", (boolean)false, (int)2, null)) {
            AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment().addJarToClassPath(binaryRoot.toFile());
        }
        TestModuleDecompiler testModuleDecompiler = TestModuleDecompilerKt.getTestModuleDecompiler(testServices);
        VirtualFileSystem virtualFileSystem = AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment().getJarFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem");
        return testModuleDecompiler.getAllPsiFilesFromLibrary(binaryRoot, project, (CoreJarFileSystem)virtualFileSystem);
    }
}

