/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CliTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.JsKlibTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.JvmJarTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.MetadataKlibDirTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/DispatchingTestModuleCompiler;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "<init>", "()V", "compile", "Ljava/nio/file/Path;", "tmpDir", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyBinaryRoots", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compileSources", "files", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "getCompiler", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler;", "analysis-test-framework_test"})
public final class DispatchingTestModuleCompiler
extends TestModuleCompiler {
    @NotNull
    public static final DispatchingTestModuleCompiler INSTANCE = new DispatchingTestModuleCompiler();

    private DispatchingTestModuleCompiler() {
    }

    @Override
    @NotNull
    public Path compile(@NotNull Path tmpDir, @NotNull TestModule module, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return this.getCompiler(module).compile(tmpDir, module, dependencyBinaryRoots, testServices);
    }

    @Override
    @NotNull
    public Path compileSources(@NotNull List<TestFile> files, @NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return this.getCompiler(module).compileSources(module.getFiles(), module, testServices);
    }

    private final CliTestModuleCompiler getCompiler(TestModule module) {
        CliTestModuleCompiler cliTestModuleCompiler;
        if (JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform())) {
            cliTestModuleCompiler = JvmJarTestModuleCompiler.INSTANCE;
        } else if (JsPlatformKt.isJs((TargetPlatform)module.getTargetPlatform())) {
            cliTestModuleCompiler = JsKlibTestModuleCompiler.INSTANCE;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)module.getTargetPlatform())) {
            cliTestModuleCompiler = MetadataKlibDirTestModuleCompiler.INSTANCE;
        } else {
            throw new IllegalStateException(("DispatchingTestModuleCompiler doesn't support the platform: " + module.getTargetPlatform()).toString());
        }
        return cliTestModuleCompiler;
    }
}

