/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010,\u001a\u0004\u0018\u00010-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/LibraryByRoots;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "roots", "", "Ljava/nio/file/Path;", "parentModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "project", "Lcom/intellij/openapi/project/Project;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "directRegularDependencies", "getDirectRegularDependencies", "()Ljava/util/List;", "directDependsOnDependencies", "getDirectDependsOnDependencies", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "directFriendDependencies", "getDirectFriendDependencies", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getBinaryRoots", "", "equals", "", "other", "", "hashCode", "", "librarySources", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtLibrarySourceModule;", "analysis-test-framework_test"})
final class LibraryByRoots
implements KtLibraryModule {
    @NotNull
    private final List<Path> roots;
    @NotNull
    private final KtModule parentModule;
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope contentScope;

    public LibraryByRoots(@NotNull List<? extends Path> roots, @NotNull KtModule parentModule, @NotNull Project project, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)parentModule, (String)"parentModule");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.roots = roots;
        this.parentModule = parentModule;
        this.project = project;
        this.contentScope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection)this.roots, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment());
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public GlobalSearchScope getContentScope() {
        return this.contentScope;
    }

    @NotNull
    public String getLibraryName() {
        return "Test Library " + this.roots;
    }

    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getDirectDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getTransitiveDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.parentModule.getPlatform();
    }

    @NotNull
    public Collection<Path> getBinaryRoots() {
        return this.roots;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.test.framework.project.structure.LibraryByRoots");
        LibraryByRoots cfr_ignored_0 = (LibraryByRoots)other;
        return Intrinsics.areEqual(this.roots, ((LibraryByRoots)other).roots);
    }

    public int hashCode() {
        return ((Object)this.roots).hashCode();
    }

    @Nullable
    public KtLibrarySourceModule getLibrarySources() {
        return null;
    }
}

