/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtStaticProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.test.framework.services.KtTestProjectStructureProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/KtTestProjectStructureProvider;", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtStaticProjectStructureProvider;", "globalLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "builtinsModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtBuiltinsModule;", "projectStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/analysis/project/structure/KtBuiltinsModule;Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;)V", "getGlobalLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getNotUnderContentRootModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtNotUnderContentRootModule;", "project", "Lcom/intellij/openapi/project/Project;", "getModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "element", "Lcom/intellij/psi/PsiElement;", "contextualModule", "allKtModules", "", "getAllKtModules", "()Ljava/util/List;", "allSourceFiles", "Lcom/intellij/psi/PsiFileSystemItem;", "getAllSourceFiles", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtTestProjectStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtTestProjectStructureProvider.kt\norg/jetbrains/kotlin/analysis/test/framework/services/KtTestProjectStructureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n288#2,2:59\n288#2,2:62\n1#3:61\n*S KotlinDebug\n*F\n+ 1 KtTestProjectStructureProvider.kt\norg/jetbrains/kotlin/analysis/test/framework/services/KtTestProjectStructureProvider\n*L\n39#1:59,2\n45#1:62,2\n*E\n"})
public final class KtTestProjectStructureProvider
extends KtStaticProjectStructureProvider {
    @NotNull
    private final LanguageVersionSettings globalLanguageVersionSettings;
    @NotNull
    private final KtBuiltinsModule builtinsModule;
    @NotNull
    private final KtModuleProjectStructure projectStructure;
    @NotNull
    private final List<KtModule> allKtModules;
    @NotNull
    private final List<PsiFileSystemItem> allSourceFiles;

    public KtTestProjectStructureProvider(@NotNull LanguageVersionSettings globalLanguageVersionSettings, @NotNull KtBuiltinsModule builtinsModule, @NotNull KtModuleProjectStructure projectStructure) {
        Intrinsics.checkNotNullParameter((Object)globalLanguageVersionSettings, (String)"globalLanguageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)builtinsModule, (String)"builtinsModule");
        Intrinsics.checkNotNullParameter((Object)projectStructure, (String)"projectStructure");
        this.globalLanguageVersionSettings = globalLanguageVersionSettings;
        this.builtinsModule = builtinsModule;
        this.projectStructure = projectStructure;
        this.allKtModules = this.projectStructure.allKtModules();
        this.allSourceFiles = this.projectStructure.allSourceFiles();
    }

    @NotNull
    public LanguageVersionSettings getGlobalLanguageVersionSettings() {
        return this.globalLanguageVersionSettings;
    }

    @NotNull
    protected KtNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        throw new IllegalStateException("Not-under content root modules most be initialized explicitly in tests".toString());
    }

    @NotNull
    public KtModule getModule(@NotNull PsiElement element, @Nullable KtModule contextualModule) {
        Object v1;
        KtModule ktModule;
        Iterable iterable;
        VirtualFile virtualFile;
        PsiFile containingFile;
        block9: {
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            containingFile = element.getContainingFile();
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile != null) {
                Object v0;
                block8: {
                    if (Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"kotlin_builtins")) {
                        return (KtModule)this.builtinsModule;
                    }
                    iterable = this.projectStructure.getBinaryModules();
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtBinaryModule binaryModule = (KtBinaryModule)element$iv;
                        boolean bl = false;
                        if (!binaryModule.getContentScope().contains(virtualFile)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                ktModule = v0;
                if (ktModule != null) {
                    KtModule it = ktModule;
                    boolean bl = false;
                    return it;
                }
            }
            Intrinsics.checkNotNull((Object)containingFile);
            ktModule = this.computeSpecialModule(containingFile);
            if (ktModule != null) {
                KtModule it = ktModule;
                boolean bl = false;
                return it;
            }
            $this$firstOrNull$iv = this.projectStructure.getMainModules();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtModuleWithFiles module = (KtModuleWithFiles)element$iv;
                boolean bl = false;
                if (!PsiUtilsKt.contains((SearchScope)((SearchScope)module.getKtModule().getContentScope()), (PsiElement)element)) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        ktModule = v1;
        if (ktModule == null || (iterable = ktModule.getKtModule()) == null) {
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Cannot find KtModule; see the attachment for more details.");
            Object object = virtualFile;
            if (object == null || (object = object.getPath()) == null) {
                String string = containingFile.getName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            }
            Iterable iterable2 = this.getAllKtModules();
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            throw kotlinExceptionWithAttachments.withAttachment((String)object, (Object)CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, (Function1)getModule.5.INSTANCE, (int)30, null));
        }
        return iterable;
    }

    @NotNull
    public List<KtModule> getAllKtModules() {
        return this.allKtModules;
    }

    @NotNull
    public List<PsiFileSystemItem> getAllSourceFiles() {
        return this.allSourceFiles;
    }
}

