/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtJdkModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleFactoryKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleWithModifiableDependencies;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ)\u0010\f\u001a\u00020\r*\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fj\u0002`\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u001c\u0010\u0017\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u001c0\u0019j\u0002`\u0018H\u0002\u00a2\u0006\u0002\u0010\u001dJW\u0010\u001e\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fj\u0002`\u000e2\u001c\u0010\u0017\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u001c0\u0019j\u0002`\u0018H\u0002\u00a2\u0006\u0002\u0010 J5\u0010!\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fj\u0002`\u000e2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$Jl\u0010%\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2B\u0010\u0017\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001c0*\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u001c0&H\u0002J(\u0010,\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b042\u0006\u0010\b\u001a\u00020\tJ$\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory;", "", "<init>", "()V", "createProjectStructureByTestStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "getByTestModule", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/ModulesByName;", "", "", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/test/model/TestModule;)Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "addToLibraryCacheIfNeeded", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "libraryCache", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/LibraryCache;", "", "", "Ljava/nio/file/Path;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtBinaryModule;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Ljava/util/Map;)V", "addDependencies", "modulesByName", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/Map;Ljava/util/Map;)V", "addModuleDependencies", "ktModule", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleWithModifiableDependencies;", "(Lorg/jetbrains/kotlin/test/model/TestModule;Ljava/util/Map;Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleWithModifiableDependencies;)V", "addLibraryDependencies", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "paths", "Lkotlin/Function0;", "factory", "createLibraryModule", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtLibraryModuleImpl;", "libraryFile", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getScopeForLibraryByRoots", "Lcom/intellij/psi/search/GlobalSearchScope;", "roots", "", "createSourcePsiFiles", "", "Lcom/intellij/psi/PsiFile;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleStructureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1547#2:213\n1618#2,3:214\n1853#2,2:217\n1601#2,9:219\n1853#2:228\n1854#2:230\n1610#2:231\n3183#2,10:232\n1547#2:243\n1618#2,3:244\n1#3:229\n1#3:242\n*S KotlinDebug\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n*L\n48#1:213\n48#1:214,3\n102#1:217,2\n122#1:219,9\n122#1:228\n122#1:230\n122#1:231\n130#1:232,10\n190#1:243\n190#1:244,3\n122#1:229\n*E\n"})
public final class TestModuleStructureFactory {
    @NotNull
    public static final TestModuleStructureFactory INSTANCE = new TestModuleStructureFactory();

    private TestModuleStructureFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KtModuleProjectStructure createProjectStructureByTestStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = moduleStructure.getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void testModule;
            TestModule testModule2 = (TestModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KtModuleFactoryKt.getKtModuleFactoryForTestModule(testServices, (TestModule)testModule).createModule((TestModule)testModule, testServices, project));
        }
        List moduleEntries = (List)destination$iv$iv;
        Map<String, KtModuleWithFiles> modulesByName = AnalysisApiKtModuleProviderImplKt.associateByName(moduleEntries);
        Map libraryCache = new LinkedHashMap();
        for (TestModule testModule : moduleStructure.getModules()) {
            KtModule ktModule = this.getByTestModule(modulesByName, testModule).getKtModule();
            this.addToLibraryCacheIfNeeded(ktModule, libraryCache);
            this.addDependencies(ktModule, testModule, testServices, modulesByName, libraryCache);
        }
        return new KtModuleProjectStructure(moduleEntries, (Iterable)libraryCache.values());
    }

    private final KtModuleWithFiles getByTestModule(Map<String, KtModuleWithFiles> $this$getByTestModule, TestModule testModule) {
        KtModuleWithFiles ktModuleWithFiles = $this$getByTestModule.get(testModule.getName());
        if (ktModuleWithFiles == null) {
            ktModuleWithFiles = (KtModuleWithFiles)MapsKt.getValue($this$getByTestModule, (Object)((TestFile)CollectionsKt.single((List)testModule.getFiles())).getName());
        }
        return ktModuleWithFiles;
    }

    private final void addToLibraryCacheIfNeeded(KtModule $this$addToLibraryCacheIfNeeded, Map<Set<Path>, KtBinaryModule> libraryCache) {
        if ($this$addToLibraryCacheIfNeeded instanceof KtBinaryModule) {
            libraryCache.put(CollectionsKt.toSet((Iterable)((KtBinaryModule)$this$addToLibraryCacheIfNeeded).getBinaryRoots()), (KtBinaryModule)$this$addToLibraryCacheIfNeeded);
        }
    }

    private final void addDependencies(KtModule $this$addDependencies, TestModule testModule, TestServices testServices, Map<String, KtModuleWithFiles> modulesByName, Map<Set<Path>, KtBinaryModule> libraryCache) {
        KtModule ktModule = $this$addDependencies;
        if (!(ktModule instanceof KtNotUnderContentRootModule)) {
            if (ktModule instanceof KtModuleWithModifiableDependencies) {
                this.addModuleDependencies(testModule, modulesByName, (KtModuleWithModifiableDependencies)$this$addDependencies);
                this.addLibraryDependencies(testModule, testServices, $this$addDependencies.getProject(), (KtModuleWithModifiableDependencies)$this$addDependencies, (Function2<? super Set<? extends Path>, ? super Function0<? extends KtBinaryModule>, ? extends KtBinaryModule>)((Function2)new Function2<Set<? extends Path>, Function0<? extends KtBinaryModule>, KtBinaryModule>(libraryCache){

                    public final KtBinaryModule invoke(Set<? extends Path> p0, Function0<? extends KtBinaryModule> p1) {
                        Object object;
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        Map $this$getOrPut$iv = (Map)this.receiver;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(p0);
                        if (value$iv == null) {
                            Object answer$iv = p1.invoke();
                            $this$getOrPut$iv.put(p0, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        return (KtBinaryModule)object;
                    }

                    public final String getSignature() {
                        return "getOrPut(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;";
                    }

                    public final String getName() {
                        return "getOrPut";
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(MapsKt.class, (String)"analysis-test-framework_test");
                    }
                }));
            } else {
                throw new IllegalStateException(("Unexpected module type: " + $this$addDependencies.getClass().getName()).toString());
            }
        }
    }

    private final void addModuleDependencies(TestModule testModule, Map<String, KtModuleWithFiles> modulesByName, KtModuleWithModifiableDependencies ktModule) {
        Iterable $this$forEach$iv = testModule.getAllDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv;
            boolean bl = false;
            KtModule dependencyKtModule = ((KtModuleWithFiles)MapsKt.getValue(modulesByName, (Object)dependency.getModuleName())).getKtModule();
            switch (WhenMappings.$EnumSwitchMapping$0[dependency.getRelation().ordinal()]) {
                case 1: {
                    boolean bl2 = ktModule.getDirectRegularDependencies().add(dependencyKtModule);
                    break;
                }
                case 2: {
                    boolean bl2 = ktModule.getDirectFriendDependencies().add(dependencyKtModule);
                    break;
                }
                case 3: {
                    boolean bl2 = ktModule.getDirectDependsOnDependencies().add(dependencyKtModule);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addLibraryDependencies(TestModule testModule, TestServices testServices, Project project, KtModuleWithModifiableDependencies ktModule, Function2<? super Set<? extends Path>, ? super Function0<? extends KtBinaryModule>, ? extends KtBinaryModule> libraryCache) {
        List list;
        Pair $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)testServices).getCompilerConfiguration(testModule);
        Object object = compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS, (Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        boolean $i$f$mapNotNull = false;
        void var10_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ContentRoot it = (ContentRoot)element$iv$iv;
            boolean bl2 = false;
            Object object2 = it instanceof JvmClasspathRoot ? (JvmClasspathRoot)it : null;
            if ((object2 != null && (object2 = object2.getFile()) != null ? ((File)object2).toPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classpathRoots = (List)destination$iv$iv;
        if (!((Collection)classpathRoots).isEmpty()) {
            TestJdkKind jdkKind = JvmEnvironmentConfigurator.Companion.extractJdkKind(testModule.getDirectives());
            Comparable<File> comparable = JvmEnvironmentConfigurator.Companion.getJdkHome(jdkKind);
            if (comparable == null || (comparable = comparable.toPath()) == null) {
                File file = JvmEnvironmentConfigurator.Companion.getJdkClasspathRoot(jdkKind);
                comparable = file != null ? file.toPath() : null;
                if (comparable == null) {
                    comparable = Paths.get(System.getProperty("java.home"), new String[0]);
                }
            }
            Comparable<File> jdkHome = comparable;
            Iterable $this$partition$iv = classpathRoots;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (jdkHome != null && it.startsWith((Path)jdkHome)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$mapNotNullTo$iv$iv = new Pair(first$iv, second$iv);
            List jdkRoots = (List)$this$mapNotNullTo$iv$iv.component1();
            List libraryRoots = (List)$this$mapNotNullTo$iv$iv.component2();
            if (JvmPlatformKt.isJvm((TargetPlatform)testModule.getTargetPlatform()) && !((Collection)jdkRoots).isEmpty()) {
                KtBinaryModule jdkModule2 = (KtBinaryModule)libraryCache.invoke((Object)CollectionsKt.toSet((Iterable)jdkRoots), (Object)new Function0<KtBinaryModule>((List<? extends Path>)jdkRoots, testServices, project){
                    final /* synthetic */ List<Path> $jdkRoots;
                    final /* synthetic */ TestServices $testServices;
                    final /* synthetic */ Project $project;
                    {
                        this.$jdkRoots = $jdkRoots;
                        this.$testServices = $testServices;
                        this.$project = $project;
                        super(0);
                    }

                    public final KtBinaryModule invoke() {
                        GlobalSearchScope jdkScope = TestModuleStructureFactory.INSTANCE.getScopeForLibraryByRoots((Collection<? extends Path>)this.$jdkRoots, this.$testServices);
                        return (KtBinaryModule)new KtJdkModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), jdkScope, this.$project, (Collection<? extends Path>)this.$jdkRoots);
                    }
                });
                ktModule.getDirectRegularDependencies().add((KtModule)jdkModule2);
            }
            for (Path libraryRoot : libraryRoots) {
                if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)libraryRoot), (Object)"jar")) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                KtBinaryModule libraryModule2 = (KtBinaryModule)libraryCache.invoke((Object)SetsKt.setOf((Object)libraryRoot), (Object)new Function0<KtBinaryModule>(project, libraryRoot, testServices){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Path $libraryRoot;
                    final /* synthetic */ TestServices $testServices;
                    {
                        this.$project = $project;
                        this.$libraryRoot = $libraryRoot;
                        this.$testServices = $testServices;
                        super(0);
                    }

                    public final KtBinaryModule invoke() {
                        return (KtBinaryModule)TestModuleStructureFactory.access$createLibraryModule(TestModuleStructureFactory.INSTANCE, this.$project, this.$libraryRoot, JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), this.$testServices);
                    }
                });
                ktModule.getDirectRegularDependencies().add((KtModule)libraryModule2);
            }
        }
        if ((list = (List)compilerConfiguration.get(JSConfigurationKeys.LIBRARIES)) == null) {
            list = CollectionsKt.emptyList();
        }
        List jsLibraryRootPaths = list;
        for (String libraryRootPath : jsLibraryRootPaths) {
            Path libraryRoot = Paths.get(libraryRootPath, new String[0]);
            Intrinsics.checkNotNull((Object)libraryRoot);
            if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)libraryRoot), (Object)"klib")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            KtBinaryModule libraryModule3 = (KtBinaryModule)libraryCache.invoke((Object)SetsKt.setOf((Object)libraryRoot), (Object)new Function0<KtBinaryModule>(project, libraryRoot, testServices){
                final /* synthetic */ Project $project;
                final /* synthetic */ Path $libraryRoot;
                final /* synthetic */ TestServices $testServices;
                {
                    this.$project = $project;
                    this.$libraryRoot = $libraryRoot;
                    this.$testServices = $testServices;
                    super(0);
                }

                public final KtBinaryModule invoke() {
                    Path path = this.$libraryRoot;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"$libraryRoot");
                    return (KtBinaryModule)TestModuleStructureFactory.access$createLibraryModule(TestModuleStructureFactory.INSTANCE, this.$project, path, JsPlatforms.INSTANCE.getDefaultJsPlatform(), this.$testServices);
                }
            });
            ktModule.getDirectRegularDependencies().add((KtModule)libraryModule3);
        }
    }

    private final KtLibraryModuleImpl createLibraryModule(Project project, Path libraryFile, TargetPlatform platform, TestServices testServices) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(libraryFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-check-TestModuleStructureFactory$createLibraryModule$22 = false;
            String $i$a$-check-TestModuleStructureFactory$createLibraryModule$22 = "Library " + libraryFile + " does not exist";
            throw new IllegalStateException($i$a$-check-TestModuleStructureFactory$createLibraryModule$22.toString());
        }
        String libraryName = PathsKt.getNameWithoutExtension((Path)libraryFile);
        GlobalSearchScope libraryScope = this.getScopeForLibraryByRoots(CollectionsKt.listOf((Object)libraryFile), testServices);
        return new KtLibraryModuleImpl(libraryName, platform, libraryScope, project, CollectionsKt.listOf((Object)libraryFile), null);
    }

    @NotNull
    public final GlobalSearchScope getScopeForLibraryByRoots(@NotNull Collection<? extends Path> roots, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots(roots, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> createSourcePsiFiles(@NotNull TestModule testModule, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = testModule.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile psiFile;
            void testFile;
            TestFile testFile2 = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (SourceFileProviderKt.isKtFile((TestFile)testFile)) {
                String fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile((TestFile)testFile);
                KtFile ktFile = KtTestUtil.createFile((String)testFile.getName(), (String)fileText, (Project)project);
                Intrinsics.checkNotNull((Object)ktFile);
                psiFile = (PsiFile)ktFile;
            } else if (SourceFileProviderKt.isJavaFile((TestFile)testFile) || SourceFileProviderKt.isExternalAnnotation((TestFile)testFile)) {
                VirtualFile virtualFile;
                File filePath = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getRealFileForSourceFile((TestFile)testFile);
                if (AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment().getLocalFileSystem().findFileByIoFile(filePath) == null) {
                    throw new IllegalStateException(("Virtual file not found for " + filePath).toString());
                }
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    throw new IllegalStateException(("PsiFile file not found for " + filePath).toString());
                }
            } else {
                throw new IllegalStateException(("Unexpected file " + testFile.getName()).toString());
            }
            collection.add(psiFile);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ KtLibraryModuleImpl access$createLibraryModule(TestModuleStructureFactory $this, Project project, Path libraryFile, TargetPlatform platform, TestServices testServices) {
        return $this.createLibraryModule(project, libraryFile, platform, testServices);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyRelation.values().length];
            try {
                nArray[DependencyRelation.RegularDependency.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.FriendDependency.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.DependsOnDependency.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

