/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractSourceLazyDeclarationResolveForTypeAnnotationsTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations")
@TestDataPath(value="$PROJECT_ROOT")
public class SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated
extends AbstractSourceLazyDeclarationResolveForTypeAnnotationsTest {
    @Test
    public void testAllFilesPresentInLazyResolveTypeAnnotations() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAlias {
        @Test
        public void testAllFilesPresentInTypeAlias() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="insideFunction.kt")
        public void testInsideFunction() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunction.kt");
        }

        @Test
        @TestMetadata(value="insideFunctionComplex.kt")
        public void testInsideFunctionComplex() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/insideFunctionComplex.kt");
        }

        @Test
        @TestMetadata(value="nestedAliasWithNestedAnnotationInLocalClass.kt")
        public void testNestedAliasWithNestedAnnotationInLocalClass() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/nestedAliasWithNestedAnnotationInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/simple.kt");
        }

        @Test
        @TestMetadata(value="withMissedArguments.kt")
        public void testWithMissedArguments() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/typeAlias/withMissedArguments.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperty {
        @Test
        public void testAllFilesPresentInSyntheticProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="getterAndSetterWithExplicitReturnType.kt")
        public void testGetterAndSetterWithExplicitReturnType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterAndSetterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithExplicitReturnType.kt")
        public void testGetterWithExplicitReturnType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="getterWithImplicitReturnType.kt")
        public void testGetterWithImplicitReturnType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/syntheticProperty/getterWithImplicitReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SubstitutionOverride {
        @Test
        public void testAllFilesPresentInSubstitutionOverride() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructor.kt")
        public void testConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructor.kt");
        }

        @Test
        @TestMetadata(value="constructorCallSite.kt")
        public void testConstructorCallSite() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/constructorCallSite.kt");
        }

        @Test
        @TestMetadata(value="function.kt")
        public void testFunction() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/function.kt");
        }

        @Test
        @TestMetadata(value="functionUnavailable.kt")
        public void testFunctionUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/functionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitFunction.kt")
        public void testImplicitFunction() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunction.kt");
        }

        @Test
        @TestMetadata(value="implicitFunctionUnavailable.kt")
        public void testImplicitFunctionUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitFunctionUnavailable.kt");
        }

        @Test
        @TestMetadata(value="implicitProperty.kt")
        public void testImplicitProperty() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitProperty.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyAndReceiver.kt")
        public void testImplicitPropertyAndReceiver() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyAndReceiver.kt");
        }

        @Test
        @TestMetadata(value="implicitPropertyUnavailable.kt")
        public void testImplicitPropertyUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/implicitPropertyUnavailable.kt");
        }

        @Test
        @TestMetadata(value="property.kt")
        public void testProperty() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/property.kt");
        }

        @Test
        @TestMetadata(value="propertyUnavailable.kt")
        public void testPropertyUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/substitutionOverride/propertyUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Property {
        @Test
        public void testAllFilesPresentInProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromConstructor.kt")
        public void testGeneratedPropertyFromConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/generatedPropertyFromConstructor.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeInLocalClass.kt")
        public void testImplicitTypeInLocalClass() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedType.kt")
        public void testLocalDelegatedPropertyWithPropagatedType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalDelegatedPropertyWithPropagatedTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localDelegatedPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithExplicitType.kt")
        public void testLocalPropertyWithExplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedType.kt")
        public void testLocalPropertyWithPropagatedType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedType.kt");
        }

        @Test
        @TestMetadata(value="localPropertyWithPropagatedTypeUnavailable.kt")
        public void testLocalPropertyWithPropagatedTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/localPropertyWithPropagatedTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propertyTypeCollisionAndAnnotations.kt")
        public void testPropertyTypeCollisionAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/propertyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/property/typeParameterAnnotationsInLocalClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Function {
        @Test
        public void testAllFilesPresentInFunction() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="component1TypeCollisionAndAnnotations.kt")
        public void testComponent1TypeCollisionAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/component1TypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="copyTypeCollisionAndAnnotations.kt")
        public void testCopyTypeCollisionAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/copyTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotationsAsConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/delegatedFieldNestedNameClashWithNestedTypesAndAnnotationsAsConstructor.kt");
        }

        @Test
        @TestMetadata(value="explicitType.kt")
        public void testExplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/explicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedComponentN.kt")
        public void testGeneratedComponentN() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedComponentN.kt");
        }

        @Test
        @TestMetadata(value="generatedCopy.kt")
        public void testGeneratedCopy() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/generatedCopy.kt");
        }

        @Test
        @TestMetadata(value="implicitType.kt")
        public void testImplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitType.kt");
        }

        @Test
        @TestMetadata(value="implicitTypeUnavailable.kt")
        public void testImplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/implicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunction.kt");
        }

        @Test
        @TestMetadata(value="localFunctionImplicitType.kt")
        public void testLocalFunctionImplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/localFunctionImplicitType.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotations.kt")
        public void testTypeParameterAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotations.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAnnotationsInLocalClass.kt")
        public void testTypeParameterAnnotationsInLocalClass() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typeParameterAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromFunctionWithInaccessibleAnnotationArgument() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromFunctionWithInaccessibleAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt")
        public void testTypePropagationFromPropertyWithInaccessibleAnnotationArgument() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/function/typePropagationFromPropertyWithInaccessibleAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ErrorType {
        @Test
        public void testAllFilesPresentInErrorType() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="errorType.kt")
        public void testErrorType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/errorType.kt");
        }

        @Test
        @TestMetadata(value="nestedErrorReturnType.kt")
        public void testNestedErrorReturnType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/errorType/nestedErrorReturnType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Delegate {
        @Test
        public void testAllFilesPresentInDelegate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitType.kt")
        public void testDelegateWithExplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithExplicitTypeUnavailable.kt")
        public void testDelegateWithExplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitType.kt")
        public void testDelegateWithImplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="delegateWithImplicitTypeUnavailable.kt")
        public void testDelegateWithImplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegateWithImplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedName.kt")
        public void testDelegatedFieldNestedName() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedName.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="field.kt")
        public void testField() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/field.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitType.kt")
        public void testPropertyWithExplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithExplicitTypeUnavailable.kt")
        public void testPropertyWithExplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithExplicitTypeUnavailable.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitType.kt")
        public void testPropertyWithImplicitType() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyWithImplicitTypeUnavailable.kt")
        public void testPropertyWithImplicitTypeUnavailable() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/delegate/propertyWithImplicitTypeUnavailable.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constructor {
        @Test
        public void testAllFilesPresentInConstructor() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="call.kt")
        public void testCall() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/call.kt");
        }

        @Test
        @TestMetadata(value="callWithConstructor.kt")
        public void testCallWithConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/callWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="reference.kt")
        public void testReference() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/reference.kt");
        }

        @Test
        @TestMetadata(value="referenceWithConstructor.kt")
        public void testReferenceWithConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/referenceWithConstructor.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/constructor/secondaryConstructor.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Class {
        @Test
        public void testAllFilesPresentInClass() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classAnnotationsInLocalClass.kt")
        public void testClassAnnotationsInLocalClass() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/classAnnotationsInLocalClass.kt");
        }

        @Test
        @TestMetadata(value="delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt")
        public void testDelegatedFieldNestedNameClashWithNestedTypesAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/delegatedFieldNestedNameClashWithNestedTypesAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument.kt")
        public void testNestedClassAsAnnotationArgument() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument2.kt")
        public void testNestedClassAsAnnotationArgument2() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/nestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="parameterTypeCollisionAndAnnotations.kt")
        public void testParameterTypeCollisionAndAnnotations() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/parameterTypeCollisionAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument.kt")
        public void testQualifiedNestedClassAsAnnotationArgument() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument2.kt")
        public void testQualifiedNestedClassAsAnnotationArgument2() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/qualifiedNestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotation.kt")
        public void testSuperTypeCallNameClashWithAnnotation() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNameClashWithAnnotationImplicitConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNameClashWithAnnotationImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotation.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotation() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt")
        public void testSuperTypeCallNestedNameClashWithAnnotationImplicitConstructor() throws Exception {
            SourceLazyDeclarationResolveForTypeAnnotationsTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolveTypeAnnotations/class/superTypeCallNestedNameClashWithAnnotationImplicitConstructor.kt");
        }
    }
}

