/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractFirScriptLazyDeclarationResolveTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve")
@TestDataPath(value="$PROJECT_ROOT")
public class FirScriptLazyDeclarationResolveTestGenerated
extends AbstractFirScriptLazyDeclarationResolveTest {
    @Test
    public void testAllFilesPresentInLazyResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="annotationArgumentsMixScript.kts")
    public void testAnnotationArgumentsMixScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationArgumentsMixScript.kts");
    }

    @Test
    @TestMetadata(value="annotationClassWithJavaTargetScript.kts")
    public void testAnnotationClassWithJavaTargetScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationClassWithJavaTargetScript.kts");
    }

    @Test
    @TestMetadata(value="annotationOnLocalClassScript.kts")
    public void testAnnotationOnLocalClassScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnLocalClassScript.kts");
    }

    @Test
    @TestMetadata(value="annotationParametersScript.kts")
    public void testAnnotationParametersScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationParametersScript.kts");
    }

    @Test
    @TestMetadata(value="annotationWithTypeArgumentScript.kts")
    public void testAnnotationWithTypeArgumentScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithTypeArgumentScript.kts");
    }

    @Test
    @TestMetadata(value="annotationsScript.kts")
    public void testAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationsScript.kts");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameter2Script.kts")
    public void testAnonymousFunctionWithAnnotatedParameter2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter2Script.kts");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameterOnImplicitTypePhaseScript.kts")
    public void testAnonymousFunctionWithAnnotatedParameterOnImplicitTypePhaseScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameterOnImplicitTypePhaseScript.kts");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameterScript.kts")
    public void testAnonymousFunctionWithAnnotatedParameterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameterScript.kts");
    }

    @Test
    @TestMetadata(value="classMembersScript.kts")
    public void testClassMembersScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classMembersScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationOnLocalClassScript.kts")
    public void testCompilerRequiredAnnotationOnLocalClassScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationOnLocalClassScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructorPropertyScript.kts")
    public void testCompilerRequiredAnnotationsOnConstructorPropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructorPropertyScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructorScript.kts")
    public void testCompilerRequiredAnnotationsOnConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnFunctionScript.kts")
    public void testCompilerRequiredAnnotationsOnFunctionScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnFunctionScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnPropertyDelegateScript.kts")
    public void testCompilerRequiredAnnotationsOnPropertyDelegateScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnPropertyDelegateScript.kts");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnPropertyScript.kts")
    public void testCompilerRequiredAnnotationsOnPropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnPropertyScript.kts");
    }

    @Test
    @TestMetadata(value="complexLocalHierarchyScript.kts")
    public void testComplexLocalHierarchyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexLocalHierarchyScript.kts");
    }

    @Test
    @TestMetadata(value="complexRedeclarationScript.kts")
    public void testComplexRedeclarationScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexRedeclarationScript.kts");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy2Script.kts")
    public void testCyclicHierarchy2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy2Script.kts");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy3Script.kts")
    public void testCyclicHierarchy3Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy3Script.kts");
    }

    @Test
    @TestMetadata(value="cyclicHierarchyScript.kts")
    public void testCyclicHierarchyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchyScript.kts");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchy2Script.kts")
    public void testCyclicNestedHierarchy2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy2Script.kts");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchyScript.kts")
    public void testCyclicNestedHierarchyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchyScript.kts");
    }

    @Test
    @TestMetadata(value="dataClassCopyScript.kts")
    public void testDataClassCopyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataClassCopyScript.kts");
    }

    @Test
    @TestMetadata(value="dataComponent2Script.kts")
    public void testDataComponent2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataComponent2Script.kts");
    }

    @Test
    @TestMetadata(value="delegateWithImplicitTypeScript.kts")
    public void testDelegateWithImplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="delegatedFieldNestedNameClashScript.kts")
    public void testDelegatedFieldNestedNameClashScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClashScript.kts");
    }

    @Test
    @TestMetadata(value="delegatedFieldNestedNameClashWithNestedTypesScript.kts")
    public void testDelegatedFieldNestedNameClashWithNestedTypesScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldNestedNameClashWithNestedTypesScript.kts");
    }

    @Test
    @TestMetadata(value="delegatedFieldScript.kts")
    public void testDelegatedFieldScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedFieldScript.kts");
    }

    @Test
    @TestMetadata(value="delegatesScript.kts")
    public void testDelegatesScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatesScript.kts");
    }

    @Test
    @TestMetadata(value="enumEntriesScript.kts")
    public void testEnumEntriesScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntriesScript.kts");
    }

    @Test
    @TestMetadata(value="enumEntryScript.kts")
    public void testEnumEntryScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntryScript.kts");
    }

    @Test
    @TestMetadata(value="enumValueOfScript.kts")
    public void testEnumValueOfScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValueOfScript.kts");
    }

    @Test
    @TestMetadata(value="enumValuesScript.kts")
    public void testEnumValuesScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValuesScript.kts");
    }

    @Test
    @TestMetadata(value="explicitSubstitutionOverridePropertyScript.kts")
    public void testExplicitSubstitutionOverridePropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/explicitSubstitutionOverridePropertyScript.kts");
    }

    @Test
    @TestMetadata(value="fakeOverrideScript.kts")
    public void testFakeOverrideScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakeOverrideScript.kts");
    }

    @Test
    @TestMetadata(value="fakePrimaryConstructorScript.kts")
    public void testFakePrimaryConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakePrimaryConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="fileAnnotationsScript.kts")
    public void testFileAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fileAnnotationsScript.kts");
    }

    @Test
    @TestMetadata(value="fromLocalHierarchyToOuterScript.kts")
    public void testFromLocalHierarchyToOuterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fromLocalHierarchyToOuterScript.kts");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndAnnotationsScript.kts")
    public void testFunctionWithImplicitTypeAndAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndAnnotationsScript.kts");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndStringTemplateAsDefaultValueScript.kts")
    public void testFunctionWithImplicitTypeAndStringTemplateAsDefaultValueScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndStringTemplateAsDefaultValueScript.kts");
    }

    @Test
    @TestMetadata(value="functionWithParameterScript.kts")
    public void testFunctionWithParameterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithParameterScript.kts");
    }

    @Test
    @TestMetadata(value="implicitSubstitutionOverridePropertyScript.kts")
    public void testImplicitSubstitutionOverridePropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitSubstitutionOverridePropertyScript.kts");
    }

    @Test
    @TestMetadata(value="lambdaAsSAMInterfaceScript.kts")
    public void testLambdaAsSAMInterfaceScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lambdaAsSAMInterfaceScript.kts");
    }

    @Test
    @TestMetadata(value="lazyPropertyScript.kts")
    public void testLazyPropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lazyPropertyScript.kts");
    }

    @Test
    @TestMetadata(value="localConstructorScript.kts")
    public void testLocalConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideAnnotationCallScript.kts")
    public void testLocalFunctionInsideAnnotationCallScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideAnnotationCallScript.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideFunctionLiteralScript.kts")
    public void testLocalFunctionInsideFunctionLiteralScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideFunctionLiteralScript.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideLambdaCallInsideStringTemplateScript.kts")
    public void testLocalFunctionInsideLambdaCallInsideStringTemplateScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideLambdaCallInsideStringTemplateScript.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideStatement.kts")
    public void testLocalFunctionInsideStatement() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideStatement.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideStringTemplateScript.kts")
    public void testLocalFunctionInsideStringTemplateScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideStringTemplateScript.kts");
    }

    @Test
    @TestMetadata(value="localFunctionInsideSuperEntryCallScript.kts")
    public void testLocalFunctionInsideSuperEntryCallScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideSuperEntryCallScript.kts");
    }

    @Test
    @TestMetadata(value="localNestedClassScript.kts")
    public void testLocalNestedClassScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localNestedClassScript.kts");
    }

    @Test
    @TestMetadata(value="localParameterInsideSuperEntryCallScript.kts")
    public void testLocalParameterInsideSuperEntryCallScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localParameterInsideSuperEntryCallScript.kts");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsForMemberScript.kts")
    public void testNestedCompilerRequiredAnnotationsForMemberScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsForMemberScript.kts");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsInsideBodyScript.kts")
    public void testNestedCompilerRequiredAnnotationsInsideBodyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsInsideBodyScript.kts");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsScript.kts")
    public void testNestedCompilerRequiredAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsScript.kts");
    }

    @Test
    @TestMetadata(value="nestedTypeAlias2Script.kts")
    public void testNestedTypeAlias2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias2Script.kts");
    }

    @Test
    @TestMetadata(value="nestedTypeAliasScript.kts")
    public void testNestedTypeAliasScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAliasScript.kts");
    }

    @Test
    @TestMetadata(value="parameterOfNonLocalSetterScript.kts")
    public void testParameterOfNonLocalSetterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfNonLocalSetterScript.kts");
    }

    @Test
    @TestMetadata(value="parameterOfTopSetterScript.kts")
    public void testParameterOfTopSetterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfTopSetterScript.kts");
    }

    @Test
    @TestMetadata(value="primaryConstructorParameterScript.kts")
    public void testPrimaryConstructorParameterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorParameterScript.kts");
    }

    @Test
    @TestMetadata(value="primaryConstructorPropertyScript.kts")
    public void testPrimaryConstructorPropertyScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorPropertyScript.kts");
    }

    @Test
    @TestMetadata(value="primaryConstructorScript.kts")
    public void testPrimaryConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="propertyDelegateWithImplicitTypeScript.kts")
    public void testPropertyDelegateWithImplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyDelegateWithImplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="propertyWithGetterAndSetterScript.kts")
    public void testPropertyWithGetterAndSetterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetterAndSetterScript.kts");
    }

    @Test
    @TestMetadata(value="propertyWithGetterScript.kts")
    public void testPropertyWithGetterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetterScript.kts");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndAnnotationsScript.kts")
    public void testPropertyWithImplicitTypeAndAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndAnnotationsScript.kts");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndFieldAnnotationsScript.kts")
    public void testPropertyWithImplicitTypeAndFieldAnnotationsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndFieldAnnotationsScript.kts");
    }

    @Test
    @TestMetadata(value="propertyWithInitializerScript.kts")
    public void testPropertyWithInitializerScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithInitializerScript.kts");
    }

    @Test
    @TestMetadata(value="redeclarationScript.kts")
    public void testRedeclarationScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/redeclarationScript.kts");
    }

    @Test
    @TestMetadata(value="resolveSuperTypeFromLocalClassScript.kts")
    public void testResolveSuperTypeFromLocalClassScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveSuperTypeFromLocalClassScript.kts");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalClassConstructorScript.kts")
    public void testResolveTypeFromLocalClassConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalClassConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalFunctionScript.kts")
    public void testResolveTypeFromLocalFunctionScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalFunctionScript.kts");
    }

    @Test
    @TestMetadata(value="script.kts")
    public void testScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/script.kts");
    }

    @Test
    @TestMetadata(value="script2.kts")
    public void testScript2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/script2.kts");
    }

    @Test
    @TestMetadata(value="script3.kts")
    public void testScript3() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/script3.kts");
    }

    @Test
    @TestMetadata(value="script4.kts")
    public void testScript4() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/script4.kts");
    }

    @Test
    @TestMetadata(value="scriptArgument.kts")
    public void testScriptArgument() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/scriptArgument.kts");
    }

    @Test
    @TestMetadata(value="secondaryConstructorParameterScript.kts")
    public void testSecondaryConstructorParameterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructorParameterScript.kts");
    }

    @Test
    @TestMetadata(value="secondaryConstructorScript.kts")
    public void testSecondaryConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="statement.kts")
    public void testStatement() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/statement.kts");
    }

    @Test
    @TestMetadata(value="statement2.kts")
    public void testStatement2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/statement2.kts");
    }

    @Test
    @TestMetadata(value="statementTransformation.kts")
    public void testStatementTransformation() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/statementTransformation.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideConstructorScript.kts")
    public void testSubstitutionFakeOverrideConstructorScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideConstructorScript.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideFunctionScript.kts")
    public void testSubstitutionFakeOverrideFunctionScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunctionScript.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideFunctionWithImplicitTypeScript.kts")
    public void testSubstitutionFakeOverrideFunctionWithImplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideFunctionWithImplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideScript.kts")
    public void testSubstitutionFakeOverrideScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideScript.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideWithImplicitTypeAndReceiverScript.kts")
    public void testSubstitutionFakeOverrideWithImplicitTypeAndReceiverScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitTypeAndReceiverScript.kts");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideWithImplicitTypeScript.kts")
    public void testSubstitutionFakeOverrideWithImplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="superTypesLoopScript.kts")
    public void testSuperTypesLoopScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypesLoopScript.kts");
    }

    @Test
    @TestMetadata(value="superTypesScript.kts")
    public void testSuperTypesScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypesScript.kts");
    }

    @Test
    @TestMetadata(value="syntheticResultDeclaration.kts")
    public void testSyntheticResultDeclaration() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticResultDeclaration.kts");
    }

    @Test
    @TestMetadata(value="syntheticResultDeclarationWithBigBody.kts")
    public void testSyntheticResultDeclarationWithBigBody() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticResultDeclarationWithBigBody.kts");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsScript.kts")
    public void testTopLevelFunctionsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsScript.kts");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithExpressionBodyAndExplicitTypeScript.kts")
    public void testTopLevelFunctionsWithExpressionBodyAndExplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithExpressionBodyAndExplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithImplicitTypeScript.kts")
    public void testTopLevelFunctionsWithImplicitTypeScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithImplicitTypeScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterBoundsScript.kts")
    public void testTypeParameterBoundsScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterBoundsScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfClass2Script.kts")
    public void testTypeParameterOfClass2Script() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass2Script.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfClassScript.kts")
    public void testTypeParameterOfClassScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClassScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfNonLocalFunctionScript.kts")
    public void testTypeParameterOfNonLocalFunctionScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfNonLocalFunctionScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopFunctionScript.kts")
    public void testTypeParameterOfTopFunctionScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopFunctionScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopSetterScript.kts")
    public void testTypeParameterOfTopSetterScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopSetterScript.kts");
    }

    @Test
    @TestMetadata(value="typeParameterOfTypeAliasScript.kts")
    public void testTypeParameterOfTypeAliasScript() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTypeAliasScript.kts");
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/typeAliases")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAliases {
        @Test
        public void testAllFilesPresentInTypeAliases() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/typeAliases"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="typeAliasWithTypeParametersScript.kts")
        public void testTypeAliasWithTypeParametersScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithTypeParametersScript.kts");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperties {
        @Test
        public void testAllFilesPresentInSyntheticProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/properties"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="getterWithDelegationScript.kts")
        public void testGetterWithDelegationScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/getterWithDelegationScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2Script.kts")
        public void testHierarchyWithOverrideAndNestedClass2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass2Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3Script.kts")
        public void testHierarchyWithOverrideAndNestedClass3Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass3Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4Script.kts")
        public void testHierarchyWithOverrideAndNestedClass4Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass4Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClassScript.kts")
        public void testHierarchyWithOverrideAndNestedClassScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClassScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideScript.kts")
        public void testHierarchyWithOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideScript.kts");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitTypeAndBodyScript.kts")
        public void testPropertyGetterWithExplicitTypeAndBodyScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitTypeAndBodyScript.kts");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitTypeScript.kts")
        public void testPropertyGetterWithExplicitTypeScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitTypeScript.kts");
        }

        @Test
        @TestMetadata(value="propertyGetterWithImplicitTypeScript.kts")
        public void testPropertyGetterWithImplicitTypeScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithImplicitTypeScript.kts");
        }

        @Test
        @TestMetadata(value="propertySetterScript.kts")
        public void testPropertySetterScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertySetterScript.kts");
        }

        @Test
        @TestMetadata(value="propertyWithTypeParametersScript.kts")
        public void testPropertyWithTypeParametersScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyWithTypeParametersScript.kts");
        }

        @Test
        @TestMetadata(value="resultWithPropagatedType.kts")
        public void testResultWithPropagatedType() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/resultWithPropagatedType.kts");
        }

        @Test
        @TestMetadata(value="scriptWithResultWithPropagatedType.kts")
        public void testScriptWithResultWithPropagatedType() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/scriptWithResultWithPropagatedType.kts");
        }

        @Test
        @TestMetadata(value="scriptWithTypeAnnotationsOnDeclaration.kts")
        public void testScriptWithTypeAnnotationsOnDeclaration() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/scriptWithTypeAnnotationsOnDeclaration.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2Script.kts")
        public void testSimpleLoopInOverride2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride2Script.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverrideScript.kts")
        public void testSimpleLoopInOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverrideScript.kts");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/noRuntime")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NoRuntime {
        @Test
        public void testAllFilesPresentInNoRuntime() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/noRuntime"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/functions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Functions {
        @Test
        public void testAllFilesPresentInFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/functions"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="contractScript.kts")
        public void testContractScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/contractScript.kts");
        }

        @Test
        @TestMetadata(value="contractScript2.kts")
        public void testContractScript2() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/contractScript2.kts");
        }

        @Test
        @TestMetadata(value="functionCallWithGenericResultScript.kts")
        public void testFunctionCallWithGenericResultScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionCallWithGenericResultScript.kts");
        }

        @Test
        @TestMetadata(value="functionParameterScript.kts")
        public void testFunctionParameterScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionParameterScript.kts");
        }

        @Test
        @TestMetadata(value="functionWithGenericExpectedTypeInsideScript.kts")
        public void testFunctionWithGenericExpectedTypeInsideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithGenericExpectedTypeInsideScript.kts");
        }

        @Test
        @TestMetadata(value="functionWithTypeParametersScript.kts")
        public void testFunctionWithTypeParametersScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithTypeParametersScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2Script.kts")
        public void testHierarchyWithOverrideAndNestedClass2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass2Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3Script.kts")
        public void testHierarchyWithOverrideAndNestedClass3Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass3Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClassScript.kts")
        public void testHierarchyWithOverrideAndNestedClassScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClassScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideScript.kts")
        public void testHierarchyWithOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideScript.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2Script.kts")
        public void testSimpleLoopInOverride2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride2Script.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverrideScript.kts")
        public void testSimpleLoopInOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverrideScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashImplicitConstructorScript.kts")
        public void testSuperTypeCallNameClashImplicitConstructorScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClashImplicitConstructorScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashScript.kts")
        public void testSuperTypeCallNameClashScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNameClashScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashImplicitConstructorScript.kts")
        public void testSuperTypeCallNestedNameClashImplicitConstructorScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClashImplicitConstructorScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashScript.kts")
        public void testSuperTypeCallNestedNameClashScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/superTypeCallNestedNameClashScript.kts");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/errors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/errors"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/classes"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationWithTargetScript.kts")
        public void testAnnotationWithTargetScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithTargetScript.kts");
        }

        @Test
        @TestMetadata(value="classWithTypeParametersScript.kts")
        public void testClassWithTypeParametersScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classWithTypeParametersScript.kts");
        }

        @Test
        @TestMetadata(value="functionInValueClassScript.kts")
        public void testFunctionInValueClassScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/functionInValueClassScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2Script.kts")
        public void testHierarchyWithOverrideAndNestedClass2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass2Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3Script.kts")
        public void testHierarchyWithOverrideAndNestedClass3Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass3Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4Script.kts")
        public void testHierarchyWithOverrideAndNestedClass4Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass4Script.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClassScript.kts")
        public void testHierarchyWithOverrideAndNestedClassScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClassScript.kts");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideScript.kts")
        public void testHierarchyWithOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideScript.kts");
        }

        @Test
        @TestMetadata(value="nestedClassScript.kts")
        public void testNestedClassScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassScript.kts");
        }

        @Test
        @TestMetadata(value="nestedClassWithPropertiesOverridesScript.kts")
        public void testNestedClassWithPropertiesOverridesScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassWithPropertiesOverridesScript.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2Script.kts")
        public void testSimpleLoopInOverride2Script() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride2Script.kts");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverrideScript.kts")
        public void testSimpleLoopInOverrideScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverrideScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashImplicitConstructorScript.kts")
        public void testSuperTypeCallNameClashImplicitConstructorScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClashImplicitConstructorScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNameClashScript.kts")
        public void testSuperTypeCallNameClashScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNameClashScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashImplicitConstructorScript.kts")
        public void testSuperTypeCallNestedNameClashImplicitConstructorScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClashImplicitConstructorScript.kts");
        }

        @Test
        @TestMetadata(value="superTypeCallNestedNameClashScript.kts")
        public void testSuperTypeCallNestedNameClashScript() throws Exception {
            FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/superTypeCallNestedNameClashScript.kts");
        }

        @Nested
        @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DataClass {
            @Test
            public void testAllFilesPresentInDataClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass"), (Pattern)Pattern.compile("^(.+)\\.(kts)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="component1TypeCollisionScript.kts")
            public void testComponent1TypeCollisionScript() throws Exception {
                FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/component1TypeCollisionScript.kts");
            }

            @Test
            @TestMetadata(value="copyTypeCollisionScript.kts")
            public void testCopyTypeCollisionScript() throws Exception {
                FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/copyTypeCollisionScript.kts");
            }

            @Test
            @TestMetadata(value="parameterTypeCollisionScript.kts")
            public void testParameterTypeCollisionScript() throws Exception {
                FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/parameterTypeCollisionScript.kts");
            }

            @Test
            @TestMetadata(value="propertyTypeCollisionScript.kts")
            public void testPropertyTypeCollisionScript() throws Exception {
                FirScriptLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/dataClass/propertyTypeCollisionScript.kts");
            }
        }
    }
}

