/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtJdkModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleFactoryKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleWithModifiableDependencies;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfiguratorKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u0015H\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010\b\u001a\u00020\tJ$\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory;", "", "<init>", "()V", "createProjectStructureByTestStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "createLibrariesByCompilerConfigurators", "", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtLibraryModuleImpl;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "addModuleDependencies", "", "moduleByName", "", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getLibraryModules", "createKtLibraryModuleByJar", "jar", "Ljava/nio/file/Path;", "libraryName", "getStdlibModules", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "getJdkModule", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtJdkModuleImpl;", "getScopeForLibraryByRoots", "Lcom/intellij/psi/search/GlobalSearchScope;", "roots", "", "createSourcePsiFiles", "Lcom/intellij/psi/PsiFile;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleStructureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1549#2:211\n1620#2,3:212\n1855#2:215\n1856#2:223\n800#2,11:224\n1549#2:235\n1620#2,3:236\n1855#2,2:242\n1549#2:244\n1620#2,3:245\n1549#2:248\n1620#2,3:249\n1620#2,3:253\n1549#2:256\n1620#2,3:257\n372#3,7:216\n16#4:239\n17#4:241\n1#5:240\n1#5:252\n*S KotlinDebug\n*F\n+ 1 TestModuleStructureFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/TestModuleStructureFactory\n*L\n45#1:211\n45#1:212,3\n65#1:215\n65#1:223\n86#1:224,11\n87#1:235\n87#1:236,3\n92#1:242,2\n110#1:244\n110#1:245,3\n111#1:248\n111#1:249,3\n163#1:253,3\n188#1:256\n188#1:257,3\n66#1:216,7\n91#1:239\n91#1:241\n91#1:240\n*E\n"})
public final class TestModuleStructureFactory {
    @NotNull
    public static final TestModuleStructureFactory INSTANCE = new TestModuleStructureFactory();

    private TestModuleStructureFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KtModuleProjectStructure createProjectStructureByTestStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = moduleStructure.getModules();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void testModule;
            TestModule testModule2 = (TestModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KtModuleFactoryKt.getKtModuleFactory(testServices).createModule((TestModule)testModule, testServices, project));
        }
        List moduleEntries = (List)destination$iv$iv;
        Map<String, KtModuleWithFiles> moduleEntriesByName = AnalysisApiKtModuleProviderImplKt.associateByName(moduleEntries);
        Map binaryModulesBySourceRoots = new LinkedHashMap();
        for (TestModule testModule : moduleStructure.getModules()) {
            KtModuleWithFiles moduleWithFiles;
            KtModule ktModule;
            KtModuleWithFiles ktModuleWithFiles = moduleEntriesByName.get(testModule.getName());
            if (ktModuleWithFiles == null) {
                ktModuleWithFiles = (KtModuleWithFiles)MapsKt.getValue(moduleEntriesByName, (Object)((TestFile)kotlin.collections.CollectionsKt.single((List)testModule.getFiles())).getName());
            }
            if ((ktModule = (moduleWithFiles = ktModuleWithFiles).getKtModule()) instanceof KtNotUnderContentRootModule) continue;
            if (ktModule instanceof KtModuleWithModifiableDependencies) {
                void $this$forEach$iv;
                Object item$iv$iv;
                this.addModuleDependencies(testModule, moduleEntriesByName, ktModule);
                Object $this$createProjectStructureByTestStructure_u24lambda_u241 = item$iv$iv = kotlin.collections.CollectionsKt.createListBuilder();
                boolean bl = false;
                CollectionsKt.addIfNotNull((Collection)((Collection)$this$createProjectStructureByTestStructure_u24lambda_u241), (Object)INSTANCE.getJdkModule(testModule, project, testServices));
                $this$createProjectStructureByTestStructure_u24lambda_u241.addAll((Collection)INSTANCE.getStdlibModules(testModule, project, testServices));
                $this$createProjectStructureByTestStructure_u24lambda_u241.addAll((Collection)INSTANCE.getLibraryModules(testServices, testModule, project));
                $this$createProjectStructureByTestStructure_u24lambda_u241.addAll((Collection)INSTANCE.createLibrariesByCompilerConfigurators(testModule, testServices, project));
                item$iv$iv = kotlin.collections.CollectionsKt.build((List)item$iv$iv);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    void $this$getOrPut$iv;
                    KtBinaryModule library = (KtBinaryModule)element$iv;
                    boolean bl2 = false;
                    Map map = binaryModulesBySourceRoots;
                    Set key$iv = kotlin.collections.CollectionsKt.toSet((Iterable)library.getBinaryRoots());
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        KtBinaryModule answer$iv = library;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    KtBinaryModule cachedLibrary = (KtBinaryModule)object;
                    ((KtModuleWithModifiableDependencies)ktModule).getDirectRegularDependencies().add((KtModule)cachedLibrary);
                }
                continue;
            }
            throw new IllegalStateException(("Unexpected module type: " + ktModule.getClass().getName()).toString());
        }
        return new KtModuleProjectStructure(moduleEntries, (Iterable)binaryModulesBySourceRoots.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtLibraryModuleImpl> createLibrariesByCompilerConfigurators(TestModule testModule, TestServices testServices, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.createCompilerConfiguration((TestModule)testModule, (List)AbstractEnvironmentConfiguratorKt.getEnvironmentConfigurators((TestServices)testServices));
        Object object = compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS, (Object)kotlin.collections.CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List contentRoots = (List)object;
        Iterable iterable = contentRoots;
        boolean $i$f$filterIsInstance = false;
        void var8_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JvmClasspathRoot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void root;
            JvmClasspathRoot jvmClasspathRoot = (JvmClasspathRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = root.getFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            collection.add(TestModuleStructureFactory.createKtLibraryModuleByJar$default(INSTANCE, path, testServices, project, null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private final void addModuleDependencies(TestModule testModule, Map<String, KtModuleWithFiles> moduleByName, KtModule ktModule) {
        boolean $i$f$requireIsInstance = false;
        if (!(ktModule instanceof KtModuleWithModifiableDependencies)) {
            boolean $i$a$-require-ChecksKt$requireIsInstance$1$iv22 = false;
            String $i$a$-require-ChecksKt$requireIsInstance$1$iv22 = "Expected " + Reflection.getOrCreateKotlinClass(KtModuleWithModifiableDependencies.class) + " instead of " + Reflection.getOrCreateKotlinClass(ktModule.getClass()) + " for " + ktModule;
            throw new IllegalArgumentException($i$a$-require-ChecksKt$requireIsInstance$1$iv22.toString());
        }
        Iterable $this$forEach$iv = testModule.getAllDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv;
            boolean bl = false;
            KtModule dependencyKtModule = ((KtModuleWithFiles)MapsKt.getValue(moduleByName, (Object)dependency.getModuleName())).getKtModule();
            switch (WhenMappings.$EnumSwitchMapping$0[dependency.getRelation().ordinal()]) {
                case 1: {
                    boolean bl2 = ((KtModuleWithModifiableDependencies)ktModule).getDirectRegularDependencies().add(dependencyKtModule);
                    break;
                }
                case 2: {
                    boolean bl2 = ((KtModuleWithModifiableDependencies)ktModule).getDirectFriendDependencies().add(dependencyKtModule);
                    break;
                }
                case 3: {
                    boolean bl2 = ((KtModuleWithModifiableDependencies)ktModule).getDirectDependsOnDependencies().add(dependencyKtModule);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtLibraryModuleImpl> getLibraryModules(TestServices testServices, TestModule testModule, Project project) {
        Path it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ConfigurationKind configurationKind = JvmEnvironmentConfigurator.Companion.extractConfigurationKind(testModule.getDirectives());
        Iterable iterable = JvmEnvironmentConfigurator.Companion.getLibraryFilesExceptRealRuntime(testServices, configurationKind, testModule.getDirectives());
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((File)((Object)it)).toPath().toAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void jar;
            it = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)jar);
            collection.add(TestModuleStructureFactory.createKtLibraryModuleByJar$default(INSTANCE, (Path)jar, testServices, project, null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private final KtLibraryModuleImpl createKtLibraryModuleByJar(Path jar, TestServices testServices, Project project, String libraryName) {
        if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)jar), (Object)"jar")) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(jar, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "library " + jar + " does not exist";
            throw new IllegalStateException(string.toString());
        }
        return new KtLibraryModuleImpl(libraryName, JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), this.getScopeForLibraryByRoots(kotlin.collections.CollectionsKt.listOf((Object)jar), testServices), project, kotlin.collections.CollectionsKt.listOf((Object)jar), null);
    }

    static /* synthetic */ KtLibraryModuleImpl createKtLibraryModuleByJar$default(TestModuleStructureFactory testModuleStructureFactory, Path path, TestServices testServices, Project project, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = PathsKt.getNameWithoutExtension((Path)path);
        }
        return testModuleStructureFactory.createKtLibraryModuleByJar(path, testServices, project, string);
    }

    private final List<KtLibraryModule> getStdlibModules(TestModule testModule, Project project, TestServices testServices) {
        ConfigurationKind configurationKind = JvmEnvironmentConfigurator.Companion.extractConfigurationKind(testModule.getDirectives());
        if (!configurationKind.getWithRuntime()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Path path = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider((TestServices)testServices).runtimeJarForTests().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path lib = path2;
        return kotlin.collections.CollectionsKt.listOf((Object)this.createKtLibraryModuleByJar(lib, testServices, project, "kotlin-stdlib"));
    }

    /*
     * WARNING - void declaration
     */
    private final KtJdkModuleImpl getJdkModule(TestModule testModule, Project project, TestServices testServices) {
        void destination$iv;
        void $this$mapTo$iv;
        File it;
        Iterable iterable;
        TestJdkKind jdkKind = JvmEnvironmentConfigurator.Companion.extractJdkKind(testModule.getDirectives());
        Collection $this$getJdkModule_u24lambda_u2411 = iterable = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        File file = JvmEnvironmentConfigurator.Companion.getJdkHome(jdkKind);
        if (file != null) {
            it = file;
            boolean bl2 = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            $this$getJdkModule_u24lambda_u2411.add(path);
        }
        File file2 = JvmEnvironmentConfigurator.Companion.getJdkClasspathRoot(jdkKind);
        if (file2 != null) {
            it = file2;
            boolean bl3 = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            $this$getJdkModule_u24lambda_u2411.add(path);
        }
        iterable = kotlin.collections.CollectionsKt.build((List)iterable);
        $this$getJdkModule_u24lambda_u2411 = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            Path path = (Path)item$iv;
            void var13_13 = destination$iv;
            boolean bl4 = false;
            var13_13.add(it2.toAbsolutePath());
        }
        List jdkSourceRoots = (List)destination$iv;
        if (jdkSourceRoots.isEmpty()) {
            return null;
        }
        return new KtJdkModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), this.getScopeForLibraryByRoots(jdkSourceRoots, testServices), project, jdkSourceRoots);
    }

    @NotNull
    public final GlobalSearchScope getScopeForLibraryByRoots(@NotNull Collection<? extends Path> roots, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        return StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots(roots, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> createSourcePsiFiles(@NotNull TestModule testModule, @NotNull TestServices testServices, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = testModule.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile psiFile;
            void testFile;
            TestFile testFile2 = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (SourceFileProviderKt.isKtFile((TestFile)testFile)) {
                String fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile((TestFile)testFile);
                KtFile ktFile = KtTestUtil.createFile((String)testFile.getName(), (String)fileText, (Project)project);
                Intrinsics.checkNotNull((Object)ktFile);
                psiFile = (PsiFile)ktFile;
            } else if (SourceFileProviderKt.isJavaFile((TestFile)testFile) || SourceFileProviderKt.isExternalAnnotation((TestFile)testFile)) {
                VirtualFile virtualFile;
                File filePath = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getRealFileForSourceFile((TestFile)testFile);
                if (AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getApplicationEnvironment().getLocalFileSystem().findFileByIoFile(filePath) == null) {
                    throw new IllegalStateException(("Virtual file not found for " + filePath).toString());
                }
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    throw new IllegalStateException(("PsiFile file not found for " + filePath).toString());
                }
            } else {
                throw new IllegalStateException(("Unexpected file " + testFile.getName()).toString());
            }
            collection.add(psiFile);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyRelation.values().length];
            try {
                nArray[DependencyRelation.RegularDependency.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.FriendDependency.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyRelation.DependsOnDependency.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

