/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithMembers;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H&\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "", "()V", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "CallableData", "ClassData", "Companion", "TypeAliasData", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$CallableData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ClassData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeAliasData;", "analysis-api-impl-base_test"})
public abstract class SymbolData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] identifiers;

    private SymbolData() {
    }

    @NotNull
    public abstract List<KtSymbol> toSymbols(@NotNull KtAnalysisSession var1);

    public /* synthetic */ SymbolData(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String[] stringArray = new String[]{"callable:", "class:", "typealias:"};
        identifiers = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$CallableData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "getCallableId", "()Lorg/jetbrains/kotlin/name/CallableId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "analysis-api-impl-base_test"})
    public static final class CallableData
    extends SymbolData {
        @NotNull
        private final CallableId callableId;

        public CallableData(@NotNull CallableId callableId) {
            Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
            super(null);
            this.callableId = callableId;
        }

        @NotNull
        public final CallableId getCallableId() {
            return this.callableId;
        }

        @Override
        @NotNull
        public List<KtSymbol> toSymbols(@NotNull KtAnalysisSession $this$toSymbols) {
            List symbols;
            List list;
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            ClassId classId = this.callableId.getClassId();
            if (classId == null) {
                list = SequencesKt.toList((Sequence)$this$toSymbols.getTopLevelCallableSymbols(this.callableId.getPackageName(), this.callableId.getCallableName()));
            } else {
                KtClassOrObjectSymbol ktClassOrObjectSymbol = $this$toSymbols.getClassOrObjectSymbolByClassId(classId);
                if (ktClassOrObjectSymbol == null) {
                    throw new IllegalStateException(("Class " + classId + " is not found").toString());
                }
                KtClassOrObjectSymbol classSymbol = ktClassOrObjectSymbol;
                Name[] nameArray = new Name[]{this.callableId.getCallableName()};
                list = symbols = SequencesKt.toList((Sequence)$this$toSymbols.getDeclaredMemberScope((KtSymbolWithMembers)classSymbol).getCallableSymbols(nameArray));
            }
            if (symbols.isEmpty()) {
                throw new IllegalStateException(("No callable with fqName " + this.callableId + " found").toString());
            }
            return symbols;
        }

        @NotNull
        public final CallableId component1() {
            return this.callableId;
        }

        @NotNull
        public final CallableData copy(@NotNull CallableId callableId) {
            Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
            return new CallableData(callableId);
        }

        public static /* synthetic */ CallableData copy$default(CallableData callableData, CallableId callableId, int n, Object object) {
            if ((n & 1) != 0) {
                callableId = callableData.callableId;
            }
            return callableData.copy(callableId);
        }

        @NotNull
        public String toString() {
            return "CallableData(callableId=" + this.callableId + ')';
        }

        public int hashCode() {
            return this.callableId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallableData)) {
                return false;
            }
            CallableData callableData = (CallableData)other;
            return Intrinsics.areEqual((Object)this.callableId, (Object)callableData.callableId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$ClassData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "analysis-api-impl-base_test"})
    public static final class ClassData
    extends SymbolData {
        @NotNull
        private final ClassId classId;

        public ClassData(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public List<KtSymbol> toSymbols(@NotNull KtAnalysisSession $this$toSymbols) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            KtClassOrObjectSymbol ktClassOrObjectSymbol = $this$toSymbols.getClassOrObjectSymbolByClassId(this.classId);
            if (ktClassOrObjectSymbol == null) {
                throw new IllegalStateException(("Class " + this.classId + " is not found").toString());
            }
            KtClassOrObjectSymbol symbol = ktClassOrObjectSymbol;
            return CollectionsKt.listOf((Object)symbol);
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final ClassData copy(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new ClassData(classId);
        }

        public static /* synthetic */ ClassData copy$default(ClassData classData, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                classId = classData.classId;
            }
            return classData.copy(classId);
        }

        @NotNull
        public String toString() {
            return "ClassData(classId=" + this.classId + ')';
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassData)) {
                return false;
            }
            ClassData classData = (ClassData)other;
            return Intrinsics.areEqual((Object)this.classId, (Object)classData.classId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$Companion;", "", "()V", "identifiers", "", "", "getIdentifiers", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "data", "analysis-api-impl-base_test"})
    @SourceDebugExtension(value={"SMAP\nSymbolByFqName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolByFqName.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getIdentifiers() {
            return identifiers;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SymbolData create(@NotNull String data) {
            SymbolData symbolData;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (StringsKt.startsWith$default((String)data, (String)"class:", (boolean)false, (int)2, null)) {
                ClassId classId = ClassId.fromString((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)data, (CharSequence)"class:"))).toString());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(...)");
                symbolData = new ClassData(classId);
            } else if (StringsKt.startsWith$default((String)data, (String)"typealias:", (boolean)false, (int)2, null)) {
                ClassId classId = ClassId.fromString((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)data, (CharSequence)"typealias:"))).toString());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(...)");
                symbolData = new TypeAliasData(classId);
            } else if (StringsKt.startsWith$default((String)data, (String)"callable:", (boolean)false, (int)2, null)) {
                FqName fqName;
                String fullName = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)data, (CharSequence)"callable:"))).toString();
                String name = StringsKt.contains$default((CharSequence)fullName, (char)'.', (boolean)false, (int)2, null) ? StringsKt.substringAfterLast$default((String)fullName, (String)".", null, (int)2, null) : StringsKt.substringAfterLast$default((String)fullName, (char)'/', null, (int)2, null);
                Companion $this$create_u24lambda_u240 = this;
                boolean bl = false;
                String packageNameWithClassName = StringsKt.dropLast((String)fullName, (int)(name.length() + 1));
                Pair pair = StringsKt.contains$default((CharSequence)fullName, (char)'.', (boolean)false, (int)2, null) ? TuplesKt.to((Object)StringsKt.substringBeforeLast$default((String)packageNameWithClassName, (char)'/', null, (int)2, null), (Object)StringsKt.substringAfterLast$default((String)packageNameWithClassName, (char)'/', null, (int)2, null)) : TuplesKt.to((Object)packageNameWithClassName, null);
                String packageName = (String)pair.component1();
                String className = (String)pair.component2();
                FqName fqName2 = new FqName(StringsKt.replace$default((String)packageName, (char)'/', (char)'.', (boolean)false, (int)4, null));
                String string = className;
                if (string != null) {
                    void it;
                    packageNameWithClassName = string;
                    FqName fqName3 = fqName2;
                    boolean bl2 = false;
                    fqName = new FqName((String)it);
                    fqName2 = fqName3;
                } else {
                    fqName = null;
                }
                Name name2 = Name.identifier((String)name);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                FqName fqName4 = null;
                Name name3 = name2;
                FqName fqName5 = fqName;
                FqName fqName6 = fqName2;
                CallableId callableId = new CallableId(fqName6, fqName5, name3, fqName4, n, defaultConstructorMarker);
                symbolData = new CallableData(callableId);
            } else {
                throw new IllegalStateException("Invalid symbol".toString());
            }
            return symbolData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData$TypeAliasData;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/SymbolData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "analysis-api-impl-base_test"})
    public static final class TypeAliasData
    extends SymbolData {
        @NotNull
        private final ClassId classId;

        public TypeAliasData(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public List<KtSymbol> toSymbols(@NotNull KtAnalysisSession $this$toSymbols) {
            Intrinsics.checkNotNullParameter((Object)$this$toSymbols, (String)"<this>");
            KtTypeAliasSymbol ktTypeAliasSymbol = $this$toSymbols.getTypeAliasByClassId(this.classId);
            if (ktTypeAliasSymbol == null) {
                throw new IllegalStateException(("Type alias " + this.classId + " is not found").toString());
            }
            KtTypeAliasSymbol symbol = ktTypeAliasSymbol;
            return CollectionsKt.listOf((Object)symbol);
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final TypeAliasData copy(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new TypeAliasData(classId);
        }

        public static /* synthetic */ TypeAliasData copy$default(TypeAliasData typeAliasData, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                classId = typeAliasData.classId;
            }
            return typeAliasData.copy(classId);
        }

        @NotNull
        public String toString() {
            return "TypeAliasData(classId=" + this.classId + ')';
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeAliasData)) {
                return false;
            }
            TypeAliasData typeAliasData = (TypeAliasData)other;
            return Intrinsics.areEqual((Object)this.classId, (Object)typeAliasData.classId);
        }
    }
}

