/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.FileAttributeService;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.DummyFileAttributeService;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.test.ApplicationEnvironmentDisposer;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "()V", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "findClassFileByName", "Lcom/intellij/openapi/vfs/VirtualFile;", "library", "Ljava/nio/file/Path;", "className", "", "getClassFileToDecompile", "testData", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "useStringTable", "", "getClassFileToDecompile$decompiler_to_file_stubs_test", "setUp", "", "registerApplicationServices", "Lcom/intellij/core/CoreApplicationEnvironment;", "decompiler-to-file-stubs_test"})
public abstract class AbstractDecompiledClassTest
extends KotlinTestWithEnvironment {
    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations((Disposable)ApplicationEnvironmentDisposer.Companion.getROOT_DISPOSABLE(), (ConfigurationKind)ConfigurationKind.JDK_NO_RUNTIME);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMoc\u2026.JDK_NO_RUNTIME\n        )");
        return kotlinCoreEnvironment;
    }

    protected void setUp() {
        super.setUp();
        CoreApplicationEnvironment $this$setUp_u24lambda_u240 = this.getEnvironment().getProjectEnvironment().getEnvironment();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$setUp_u24lambda_u240, (String)"setUp$lambda$0");
        this.registerApplicationServices($this$setUp_u24lambda_u240);
    }

    private final void registerApplicationServices(CoreApplicationEnvironment $this$registerApplicationServices) {
        if ($this$registerApplicationServices.getApplication().getService(FileAttributeService.class) == null) {
            $this$registerApplicationServices.registerApplicationService(FileAttributeService.class, (Object)DummyFileAttributeService.INSTANCE);
            $this$registerApplicationServices.registerApplicationService(ClsKotlinBinaryClassCache.class, (Object)new ClsKotlinBinaryClassCache());
        }
    }

    @NotNull
    public final VirtualFile getClassFileToDecompile$decompiler_to_file_stubs_test(@NotNull TestData testData, boolean useStringTable) {
        List list;
        Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
        List $this$getClassFileToDecompile_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getClassFileToDecompile_u24lambda_u241.add("-Xallow-kotlin-package");
        if (useStringTable) {
            $this$getClassFileToDecompile_u24lambda_u241.add("-Xuse-type-table");
        }
        $this$getClassFileToDecompile_u24lambda_u241.addAll((Collection)testData.getAdditionalCompilerOptions());
        List extraOptions = kotlin.collections.CollectionsKt.build((List)list);
        File file = testData.getDirectory().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"testData.directory.toFile()");
        Path library = CompilerTestUtil.compileJvmLibrary$default((File)file, null, (List)extraOptions, null, (int)10, null).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"library");
        return this.findClassFileByName(library, testData.getJvmFileName());
    }

    private final VirtualFile findClassFileByName(Path library, String className) {
        VirtualFileSystem virtualFileSystem = this.getEnvironment().getProjectEnvironment().getEnvironment().getJarFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem");
        CoreJarFileSystem jarFileSystem = (CoreJarFileSystem)virtualFileSystem;
        VirtualFile virtualFile = jarFileSystem.refreshAndFindFileByPath(((Object)library.toAbsolutePath()).toString() + "!/");
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        Set files = new LinkedHashSet();
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, arg_0 -> AbstractDecompiledClassTest.findClassFileByName$lambda$2(className, arg_0), arg_0 -> AbstractDecompiledClassTest.findClassFileByName$lambda$3(files, arg_0));
        return (VirtualFile)kotlin.collections.CollectionsKt.single((Iterable)files);
    }

    private static final boolean findClassFileByName$lambda$2(String $className, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$className, (String)"$className");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return virtualFile.isDirectory() || Intrinsics.areEqual((Object)virtualFile.getName(), (Object)($className + ".class"));
    }

    private static final boolean findClassFileByName$lambda$3(Set $files, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!virtualFile.isDirectory()) {
            CollectionsKt.addIfNotNull((Collection)$files, (Object)virtualFile);
        }
        return true;
    }
}

