/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.references;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.references.AbstractReferenceResolveTest;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/analysis-api/testData/referenceResolve")
@TestDataPath(value="$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated
extends AbstractReferenceResolveTest {
    @Override
    @NotNull
    public AnalysisApiTestConfigurator getConfigurator() {
        AnalysisApiTestConfigurator analysisApiTestConfigurator = AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(new AnalysisApiTestConfiguratorFactoryData(FrontendKind.Fir, TestModuleKind.Source, AnalysisSessionMode.Normal, AnalysisApiMode.Standalone));
        if (analysisApiTestConfigurator == null) {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.$$$reportNull$$$0(0);
        }
        return analysisApiTestConfigurator;
    }

    @Test
    public void testAllFilesPresentInReferenceResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="AnnotationForClass.kt")
    public void testAnnotationForClass() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationForClass.kt");
    }

    @Test
    @TestMetadata(value="AnnotationInsideFunction.kt")
    public void testAnnotationInsideFunction() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationInsideFunction.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnCallSite.kt")
    public void testAnnotationOnCallSite() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnCallSite.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFile.kt")
    public void testAnnotationOnFile() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFile.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFile2.kt")
    public void testAnnotationOnFile2() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFile2.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFileWithImport.kt")
    public void testAnnotationOnFileWithImport() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFileWithImport.kt");
    }

    @Test
    @TestMetadata(value="AnnotationTypeParameter.kt")
    public void testAnnotationTypeParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationTypeParameter.kt");
    }

    @Test
    @TestMetadata(value="ClassInTypeConstraint.kt")
    public void testClassInTypeConstraint() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassInTypeConstraint.kt");
    }

    @Test
    @TestMetadata(value="ClassObjectClassLiteralReference.kt")
    public void testClassObjectClassLiteralReference() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReference.kt");
    }

    @Test
    @TestMetadata(value="ClassObjectClassLiteralReferenceWithField.kt")
    public void testClassObjectClassLiteralReferenceWithField() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReferenceWithField.kt");
    }

    @Test
    @TestMetadata(value="ClassQualifierForNestedClassConstructorCall.kt")
    public void testClassQualifierForNestedClassConstructorCall() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassQualifierForNestedClassConstructorCall.kt");
    }

    @Test
    @TestMetadata(value="ClassReferenceInImport.kt")
    public void testClassReferenceInImport() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassReferenceInImport.kt");
    }

    @Test
    @TestMetadata(value="CompanionObjectWithName1.kt")
    public void testCompanionObjectWithName1() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CompanionObjectWithName1.kt");
    }

    @Test
    @TestMetadata(value="CompanionObjectWithName2.kt")
    public void testCompanionObjectWithName2() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CompanionObjectWithName2.kt");
    }

    @Test
    @TestMetadata(value="CtrlClickResolve.kt")
    public void testCtrlClickResolve() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CtrlClickResolve.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsExtensionReceiverForFunction.kt")
    public void testDefaultObjectAsExtensionReceiverForFunction() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForFunction.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsExtensionReceiverForProperty.kt")
    public void testDefaultObjectAsExtensionReceiverForProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForProperty.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt")
    public void testDefaultObjectAsReceiverForExtensionFunctionOnSuperType() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsReceiverForMemberPropertyInSuperType.kt")
    public void testDefaultObjectAsReceiverForMemberPropertyInSuperType() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForMemberPropertyInSuperType.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectInShortReferenceFormCall.kt")
    public void testDefaultObjectInShortReferenceFormCall() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectInShortReferenceFormCall.kt");
    }

    @Test
    @TestMetadata(value="Deprecated.kt")
    public void testDeprecated() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/Deprecated.kt");
    }

    @Test
    @TestMetadata(value="DestructuringDeclarationInInit.kt")
    public void testDestructuringDeclarationInInit() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DestructuringDeclarationInInit.kt");
    }

    @Test
    @TestMetadata(value="EnumValues.kt")
    public void testEnumValues() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EnumValues.kt");
    }

    @Test
    @TestMetadata(value="EqualsOperator.kt")
    public void testEqualsOperator() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EqualsOperator.kt");
    }

    @Test
    @TestMetadata(value="EqualsOperatorNoInfix.kt")
    public void testEqualsOperatorNoInfix() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EqualsOperatorNoInfix.kt");
    }

    @Test
    @TestMetadata(value="explicitFunctionalInterfaceInvoke_globalVal.kt")
    public void testExplicitFunctionalInterfaceInvoke_globalVal() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_globalVal.kt");
    }

    @Test
    @TestMetadata(value="explicitFunctionalInterfaceInvoke_parameter.kt")
    public void testExplicitFunctionalInterfaceInvoke_parameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_parameter.kt");
    }

    @Test
    @TestMetadata(value="explicitLambdaParameter.kt")
    public void testExplicitLambdaParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata(value="ExternalCompanionObject.kt")
    public void testExternalCompanionObject() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ExternalCompanionObject.kt");
    }

    @Test
    @TestMetadata(value="functionCall.kt")
    public void testFunctionCall() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/functionCall.kt");
    }

    @Test
    @TestMetadata(value="GenericFunctionParameter.kt")
    public void testGenericFunctionParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/GenericFunctionParameter.kt");
    }

    @Test
    @TestMetadata(value="GenericTypeInFunctionParameter.kt")
    public void testGenericTypeInFunctionParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/GenericTypeInFunctionParameter.kt");
    }

    @Test
    @TestMetadata(value="implicitExtensionInvoke.kt")
    public void testImplicitExtensionInvoke() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitExtensionInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitFunctionInvoke.kt")
    public void testImplicitFunctionInvoke() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitFunctionalInterfaceInvoke.kt")
    public void testImplicitFunctionalInterfaceInvoke() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionalInterfaceInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitLambdaParameter.kt")
    public void testImplicitLambdaParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata(value="importAlias.kt")
    public void testImportAlias() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/importAlias.kt");
    }

    @Test
    @TestMetadata(value="ImportFromRootScope.kt")
    public void testImportFromRootScope() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ImportFromRootScope.kt");
    }

    @Test
    @TestMetadata(value="InClassParameter.kt")
    public void testInClassParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InClassParameter.kt");
    }

    @Test
    @TestMetadata(value="InClassParameterField.kt")
    public void testInClassParameterField() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InClassParameterField.kt");
    }

    @Test
    @TestMetadata(value="InEnumEntry.kt")
    public void testInEnumEntry() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InEnumEntry.kt");
    }

    @Test
    @TestMetadata(value="InFunctionParameterType.kt")
    public void testInFunctionParameterType() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InFunctionParameterType.kt");
    }

    @Test
    @TestMetadata(value="InMethodParameter.kt")
    public void testInMethodParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InMethodParameter.kt");
    }

    @Test
    @TestMetadata(value="InMethodVarargParameter.kt")
    public void testInMethodVarargParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InMethodVarargParameter.kt");
    }

    @Test
    @TestMetadata(value="InVaragReferenceInFunctionBody.kt")
    public void testInVaragReferenceInFunctionBody() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInFunctionBody.kt");
    }

    @Test
    @TestMetadata(value="InVaragReferenceInNamedParameter.kt")
    public void testInVaragReferenceInNamedParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInNamedParameter.kt");
    }

    @Test
    @TestMetadata(value="JavaAnnotationParameter.kt")
    public void testJavaAnnotationParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaAnnotationParameter.kt");
    }

    @Test
    @TestMetadata(value="JavaConstructorNotNullParameter.kt")
    public void testJavaConstructorNotNullParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaConstructorNotNullParameter.kt");
    }

    @Test
    @TestMetadata(value="JavaEnumEntry.kt")
    public void testJavaEnumEntry() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaEnumEntry.kt");
    }

    @Test
    @TestMetadata(value="JavaEnumValueOf.kt")
    public void testJavaEnumValueOf() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaEnumValueOf.kt");
    }

    @Test
    @TestMetadata(value="JavaReference.kt")
    public void testJavaReference() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaReference.kt");
    }

    @Test
    @TestMetadata(value="JavaStaticMethod.kt")
    public void testJavaStaticMethod() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JavaStaticMethod.kt");
    }

    @Test
    @TestMetadata(value="KotlinPropertyAssignment.kt")
    public void testKotlinPropertyAssignment() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyAssignment.kt");
    }

    @Test
    @TestMetadata(value="KotlinPropertyWithGetterAndSetterAssignment.kt")
    public void testKotlinPropertyWithGetterAndSetterAssignment() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyWithGetterAndSetterAssignment.kt");
    }

    @Test
    @TestMetadata(value="MultiDeclarationExtension.kt")
    public void testMultiDeclarationExtension() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationExtension.kt");
    }

    @Test
    @TestMetadata(value="MultiDeclarationMember.kt")
    public void testMultiDeclarationMember() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationMember.kt");
    }

    @Test
    @TestMetadata(value="NamedClassObject.kt")
    public void testNamedClassObject() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/NamedClassObject.kt");
    }

    @Test
    @TestMetadata(value="NotEqualsOperator.kt")
    public void testNotEqualsOperator() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/NotEqualsOperator.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFile.kt")
    public void testPackageFromAnnotationOnFile() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFile.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFileWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFileWithUnresolvedReference() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFileWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFunction.kt")
    public void testPackageFromAnnotationOnFunction() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFunction.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFunctionWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFunctionWithUnresolvedReference() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFunctionWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata(value="PackageReference.kt")
    public void testPackageReference() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageReference.kt");
    }

    @Test
    @TestMetadata(value="PackageReferenceInImport.kt")
    public void testPackageReferenceInImport() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageReferenceInImport.kt");
    }

    @Test
    @TestMetadata(value="parameterByName.kt")
    public void testParameterByName() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/parameterByName.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignByHand.kt")
    public void testPlusAssignByHand() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignByHand.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignOperator.kt")
    public void testPlusAssignOperator() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignOperator.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignViaPlusOperator.kt")
    public void testPlusAssignViaPlusOperator() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignViaPlusOperator.kt");
    }

    @Test
    @TestMetadata(value="ReferenceInClassWhereConstraint.kt")
    public void testReferenceInClassWhereConstraint() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInClassWhereConstraint.kt");
    }

    @Test
    @TestMetadata(value="ReferenceInFunWhereConstraint.kt")
    public void testReferenceInFunWhereConstraint() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInFunWhereConstraint.kt");
    }

    @Test
    @TestMetadata(value="ReferenceToSam.kt")
    public void testReferenceToSam() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ReferenceToSam.kt");
    }

    @Test
    @TestMetadata(value="ResolveClass.kt")
    public void testResolveClass() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolveClass.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInProperty.kt")
    public void testResolvePackageInProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheEndInProperty.kt")
    public void testResolvePackageInTheEndInProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheEndInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheMiddleInProperty.kt")
    public void testResolvePackageInTheMiddleInProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheMiddleInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheTypeNameInProperty.kt")
    public void testResolvePackageInTheTypeNameInProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheTypeNameInProperty.kt");
    }

    @Test
    @TestMetadata(value="RetentionValue.kt")
    public void testRetentionValue() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/RetentionValue.kt");
    }

    @Test
    @TestMetadata(value="SamAdapter.kt")
    public void testSamAdapter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamAdapter.kt");
    }

    @Test
    @TestMetadata(value="SamConstructor.kt")
    public void testSamConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamConstructor.kt");
    }

    @Test
    @TestMetadata(value="SamConstructorTypeArguments.kt")
    public void testSamConstructorTypeArguments() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamConstructorTypeArguments.kt");
    }

    @Test
    @TestMetadata(value="SeveralOverrides.kt")
    public void testSeveralOverrides() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SeveralOverrides.kt");
    }

    @Test
    @TestMetadata(value="smartCastExpression.kt")
    public void testSmartCastExpression() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/smartCastExpression.kt");
    }

    @Test
    @TestMetadata(value="smartCastInvokeReceiver.kt")
    public void testSmartCastInvokeReceiver() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/smartCastInvokeReceiver.kt");
    }

    @Test
    @TestMetadata(value="SuperTypePrimaryConstructor.kt")
    public void testSuperTypePrimaryConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SuperTypePrimaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="SuperTypeSecondaryConstructor.kt")
    public void testSuperTypeSecondaryConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SuperTypeSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="superWithLabel_caretAtLabel.kt")
    public void testSuperWithLabel_caretAtLabel() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="superWithLabel_caretAtSuper.kt")
    public void testSuperWithLabel_caretAtSuper() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtSuper.kt");
    }

    @Test
    @TestMetadata(value="SyntheticProperty.kt")
    public void testSyntheticProperty() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SyntheticProperty.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToFunction_caretAtLabel.kt")
    public void testThisWithLabelToFunction_caretAtLabel() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToFunction_caretAtThis.kt")
    public void testThisWithLabelToFunction_caretAtThis() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtThis.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToProperty_caretAtLabel.kt")
    public void testThisWithLabelToProperty_caretAtLabel() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToProperty_caretAtThis.kt")
    public void testThisWithLabelToProperty_caretAtThis() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtThis.kt");
    }

    @Test
    @TestMetadata(value="todo.kt")
    public void testTodo() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/todo.kt");
    }

    @Test
    @TestMetadata(value="TopLevelClassVsLocalClassConstructor.kt")
    public void testTopLevelClassVsLocalClassConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelClassVsLocalClassConstructor2.kt")
    public void testTopLevelClassVsLocalClassConstructor2() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassConstructor.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassConstructor2.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor2() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassQualifier.kt")
    public void testTopLevelCompanionObjectVsLocalClassQualifier() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor.kt")
    public void testTopLevelObjectVsLocalClassConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor2.kt")
    public void testTopLevelObjectVsLocalClassConstructor2() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor3.kt")
    public void testTopLevelObjectVsLocalClassConstructor3() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor3.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor4.kt")
    public void testTopLevelObjectVsLocalClassConstructor4() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor4.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassQualifier.kt")
    public void testTopLevelObjectVsLocalClassQualifier() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata(value="TypeAlias.kt")
    public void testTypeAlias() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAlias.kt");
    }

    @Test
    @TestMetadata(value="TypeAliasAsSupertypeConstructor.kt")
    public void testTypeAliasAsSupertypeConstructor() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasAsSupertypeConstructor.kt");
    }

    @Test
    @TestMetadata(value="TypeAliasRHS.kt")
    public void testTypeAliasRHS() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasRHS.kt");
    }

    @Test
    @TestMetadata(value="ValueParameter.kt")
    public void testValueParameter() throws Exception {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ValueParameter.kt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/generated/cases/references/FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated", "getConfigurator"));
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/withErrors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithErrors {
        @Test
        public void testAllFilesPresentInWithErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="AnnotationParameter.kt")
        public void testAnnotationParameter() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/AnnotationParameter.kt");
        }

        @Test
        @TestMetadata(value="ByReturnExpression.kt")
        public void testByReturnExpression() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ByReturnExpression.kt");
        }

        @Test
        @TestMetadata(value="ClassNameBeforeDot.kt")
        public void testClassNameBeforeDot() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ClassNameBeforeDot.kt");
        }

        @Test
        @TestMetadata(value="CollectionLiteralLeft.kt")
        public void testCollectionLiteralLeft() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralLeft.kt");
        }

        @Test
        @TestMetadata(value="CollectionLiteralRight.kt")
        public void testCollectionLiteralRight() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralRight.kt");
        }

        @Test
        @TestMetadata(value="CoroutineSuspensionPoint.kt")
        public void testCoroutineSuspensionPoint() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CoroutineSuspensionPoint.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotations.kt")
        public void testDanglingAnnotations() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/DanglingAnnotations.kt");
        }

        @Test
        @TestMetadata(value="DeprecatedHidden.kt")
        public void testDeprecatedHidden() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/DeprecatedHidden.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang1.kt")
        public void testFakeJavaLang1() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang1.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang2.kt")
        public void testFakeJavaLang2() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang2.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang3.kt")
        public void testFakeJavaLang3() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang3.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang4.kt")
        public void testFakeJavaLang4() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang4.kt");
        }

        @Test
        @TestMetadata(value="InObjectClassObject.kt")
        public void testInObjectClassObject() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InObjectClassObject.kt");
        }

        @Test
        @TestMetadata(value="InSecondClassObject.kt")
        public void testInSecondClassObject() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InSecondClassObject.kt");
        }

        @Test
        @TestMetadata(value="InvisibleMember.kt")
        public void testInvisibleMember() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InvisibleMember.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInDotQualifiedCall.kt")
        public void testNoSelectorInDotQualifiedCall() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt")
        public void testNoSelectorInDotQualifiedCall_ResolveInsideLambda() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInSafeQualifiedCall.kt")
        public void testNoSelectorInSafeQualifiedCall() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInSafeQualifiedCall.kt");
        }

        @Test
        @TestMetadata(value="PropertyPlaceInClassObjectInObject.kt")
        public void testPropertyPlaceInClassObjectInObject() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/PropertyPlaceInClassObjectInObject.kt");
        }

        @Test
        @TestMetadata(value="ResolveClassNameInCallExpression.kt")
        public void testResolveClassNameInCallExpression() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ResolveClassNameInCallExpression.kt");
        }

        @Test
        @TestMetadata(value="TopLevelClassVsLocalClassQualifier.kt")
        public void testTopLevelClassVsLocalClassQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TopLevelClassVsLocalClassQualifier.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentBeforeDot2.kt")
        public void testTypeArgumentBeforeDot2() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentBeforeDot2.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentUnresolvedClass.kt")
        public void testTypeArgumentUnresolvedClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedClass.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentUnresolvedConstructor.kt")
        public void testTypeArgumentUnresolvedConstructor() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedConstructor.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentWrongNumber.kt")
        public void testTypeArgumentWrongNumber() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentWrongNumber.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments.kt")
        public void testWrongNumberOfTypeArguments() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments2.kt")
        public void testWrongNumberOfTypeArguments2() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments2.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments3.kt")
        public void testWrongNumberOfTypeArguments3() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments3.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments4.kt")
        public void testWrongNumberOfTypeArguments4() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments4.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArgumentsInSupertype.kt")
        public void testWrongNumberOfTypeArgumentsInSupertype() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArgumentsInSupertype.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeParameter")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeParameter {
        @Test
        public void testAllFilesPresentInTypeParameter() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeParameter"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="multipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/multipleBounds.kt");
        }

        @Test
        @TestMetadata(value="reified_argumentInFunctionalType.kt")
        public void testReified_argumentInFunctionalType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_argumentInFunctionalType.kt");
        }

        @Test
        @TestMetadata(value="reified_extensionReceiver.kt")
        public void testReified_extensionReceiver() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_extensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="reified_returnType.kt")
        public void testReified_returnType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_returnType.kt");
        }

        @Test
        @TestMetadata(value="reified_valueParameter.kt")
        public void testReified_valueParameter() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter.kt");
        }

        @Test
        @TestMetadata(value="reified_valueParameter_vararg.kt")
        public void testReified_valueParameter_vararg() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter_vararg.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInAnonymousObject.kt")
        public void testTypeParameterInAnonymousObject() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInAnonymousObject.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInFunctionLiteral.kt")
        public void testTypeParameterInFunctionLiteral() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInFunctionLiteral.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeArgument {
        @Test
        public void testAllFilesPresentInTypeArgument() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/type")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Type {
            @Test
            public void testAllFilesPresentInType() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/type"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="beforeDot.kt")
            public void testBeforeDot() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/type/beforeDot.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess")
        @TestDataPath(value="$PROJECT_ROOT")
        public class PropertyAccess {
            @Test
            public void testAllFilesPresentInPropertyAccess() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="localVariable1.kt")
            public void testLocalVariable1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/localVariable1.kt");
            }

            @Test
            @TestMetadata(value="localVariable2.kt")
            public void testLocalVariable2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/localVariable2.kt");
            }

            @Test
            @TestMetadata(value="parameter1.kt")
            public void testParameter1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/parameter1.kt");
            }

            @Test
            @TestMetadata(value="parameter2.kt")
            public void testParameter2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/parameter2.kt");
            }

            @Test
            @TestMetadata(value="property1.kt")
            public void testProperty1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/property1.kt");
            }

            @Test
            @TestMetadata(value="property2.kt")
            public void testProperty2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/property2.kt");
            }

            @Test
            @TestMetadata(value="propertyWithGetter1.kt")
            public void testPropertyWithGetter1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/propertyWithGetter1.kt");
            }

            @Test
            @TestMetadata(value="propertyWithGetter2.kt")
            public void testPropertyWithGetter2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/propertyWithGetter2.kt");
            }

            @Test
            @TestMetadata(value="unresolvedProperty.kt")
            public void testUnresolvedProperty() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/unresolvedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionCall {
            @Test
            public void testAllFilesPresentInFunctionCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments1.kt")
            public void testTooFewTypeArguments1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments1.kt");
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments1a.kt")
            public void testTooFewTypeArguments1a() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments1a.kt");
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments2.kt")
            public void testTooFewTypeArguments2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments2.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments1.kt")
            public void testTooManyTypeArguments1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments1.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments1a.kt")
            public void testTooManyTypeArguments1a() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments1a.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments2.kt")
            public void testTooManyTypeArguments2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments2.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments2a.kt")
            public void testTooManyTypeArguments2a() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments2a.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCallee1.kt")
            public void testUnresolvedCallee1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCallee1.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCallee2.kt")
            public void testUnresolvedCallee2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCallee2.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCalleeWithArguments1.kt")
            public void testUnresolvedCalleeWithArguments1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCalleeWithArguments1.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCalleeWithArguments2.kt")
            public void testUnresolvedCalleeWithArguments2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCalleeWithArguments2.kt");
            }

            @Test
            @TestMetadata(value="upperBound1.kt")
            public void testUpperBound1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/upperBound1.kt");
            }

            @Test
            @TestMetadata(value="upperBound2.kt")
            public void testUpperBound2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/upperBound2.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/constant")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constant {
            @Test
            public void testAllFilesPresentInConstant() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/constant"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="false.kt")
            public void testFalse() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/false.kt");
            }

            @Test
            @TestMetadata(value="true.kt")
            public void testTrue() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/true.kt");
            }

            @Test
            @TestMetadata(value="trueCall.kt")
            public void testTrueCall() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/trueCall.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/qualifiedAccess")
    @TestDataPath(value="$PROJECT_ROOT")
    public class QualifiedAccess {
        @Test
        public void testAllFilesPresentInQualifiedAccess() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/qualifiedAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="callableReference1.kt")
        public void testCallableReference1() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference1.kt");
        }

        @Test
        @TestMetadata(value="callableReference2.kt")
        public void testCallableReference2() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference2.kt");
        }

        @Test
        @TestMetadata(value="callableReference3.kt")
        public void testCallableReference3() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference3.kt");
        }

        @Test
        @TestMetadata(value="nullSafeCallExpression.kt")
        public void testNullSafeCallExpression() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/nullSafeCallExpression.kt");
        }

        @Test
        @TestMetadata(value="ResolveFirstPackageOfFullyQualifiedReference.kt")
        public void testResolveFirstPackageOfFullyQualifiedReference() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFirstPackageOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata(value="ResolveFullyQualifiedCompanionObject.kt")
        public void testResolveFullyQualifiedCompanionObject() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFullyQualifiedCompanionObject.kt");
        }

        @Test
        @TestMetadata(value="ResolveOuterClassOfFullyQualifiedReference.kt")
        public void testResolveOuterClassOfFullyQualifiedReference() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveOuterClassOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata(value="ResolvePackageOfFullyQualifiedReference.kt")
        public void testResolvePackageOfFullyQualifiedReference() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolvePackageOfFullyQualifiedReference.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/packageReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class PackageReference {
        @Test
        public void testAllFilesPresentInPackageReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/packageReference"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageSecondQualifier.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/nestedTypes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NestedTypes {
        @Test
        public void testAllFilesPresentInNestedTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/nestedTypes"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="ResolveCompanionInCompanionType.kt")
        public void testResolveCompanionInCompanionType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveEndOfPackageInType.kt")
        public void testResolveEndOfPackageInType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveEndOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveMiddleOfPackageInType.kt")
        public void testResolveMiddleOfPackageInType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveMiddleOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveNamedCompanionInCompanionType.kt")
        public void testResolveNamedCompanionInCompanionType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveNamedCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveStartOfPackageInType.kt")
        public void testResolveStartOfPackageInType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveStartOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheEndOfType.kt")
        public void testResolveTypeInTheEndOfType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheEndOfType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfCompanionType.kt")
        public void testResolveTypeInTheMiddleOfCompanionType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfFunctionalType.kt")
        public void testResolveTypeInTheMiddleOfFunctionalType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfFunctionalType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfNullableType.kt")
        public void testResolveTypeInTheMiddleOfNullableType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfNullableType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfType.kt")
        public void testResolveTypeInTheMiddleOfType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheStartOfCompanionType.kt")
        public void testResolveTypeInTheStartOfCompanionType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheStartOfType.kt")
        public void testResolveTypeInTheStartOfType() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc")
    @TestDataPath(value="$PROJECT_ROOT")
    public class KDoc {
        @Test
        public void testAllFilesPresentInKDoc() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Qualified {
            @Test
            public void testAllFilesPresentInQualified() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Stdlib {
                @Test
                public void testAllFilesPresentInStdlib() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="EnumEntryFromStdlibByFullName.kt")
                public void testEnumEntryFromStdlibByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/EnumEntryFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="EnumEntryFromStdlibByShortName.kt")
                public void testEnumEntryFromStdlibByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/EnumEntryFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromStdlibByFullName.kt")
                public void testTopLevelClassFromStdlibByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelClassFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromStdlibByShortName.kt")
                public void testTopLevelClassFromStdlibByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelClassFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByFullName.kt")
                public void testTopLevelFunctionFromStdlibByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByShortName.kt")
                public void testTopLevelFunctionFromStdlibByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByShortName.kt");
                }
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromOtherFile {
                @Test
                public void testAllFilesPresentInFromOtherFile() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="EnumEntryFromOtherByShortName.kt")
                public void testEnumEntryFromOtherByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/EnumEntryFromOtherByShortName.kt");
                }

                @Test
                @TestMetadata(value="EnumEntryFromOtherFileByFullName.kt")
                public void testEnumEntryFromOtherFileByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/EnumEntryFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="NestedClassFromOtherFileByFullName.kt")
                public void testNestedClassFromOtherFileByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="NestedClassFromOtherFileByShortName.kt")
                public void testNestedClassFromOtherFileByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromOtherFileByFullName.kt")
                public void testTopLevelClassFromOtherFileByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromOtherFileByShortName.kt")
                public void testTopLevelClassFromOtherFileByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromOtherFileByFullName.kt")
                public void testTopLevelFunctionFromOtherFileByFullName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelFunctionFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByShortName.kt")
                public void testTopLevelFunctionFromStdlibByShortName() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelFunctionFromStdlibByShortName.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/parameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Parameters {
            @Test
            public void testAllFilesPresentInParameters() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/parameters"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="ClassPrimaryConstructorParameter.kt")
            public void testClassPrimaryConstructorParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassPrimaryConstructorParameter.kt");
            }

            @Test
            @TestMetadata(value="ClassPrimaryConstructorValParameter.kt")
            public void testClassPrimaryConstructorValParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassPrimaryConstructorValParameter.kt");
            }

            @Test
            @TestMetadata(value="ClassTypeParameter.kt")
            public void testClassTypeParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="ConstructorValueParameter.kt")
            public void testConstructorValueParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ConstructorValueParameter.kt");
            }

            @Test
            @TestMetadata(value="FunctionTypeParameter.kt")
            public void testFunctionTypeParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/FunctionTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="FunctionValueParameter.kt")
            public void testFunctionValueParameter() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/FunctionValueParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/localContext")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalContext {
            @Test
            public void testAllFilesPresentInLocalContext() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/localContext"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="LocalSemiFullQualifiedCallableName.kt")
            public void testLocalSemiFullQualifiedCallableName() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/LocalSemiFullQualifiedCallableName.kt");
            }

            @Test
            @TestMetadata(value="LocalSemiFullQualifiedClassName.kt")
            public void testLocalSemiFullQualifiedClassName() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/LocalSemiFullQualifiedClassName.kt");
            }

            @Test
            @TestMetadata(value="NonLocalSemiFullQualifiedCallableName.kt")
            public void testNonLocalSemiFullQualifiedCallableName() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/NonLocalSemiFullQualifiedCallableName.kt");
            }

            @Test
            @TestMetadata(value="NonLocalSemiFullQualifiedClassName.kt")
            public void testNonLocalSemiFullQualifiedClassName() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/NonLocalSemiFullQualifiedClassName.kt");
            }

            @Test
            @TestMetadata(value="SelfLocalMethod.kt")
            public void testSelfLocalMethod() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SelfLocalProperty.kt")
            public void testSelfLocalProperty() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalEnumEntry.kt")
            public void testSelfNonLocalEnumEntry() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalEnumEntry.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalMethod.kt")
            public void testSelfNonLocalMethod() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalProperty.kt")
            public void testSelfNonLocalProperty() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SiblingLocalMethod.kt")
            public void testSiblingLocalMethod() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SiblingLocalProperty.kt")
            public void testSiblingLocalProperty() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SiblingNonLocalProperty.kt")
            public void testSiblingNonLocalProperty() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingNonLocalProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/imports")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Imports {
            @Test
            public void testAllFilesPresentInImports() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/imports"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="TypeAliasedImport.kt")
            public void testTypeAliasedImport() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/imports/TypeAliasedImport.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Invoke {
        @Test
        public void testAllFilesPresentInInvoke() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="lambdaAndParens.kt")
        public void testLambdaAndParens() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaAndParens.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoPar.kt")
        public void testLambdaNoPar() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoPar.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoParLabel.kt")
        public void testLambdaNoParLabel() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParLabel.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoParRCurly.kt")
        public void testLambdaNoParRCurly() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParRCurly.kt");
        }

        @Test
        @TestMetadata(value="noParams.kt")
        public void testNoParams() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParams.kt");
        }

        @Test
        @TestMetadata(value="noParamsRPar.kt")
        public void testNoParamsRPar() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParamsRPar.kt");
        }

        @Test
        @TestMetadata(value="nonemptyLambdaRPar.kt")
        public void testNonemptyLambdaRPar() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/nonemptyLambdaRPar.kt");
        }

        @Test
        @TestMetadata(value="oneParam.kt")
        public void testOneParam() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParam.kt");
        }

        @Test
        @TestMetadata(value="oneParamRPar.kt")
        public void testOneParamRPar() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParamRPar.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaAndParensIncorrectVararg.kt")
            public void testLambdaAndParensIncorrectVararg() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaAndParensIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParIncorrectVararg.kt")
            public void testLambdaNoParIncorrectVararg() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParLabelIncorrectVararg.kt")
            public void testLambdaNoParLabelIncorrectVararg() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParLabelIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParRCurlyIncorrectVararg.kt")
            public void testLambdaNoParRCurlyIncorrectVararg() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParRCurlyIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="nonemptyLambdaRParIncorrectVararg.kt")
            public void testNonemptyLambdaRParIncorrectVararg() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/nonemptyLambdaRParIncorrectVararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke/onObjects")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OnObjects {
            @Test
            public void testAllFilesPresentInOnObjects() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke/onObjects"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="companionObject1.kt")
            public void testCompanionObject1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObject1.kt");
            }

            @Test
            @TestMetadata(value="companionObject2.kt")
            public void testCompanionObject2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObject2.kt");
            }

            @Test
            @TestMetadata(value="companionObjectWithName1.kt")
            public void testCompanionObjectWithName1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObjectWithName1.kt");
            }

            @Test
            @TestMetadata(value="companionObjectWithName2.kt")
            public void testCompanionObjectWithName2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObjectWithName2.kt");
            }

            @Test
            @TestMetadata(value="nestedObject1.kt")
            public void testNestedObject1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject1.kt");
            }

            @Test
            @TestMetadata(value="nestedObject2.kt")
            public void testNestedObject2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject2.kt");
            }

            @Test
            @TestMetadata(value="nestedObject3.kt")
            public void testNestedObject3() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject3.kt");
            }

            @Test
            @TestMetadata(value="nestedObject4.kt")
            public void testNestedObject4() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject4.kt");
            }

            @Test
            @TestMetadata(value="simpleObject1.kt")
            public void testSimpleObject1() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/simpleObject1.kt");
            }

            @Test
            @TestMetadata(value="simpleObject2.kt")
            public void testSimpleObject2() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/simpleObject2.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/inImport")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InImport {
        @Test
        public void testAllFilesPresentInInImport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/inImport"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="javaClass.kt")
        public void testJavaClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaClass.kt");
        }

        @Test
        @TestMetadata(value="javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinClass.kt")
        public void testKotlinClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinClass.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinTopLevelFunction.kt")
        public void testKotlinTopLevelFunction() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinTopLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="staticMethodFromJavaClass.kt")
        public void testStaticMethodFromJavaClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClass.kt");
        }

        @Test
        @TestMetadata(value="staticMethodFromJavaClassJavaClass.kt")
        public void testStaticMethodFromJavaClassJavaClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClassJavaClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ForLoopIn {
        @Test
        public void testAllFilesPresentInForLoopIn() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="unresolvedIterator.kt")
            public void testUnresolvedIterator() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors/unresolvedIterator.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InSource {
            @Test
            @TestMetadata(value="allExtensions.kt")
            public void testAllExtensions() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allExtensions.kt");
            }

            @Test
            public void testAllFilesPresentInInSource() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="allMembers.kt")
            public void testAllMembers() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allMembers.kt");
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors")
            @TestDataPath(value="$PROJECT_ROOT")
            public class WithErrors {
                @Test
                public void testAllFilesPresentInWithErrors() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="nextMissing.kt")
                public void testNextMissing() throws Exception {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors/nextMissing.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InLibrary {
            @Test
            public void testAllFilesPresentInInLibrary() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary/extension.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InBuiltIns {
            @Test
            public void testAllFilesPresentInInBuiltIns() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/extension.kt");
            }

            @Test
            @TestMetadata(value="member.kt")
            public void testMember() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/member.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DelegatedPropertyAccessors {
        @Test
        public void testAllFilesPresentInDelegatedPropertyAccessors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="unresolved.kt")
            public void testUnresolved() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors/unresolved.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InStandardLibrary {
            @Test
            public void testAllFilesPresentInInStandardLibrary() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/lazy.kt");
            }

            @Test
            @TestMetadata(value="notNull.kt")
            public void testNotNull() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/notNull.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InSource {
            @Test
            public void testAllFilesPresentInInSource() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="getExtension.kt")
            public void testGetExtension() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getExtension.kt");
            }

            @Test
            @TestMetadata(value="getMember.kt")
            public void testGetMember() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMember.kt");
            }

            @Test
            @TestMetadata(value="getMultipleDeclarations.kt")
            public void testGetMultipleDeclarations() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMultipleDeclarations.kt");
            }

            @Test
            @TestMetadata(value="getOneFakeOverride.kt")
            public void testGetOneFakeOverride() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getOneFakeOverride.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/danglingAnnotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DanglingAnnotations {
        @Test
        public void testAllFilesPresentInDanglingAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/danglingAnnotations"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedAnonymous.kt")
        public void testDanglingAnnotationsResolvedAnonymous() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedAnonymous.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedClass.kt")
        public void testDanglingAnnotationsResolvedClass() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedClass.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedFile.kt")
        public void testDanglingAnnotationsResolvedFile() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedFile.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedLocal.kt")
        public void testDanglingAnnotationsResolvedLocal() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedLocal.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedPackageFile.kt")
        public void testDanglingAnnotationsResolvedPackageFile() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedPackageFile.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedTopLevel.kt")
        public void testDanglingAnnotationsResolvedTopLevel() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedTopLevel.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstructorDelegatingReference {
        @Test
        public void testAllFilesPresentInConstructorDelegatingReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="toPrimary.kt")
        public void testToPrimary() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toPrimary.kt");
        }

        @Test
        @TestMetadata(value="toSecondary.kt")
        public void testToSecondary() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toSecondary.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/arrayAccess")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ArrayAccess {
        @Test
        public void testAllFilesPresentInArrayAccess() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/arrayAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="get.kt")
        public void testGet() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/get.kt");
        }

        @Test
        @TestMetadata(value="getOperator.kt")
        public void testGetOperator() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/getOperator.kt");
        }

        @Test
        @TestMetadata(value="set.kt")
        public void testSet() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/set.kt");
        }

        @Test
        @TestMetadata(value="setOperator.kt")
        public void testSetOperator() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/setOperator.kt");
        }

        @Test
        @TestMetadata(value="SetOperatorInc.kt")
        public void testSetOperatorInc() throws Exception {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/SetOperatorInc.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="getFunction.kt")
            public void testGetFunction() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/getFunction.kt");
            }

            @Test
            @TestMetadata(value="setFunction.kt")
            public void testSetFunction() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/setFunction.kt");
            }

            @Test
            @TestMetadata(value="SetOperatorInc.kt")
            public void testSetOperatorInc() throws Exception {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/SetOperatorInc.kt");
            }
        }
    }
}

