/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompilerExecutor;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "", "()V", "addFileToJar", "", "path", "", "text", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "compileTestModuleToLibrary", "Ljava/nio/file/Path;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compileTestModuleToLibrarySources", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleCompiler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class TestModuleCompiler {
    @NotNull
    public static final TestModuleCompiler INSTANCE = new TestModuleCompiler();

    private TestModuleCompiler() {
    }

    @NotNull
    public final Path compileTestModuleToLibrary(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Path tmpDir = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
        for (TestFile testFile : module.getFiles()) {
            Path tmpSourceFile;
            String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            Path path = tmpDir.resolve(testFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(this, *attributes)");
            PathsKt.writeText$default((Path)tmpSourceFile, (CharSequence)text2, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        return CompilerExecutor.INSTANCE.compileLibrary(tmpDir, CompilerExecutor.INSTANCE.parseCompilerOptionsFromTestdata(module), module.getDirectives().contains((Directive)CompilerExecutor.Directives.INSTANCE.getCOMPILATION_ERRORS()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path compileTestModuleToLibrarySources(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Path tmpDir = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        Path path = tmpDir.resolve("library-sources.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path librarySourcesPath = path;
        Object object = new Manifest();
        Manifest $this$compileTestModuleToLibrarySources_u24lambda_u240 = object;
        boolean bl = false;
        Attributes attributes = $this$compileTestModuleToLibrarySources_u24lambda_u240.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"mainAttributes");
        Map map = attributes;
        Attributes.Name name = Attributes.Name.MANIFEST_VERSION;
        String string = "1.0";
        map.put(name, string);
        Manifest manifest = object;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(librarySourcesPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
        object = new JarOutputStream(outputStream, manifest);
        Throwable throwable = null;
        try {
            JarOutputStream jarOutputStream = (JarOutputStream)object;
            boolean bl2 = false;
            for (TestFile testFile : module.getFiles()) {
                String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
                INSTANCE.addFileToJar(testFile.getRelativePath(), text2, jarOutputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return librarySourcesPath;
    }

    private final void addFileToJar(String path, String text2, JarOutputStream jarOutputStream) {
        jarOutputStream.putNextEntry(new JarEntry(path));
        String string = text2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)jarOutputStream, (int)0, (int)2, null);
        jarOutputStream.closeEntry();
    }
}

