/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractStubBuilderTestKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractStubBuilderTest;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "()V", "doTest", "", "testData", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "useStringTable", "", "getStubToTest", "Lcom/intellij/psi/stubs/PsiFileStub;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "runTest", "testDirectory", "", "testClsStubsForFile", "decompiler-to-file-stubs_test"})
public abstract class AbstractStubBuilderTest
extends AbstractDecompiledClassTest {
    public final void runTest(@NotNull String testDirectory) {
        Intrinsics.checkNotNullParameter((Object)testDirectory, (String)"testDirectory");
        Path testDirectoryPath = Paths.get(testDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)testDirectoryPath, (String)"testDirectoryPath");
        TestData testData = TestData.Companion.createFromDirectory(testDirectoryPath);
        this.doTest(testData, true);
        this.doTest(testData, false);
    }

    private final void doTest(TestData testData, boolean useStringTable) {
        VirtualFile classFile = this.getClassFileToDecompile$decompiler_to_file_stubs_test(testData, useStringTable);
        this.testClsStubsForFile(classFile, testData);
    }

    private final void testClsStubsForFile(VirtualFile classFile, TestData testData) {
        KotlinTestUtils.assertEqualsToFile((Path)testData.getExpectedFile(), (String)AbstractStubBuilderTestKt.access$serializeToString((StubElement)this.getStubToTest(classFile)));
    }

    @NotNull
    protected abstract PsiFileStub<?> getStubToTest(@NotNull VirtualFile var1);
}

