/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.FirIdeDirectives;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.TestWithFirIdeIgnoreAnnotationPassesException;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/IdeTestIgnoreHandler;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "isFirIdeIgnoreDirectivePresent", "", "suppressIfNeeded", "Companion", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nIdeTestIgnoreHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeTestIgnoreHandler.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/IdeTestIgnoreHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n766#2:74\n857#2,2:75\n*S KotlinDebug\n*F\n+ 1 IdeTestIgnoreHandler.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/IdeTestIgnoreHandler\n*L\n50#1:74\n50#1:75,2\n*E\n"})
public final class IdeTestIgnoreHandler
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    public IdeTestIgnoreHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)((Object)FirIdeDirectives.INSTANCE));
    }

    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!this.isFirIdeIgnoreDirectivePresent()) {
            return;
        }
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first((List)TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getOriginalTestDataFiles());
        if (!isTeamCityBuild) {
            FileUtilsKt.removeDirectiveFromFile((File)testDataFile, (Directive)((Directive)FirIdeDirectives.INSTANCE.getFIR_IDE_IGNORE()));
        }
        String message2 = isTeamCityBuild ? "Please remove // " + FirIdeDirectives.INSTANCE.getFIR_IDE_IGNORE() + " from the test source" : "Removed // " + FirIdeDirectives.INSTANCE.getFIR_IDE_IGNORE() + " from the test source";
        throw new TestWithFirIdeIgnoreAnnotationPassesException(StringsKt.trimIndent((String)("\n                    Test pass in FIR IDE\n                    " + message2 + "\n                    Please re-run the test now\n                ")));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        List list;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (this.isFirIdeIgnoreDirectivePresent()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = failedAssertions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WrappedException it = (WrappedException)element$iv$iv;
                boolean bl = false;
                if (!(it.getCause() instanceof TestWithFirIdeIgnoreAnnotationPassesException)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = failedAssertions;
        }
        return list;
    }

    private final boolean isFirIdeIgnoreDirectivePresent() {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices());
        return moduleStructure.getAllDirectives().contains((Directive)FirIdeDirectives.INSTANCE.getFIR_IDE_IGNORE());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/IdeTestIgnoreHandler$Companion;", "", "()V", "isTeamCityBuild", "", "low-level-api-fir_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

