/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.LLFirDivergenceUtilsKt;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirDivergenceCommentChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "check", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "low-level-api-fir_test"})
public final class LLFirDivergenceCommentChecker
extends AfterAnalysisChecker {
    public LLFirDivergenceCommentChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        File testDataFile = (File)CollectionsKt.first((List)TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getOriginalTestDataFiles());
        if (!CustomTestDataUtilsKt.isLLFirTestData((File)testDataFile)) {
            return;
        }
        if (!LLFirDivergenceUtilsKt.hasLlFirDivergenceDirective(testDataFile)) {
            AssertionsKt.getAssertions((TestServices)this.getTestServices()).fail((Function0)new Function0<String>(testDataFile){
                final /* synthetic */ File $testDataFile;
                {
                    this.$testDataFile = $testDataFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return StringsKt.trimMargin$default((String)("The LL FIR test data file `" + this.$testDataFile.getName() + "` is missing an `LL_FIR_DIVERGENCE` directive. At the beginning of the \n                  |file, add the following directive:\n                  |\n                  |// LL_FIR_DIVERGENCE\n                  |// A comment describing why the LL FIR result is diverging from the compiler result. You must provide a good reason, or\n                  |// otherwise the divergence is probably a bug in LL FIR which needs to be fixed. Try to be as specific as possible.\n                  |// LL_FIR_DIVERGENCE\n                  |"), null, (int)1, null);
                }
            });
            throw null;
        }
    }
}

