/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.gradle.api.logging.Logger;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.CustomHttpRequestRetryStrategy;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.DebugInterceptor;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal.StripPortsFromHostInterceptor;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.config.ConnectionConfig;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.config.Registry;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.config.RegistryBuilder;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.TimeValue;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate, int retries, int connectTimeoutMs, Map<String, String> headers, Logger logger, boolean quiet) {
        PoolingHttpClientConnectionManager cm;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (retries == 0) {
            builder.disableAutomaticRetries();
        } else {
            int maxRetries = retries;
            if (retries < 0) {
                maxRetries = Integer.MAX_VALUE;
            }
            builder.setRetryStrategy(new CustomHttpRequestRetryStrategy(maxRetries, TimeValue.ofSeconds(0L), logger, quiet));
        }
        builder.setRoutePlanner(new SystemDefaultRoutePlanner(null));
        if ("https".equals(httpHost.getSchemeName()) && acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", icsf).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
            cm = new PoolingHttpClientConnectionManager(registry);
        } else {
            cm = PoolingHttpClientConnectionManagerBuilder.create().build();
        }
        cm.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(connectTimeoutMs)).build());
        builder.setConnectionManager(cm);
        builder.addRequestInterceptorLast(new StripPortsFromHostInterceptor(headers));
        if (logger.isDebugEnabled()) {
            DebugInterceptor di = new DebugInterceptor();
            builder.addExecInterceptorLast("debug-interceptor", di);
            builder.addResponseInterceptorFirst(di);
        }
        return builder.build();
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

