/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.support;

import java.io.IOException;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Contract;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ClassicHttpRequest;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ClassicHttpResponse;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpException;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequestMapper;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponseFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.HttpFilterChain;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.HttpFilterHandler;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.HttpRequestHandler;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalServerFilter
implements HttpFilterHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public TerminalServerFilter(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Override
    public void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler handler = this.handlerMapper.resolve(request, context);
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

