/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.preview.tasks;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.preview.tasks.AbstractConfigureDesktopPreviewTask;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHostConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnectionKt;
import org.jetbrains.compose.internal.utils.GradleUtilsKt;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0007J\r\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\"J\u0012\u0010#\u001a\u00020\t*\b\u0012\u0004\u0012\u00020%0$H\u0002R\u0016\u0010\u0003\u001a\u00020\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00118AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u00020\u00048AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u001c\u0010\u001a\u001a\u00020\u00048AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\u0017R\u0016\u0010\u001d\u001a\u00020\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006\u00a8\u0006'"}, d2={"Lorg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "hostClasspath", "Lorg/gradle/api/file/FileCollection;", "getHostClasspath$compose", "()Lorg/gradle/api/file/FileCollection;", "idePort", "Lorg/gradle/api/provider/Provider;", "", "getIdePort$compose", "()Lorg/gradle/api/provider/Provider;", "javaHome", "Lorg/gradle/api/provider/Property;", "getJavaHome$compose", "()Lorg/gradle/api/provider/Property;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "getJvmArgs$compose", "()Lorg/gradle/api/provider/ListProperty;", "previewClasspath", "getPreviewClasspath$compose", "setPreviewClasspath$compose", "(Lorg/gradle/api/file/FileCollection;)V", "previewTarget", "getPreviewTarget$compose", "skikoRuntime", "getSkikoRuntime$compose", "setSkikoRuntime$compose", "uiTooling", "getUiTooling$compose", "run", "", "tryGetSkikoRuntimeIfNeeded", "tryGetSkikoRuntimeIfNeeded$compose", "pathString", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "GradlePreviewLoggerAdapter", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractConfigureDesktopPreviewTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractConfigureDesktopPreviewTask.kt\norg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask\n+ 2 providerUtils.kt\norg/jetbrains/compose/internal/utils/ProviderUtilsKt\n*L\n1#1,132:1\n22#2:133\n*S KotlinDebug\n*F\n+ 1 AbstractConfigureDesktopPreviewTask.kt\norg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask\n*L\n25#1:133\n*E\n"})
public abstract class AbstractConfigureDesktopPreviewTask
extends AbstractComposeDesktopTask {
    public FileCollection previewClasspath;
    public FileCollection skikoRuntime;
    @NotNull
    private final Property<String> javaHome;
    @NotNull
    private final ListProperty<String> jvmArgs;
    @NotNull
    private final Provider<String> previewTarget;
    @NotNull
    private final Provider<String> idePort;
    @NotNull
    private final FileCollection uiTooling;
    @NotNull
    private final FileCollection hostClasspath;

    /*
     * WARNING - void declaration
     */
    public AbstractConfigureDesktopPreviewTask() {
        void $this$javaHome_u24lambda_u240;
        Property property;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty22 = false;
        Property property2 = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property $i$f$notNullProperty22 = property = property2;
        AbstractConfigureDesktopPreviewTask abstractConfigureDesktopPreviewTask = this;
        boolean bl = false;
        $this$javaHome_u24lambda_u240.set(this.getProviders().systemProperty("java.home"));
        abstractConfigureDesktopPreviewTask.javaHome = property;
        ListProperty listProperty = this.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(String::class.java)");
        this.jvmArgs = listProperty;
        Provider provider = this.getProject().getProviders().gradleProperty("compose.desktop.preview.target");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.providers.gradle\u2026.desktop.preview.target\")");
        this.previewTarget = provider;
        Provider provider2 = this.getProject().getProviders().gradleProperty("compose.desktop.preview.ide.port");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.gradle\u2026esktop.preview.ide.port\")");
        this.idePort = provider2;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.uiTooling = (FileCollection)GradleUtilsKt.excludeTransitiveDependencies(GradleUtilsKt.detachedComposeDependency(project, "ui-tooling-desktop", "org.jetbrains.compose.ui"));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.hostClasspath = (FileCollection)GradleUtilsKt.detachedComposeGradleDependency$default(project2, "preview-rpc", null, 2, null);
    }

    @InputFiles
    @NotNull
    public final FileCollection getPreviewClasspath$compose() {
        FileCollection fileCollection = this.previewClasspath;
        if (fileCollection != null) {
            return fileCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previewClasspath");
        return null;
    }

    public final void setPreviewClasspath$compose(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.previewClasspath = fileCollection;
    }

    @InputFiles
    @NotNull
    public final FileCollection getSkikoRuntime$compose() {
        FileCollection fileCollection = this.skikoRuntime;
        if (fileCollection != null) {
            return fileCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"skikoRuntime");
        return null;
    }

    public final void setSkikoRuntime$compose(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.skikoRuntime = fileCollection;
    }

    @Internal
    @NotNull
    public final Property<String> getJavaHome$compose() {
        return this.javaHome;
    }

    @Input
    @Optional
    @NotNull
    public final ListProperty<String> getJvmArgs$compose() {
        return this.jvmArgs;
    }

    @Optional
    @Input
    @NotNull
    public final Provider<String> getPreviewTarget$compose() {
        return this.previewTarget;
    }

    @Optional
    @Input
    @NotNull
    public final Provider<String> getIdePort$compose() {
        return this.idePort;
    }

    @InputFiles
    @NotNull
    public final FileCollection getUiTooling$compose() {
        return this.uiTooling;
    }

    @InputFiles
    @NotNull
    public final FileCollection getHostClasspath$compose() {
        return this.hostClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Object object = this.javaHome.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaHome.get()");
        String string = OsUtilsKt.javaExecutable((String)object);
        Set set = this.hostClasspath.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"hostClasspath.files");
        PreviewHostConfig hostConfig = new PreviewHostConfig(string, this.pathString((Sequence<? extends File>)CollectionsKt.asSequence((Iterable)set)));
        Set set2 = this.getPreviewClasspath$compose().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"previewClasspath.files");
        Sequence sequence = CollectionsKt.asSequence((Iterable)set2);
        Set set3 = this.uiTooling.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"uiTooling.files");
        Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)set3));
        Set set4 = this.getSkikoRuntime$compose().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"skikoRuntime.files");
        String previewClasspathString = this.pathString((Sequence<? extends File>)SequencesKt.plus((Sequence)sequence2, (Sequence)CollectionsKt.asSequence((Iterable)set4)));
        Logger gradleLogger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)gradleLogger, (String)"gradleLogger");
        GradlePreviewLoggerAdapter previewLogger = new GradlePreviewLoggerAdapter(gradleLogger);
        Object object2 = this.idePort.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"idePort.get()");
        RemoteConnection connection2 = RemoteConnectionKt.getLocalConnectionOrNull(Integer.parseInt((String)object2), previewLogger, (Function0<Unit>)((Function0)run.connection.1.INSTANCE));
        if (connection2 != null) {
            AutoCloseable autoCloseable = connection2;
            Throwable throwable = null;
            try {
                RemoteConnection it = (RemoteConnection)autoCloseable;
                boolean bl = false;
                Object object3 = this.previewTarget.get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"previewTarget.get()");
                CommandsKt.sendConfigFromGradle(connection2, hostConfig, previewClasspathString, (String)object3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            gradleLogger.error("Could not connect to IDE");
        }
    }

    @NotNull
    public final FileCollection tryGetSkikoRuntimeIfNeeded$compose() {
        try {
            boolean hasSkikoJvm = false;
            boolean hasSkikoJvmRuntime = false;
            String skikoVersion = null;
            Object object = this.getPreviewClasspath$compose().getFiles().iterator();
            while (object.hasNext()) {
                File file2 = (File)object.next();
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                String string2 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                if (StringsKt.startsWith$default((String)string2, (String)"skiko-awt-runtime-", (boolean)false, (int)2, null)) {
                    hasSkikoJvmRuntime = true;
                    continue;
                }
                String string3 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
                if (!StringsKt.startsWith$default((String)string3, (String)"skiko-awt-", (boolean)false, (int)2, null)) continue;
                hasSkikoJvm = true;
                String string4 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.name");
                skikoVersion = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string4, (CharSequence)"skiko-awt-"), (CharSequence)".jar");
            }
            if (hasSkikoJvmRuntime) {
                ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files()");
                return (FileCollection)configurableFileCollection;
            }
            if (hasSkikoJvm && !((object = (CharSequence)skikoVersion) == null || StringsKt.isBlank((CharSequence)object))) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return (FileCollection)GradleUtilsKt.excludeTransitiveDependencies(GradleUtilsKt.detachedDependency(project, "org.jetbrains.skiko", "skiko-awt-runtime-" + OsUtilsKt.getCurrentTarget().getId(), skikoVersion));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files()");
        return (FileCollection)configurableFileCollection;
    }

    private final String pathString(Sequence<? extends File> $this$pathString) {
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return SequencesKt.joinToString$default($this$pathString, (CharSequence)string, null, null, (int)0, null, (Function1)pathString.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask$GradlePreviewLoggerAdapter;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "isEnabled", "", "()Z", "log", "", "s", "", "compose"})
    private static final class GradlePreviewLoggerAdapter
    extends PreviewLogger {
        @NotNull
        private final Logger logger;

        public GradlePreviewLoggerAdapter(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @Override
        public boolean isEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void log(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.logger.info("Compose Preview: " + s);
        }
    }
}

