/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.protocol;

import java.io.IOException;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpEntity;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpEntityEnclosingRequest;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpRequest;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpRequestInterceptor;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpVersion;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.ProtocolVersion;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.config.RequestConfig;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.protocol.HttpClientContext;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

