/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.proxy.MapperProxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapperManager.class);
    public static final Map<String, Map<String, Mapper>> MAPPER_SPI_MAP = new HashMap<String, Map<String, Mapper>>();
    private static final MapperManager INSTANCE = new MapperManager();
    private boolean dataSourceLogEnable;

    private MapperManager() {
        this.loadInitial();
    }

    public static MapperManager instance(boolean isDataSourceLogEnable) {
        MapperManager.INSTANCE.dataSourceLogEnable = isDataSourceLogEnable;
        return INSTANCE;
    }

    public synchronized void loadInitial() {
        Collection mappers = NacosServiceLoader.load(Mapper.class);
        for (Mapper mapper : mappers) {
            MapperManager.putMapper(mapper);
            LOGGER.info("[MapperManager] Load Mapper({}) datasource({}) tableName({}) successfully.", new Object[]{mapper.getClass(), mapper.getDataSource(), mapper.getTableName()});
        }
    }

    public static synchronized void join(Mapper mapper) {
        if (Objects.isNull(mapper)) {
            return;
        }
        MapperManager.putMapper(mapper);
        LOGGER.info("[MapperManager] join successfully.");
    }

    private static void putMapper(Mapper mapper) {
        Map mapperMap = MAPPER_SPI_MAP.computeIfAbsent(mapper.getDataSource(), key -> new HashMap(16));
        mapperMap.putIfAbsent(mapper.getTableName(), mapper);
    }

    public <R extends Mapper> R findMapper(String dataSource, String tableName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[MapperManager] findMapper dataSource: {}, tableName: {}", (Object)dataSource, (Object)tableName);
        }
        if (StringUtils.isBlank((CharSequence)dataSource) || StringUtils.isBlank((CharSequence)tableName)) {
            throw new NacosRuntimeException(102, "dataSource or tableName is null");
        }
        Map<String, Mapper> tableMapper = MAPPER_SPI_MAP.get(dataSource);
        if (Objects.isNull(tableMapper)) {
            throw new NacosRuntimeException(102, "[MapperManager] Failed to find the datasource,dataSource:" + dataSource);
        }
        Mapper mapper = tableMapper.get(tableName);
        if (Objects.isNull(mapper)) {
            throw new NacosRuntimeException(103, "[MapperManager] Failed to find the table ,tableName:" + tableName);
        }
        if (this.dataSourceLogEnable) {
            return (R)((Mapper)MapperProxy.createSingleProxy(mapper));
        }
        return (R)mapper;
    }
}

